/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.workflow.mdsd.validation;

import de.uka.ipd.sdq.errorhandling.core.SeverityAndIssue;
import de.uka.ipd.sdq.errorhandling.dialogs.issues.DisplayIssuesDialog;
import de.uka.ipd.sdq.workflow.jobs.CleanupFailedException;
import de.uka.ipd.sdq.workflow.jobs.IJob;
import de.uka.ipd.sdq.workflow.jobs.JobFailedException;
import de.uka.ipd.sdq.workflow.jobs.UserCanceledException;
import de.uka.ipd.sdq.workflow.launchconfig.core.AbstractWorkflowBasedRunConfiguration;
import de.uka.ipd.sdq.workflow.mdsd.validation.ModelValidationJob;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.PlatformUI;

public class ShowValidationErrorsJob
implements IJob {
    private final ModelValidationJob[] validationJobs;
    private final Logger logger = Logger.getLogger(ShowValidationErrorsJob.class);
    private final AbstractWorkflowBasedRunConfiguration configuration;

    public ShowValidationErrorsJob(AbstractWorkflowBasedRunConfiguration configuration, ModelValidationJob ... validationJobs) {
        this.validationJobs = validationJobs;
        this.configuration = configuration;
    }

    public void execute(IProgressMonitor monitor) throws JobFailedException, UserCanceledException {
        ArrayList<SeverityAndIssue> result = new ArrayList<SeverityAndIssue>();
        ModelValidationJob[] modelValidationJobArray = this.validationJobs;
        int n = this.validationJobs.length;
        int n2 = 0;
        while (n2 < n) {
            ModelValidationJob validationJob = modelValidationJobArray[n2];
            result.addAll(validationJob.getResult());
            ++n2;
        }
        if (result.size() > 0) {
            if (this.logger.isEnabledFor((Priority)Level.WARN)) {
                this.logger.warn((Object)"Found validation problems in the models");
            }
            this.displayValidationErrors(result);
            if (this.logger.isEnabledFor((Priority)Level.WARN)) {
                this.logger.warn((Object)"Continuing workflow, ignoring model validation issues");
            }
        }
    }

    public String getName() {
        return "Show validation errors";
    }

    public void cleanup(IProgressMonitor monitor) throws CleanupFailedException {
    }

    private void displayValidationErrors(List<SeverityAndIssue> overallResult) throws UserCanceledException {
        DisplayIssuesDialog runner = new DisplayIssuesDialog(overallResult);
        if (this.configuration.isInteractive()) {
            PlatformUI.getWorkbench().getDisplay().syncExec((Runnable)runner);
            if (!runner.shouldProceedAfterErrorDialog()) {
                throw new UserCanceledException();
            }
        }
    }
}

