/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.workflow.extension;

import de.uka.ipd.sdq.workflow.extension.AbstractWorkflowExtensionConfigurationBuilder;
import de.uka.ipd.sdq.workflow.extension.AbstractWorkflowExtensionJob;
import de.uka.ipd.sdq.workflow.extension.WorkflowExtension;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;

public class ExtensionHelper {
    private static final Logger LOGGER = Logger.getLogger(ExtensionHelper.class);
    private static final String WORKFLOW_EXTENSION_POINT_ID = "de.uka.ipd.sdq.workflow.job";
    private static final String WORKFLOW_EXTENSION_POINT_ATTRIBUTE_EXTENSION_JOB = "extension_job";
    private static final String WORKFLOW_EXTENSION_POINT_ATTRIBUTE_EXTENSION_CONFIGURATION_BUILDER = "extension_configurationbuilder";
    private static final String WORKFLOW_EXTENSION_POINT_ATTRIBUTE_PRIORITY = "priority";
    private static final String WORKFLOW_EXTENSION_POINT_ATTRIBUTE_WORKFLOW_ID = "workflow_id";

    public static List<WorkflowExtension> getWorkflowExtensionsSortedByPriority(String workflowId) {
        List<WorkflowExtension> extensions = ExtensionHelper.getWorkflowExtensions(workflowId);
        Collections.sort(extensions, new Comparator<WorkflowExtension>(){

            @Override
            public int compare(WorkflowExtension workflowExtensionA, WorkflowExtension workflowExtensionB) {
                if (workflowExtensionA.getPriority() < workflowExtensionB.getPriority()) {
                    return -1;
                }
                if (workflowExtensionA.getPriority() == workflowExtensionB.getPriority()) {
                    return 0;
                }
                return 1;
            }
        });
        return extensions;
    }

    public static List<WorkflowExtension> getWorkflowExtensions(String workflowId) {
        ArrayList<WorkflowExtension> extensions = new ArrayList<WorkflowExtension>();
        IExtension[] registeredExtensions = ExtensionHelper.getRegisteredWorkflowExtensions();
        if (registeredExtensions == null) {
            return extensions;
        }
        int i = 0;
        while (i < registeredExtensions.length) {
            IExtension registeredExtension = registeredExtensions[i];
            IConfigurationElement[] elements = registeredExtension.getConfigurationElements();
            int j = 0;
            while (j < elements.length) {
                IConfigurationElement element = elements[j];
                String workflId = element.getAttribute(WORKFLOW_EXTENSION_POINT_ATTRIBUTE_WORKFLOW_ID);
                if (workflId != null && workflId.equals(workflowId)) {
                    String priorityString;
                    WorkflowExtension extension = new WorkflowExtension(registeredExtension.getUniqueIdentifier(), workflowId);
                    try {
                        Object o = element.createExecutableExtension(WORKFLOW_EXTENSION_POINT_ATTRIBUTE_EXTENSION_JOB);
                        if (o != null && o instanceof AbstractWorkflowExtensionJob) {
                            extension.setWorkflowExtensionJob((AbstractWorkflowExtensionJob)o);
                        }
                    }
                    catch (CoreException e) {
                        LOGGER.error((Object)"Unable to load extension job");
                    }
                    try {
                        Object o;
                        String builderAttribute = element.getAttribute(WORKFLOW_EXTENSION_POINT_ATTRIBUTE_EXTENSION_CONFIGURATION_BUILDER);
                        if (builderAttribute != null && !builderAttribute.isEmpty() && (o = element.createExecutableExtension(WORKFLOW_EXTENSION_POINT_ATTRIBUTE_EXTENSION_CONFIGURATION_BUILDER)) != null && o instanceof AbstractWorkflowExtensionConfigurationBuilder) {
                            extension.setExtensionConfigurationBuilder((AbstractWorkflowExtensionConfigurationBuilder)o);
                        }
                    }
                    catch (CoreException e) {
                        LOGGER.error((Object)"Failed to load extension job configuration builder");
                    }
                    if ((priorityString = element.getAttribute(WORKFLOW_EXTENSION_POINT_ATTRIBUTE_PRIORITY)) != null) {
                        try {
                            extension.setPriority(Integer.parseInt(priorityString));
                        }
                        catch (NumberFormatException e) {
                            LOGGER.error((Object)"Failed to load process extension job priority.");
                        }
                    }
                    extensions.add(extension);
                }
                ++j;
            }
            ++i;
        }
        return extensions;
    }

    private static IExtension[] getRegisteredWorkflowExtensions() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        if (registry == null) {
            return null;
        }
        IExtensionPoint extensionPoint = registry.getExtensionPoint(WORKFLOW_EXTENSION_POINT_ID);
        if (extensionPoint == null) {
            return null;
        }
        IExtension[] extensions = extensionPoint.getExtensions();
        return extensions;
    }
}

