/*
 * Decompiled with CFR 0.152.
 */
package org.scaledl.usageevolution.wizard.wizards;

import java.util.ArrayList;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.typed.BeanProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.ui.dialogs.WorkspaceResourceDialog;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.scaledl.usageevolution.wizard.wizards.PatternFilter;
import org.scaledl.usageevolution.wizard.wizards.UsageEvolutionSetupModel;

public class SelectLoadLIMBOPage
extends WizardPage {
    private Text textLimboFileName;
    private UsageEvolutionSetupModel model;
    private Label lblSelectLimboDlim;

    public SelectLoadLIMBOPage(ISelection selection) {
        super("wizardPage3");
        this.setTitle("Create Usage Evolution Model (step 3 of 3)");
        this.setDescription("Select a DLIM model created with the LIMBO tool that defines the load evolution\n(leave empty to define this at a later stage)");
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        container.setLayout((Layout)new GridLayout(2, false));
        this.lblSelectLimboDlim = new Label(container, 0);
        this.lblSelectLimboDlim.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
        this.lblSelectLimboDlim.setText(" Select LIMBO DLIM model");
        Button btnNewButton = new Button(container, 0);
        btnNewButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectLoadLIMBOPage.this.handleBrowse();
            }
        });
        btnNewButton.setText("Browse...");
        this.textLimboFileName = new Text(container, 2048);
        this.textLimboFileName.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.initDataBindings();
    }

    public void handleBrowse() {
        ArrayList<PatternFilter> filters = new ArrayList<PatternFilter>();
        filters.add(new PatternFilter("dlim"));
        IFile[] files = WorkspaceResourceDialog.openFileSelection((Shell)this.getShell(), null, (String)"Select usage model", (boolean)false, null, filters);
        if (files.length != 0 && files[0] != null) {
            String portableString = files[0].getFullPath().toPortableString();
            this.model.setLoadLimboFileName(portableString);
        }
    }

    public void setModel(UsageEvolutionSetupModel setupModel) {
        this.model = setupModel;
    }

    protected DataBindingContext initDataBindings() {
        DataBindingContext bindingContext = new DataBindingContext();
        ISWTObservableValue observeTextTextLimboFileNameObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.textLimboFileName);
        IObservableValue loadLimboFileNameModelObserveValue = BeanProperties.value((String)"loadLimboFileName").observe((Object)this.model);
        bindingContext.bindValue((IObservableValue)observeTextTextLimboFileNameObserveWidget, loadLimboFileNameModelObserveValue, null, null);
        return bindingContext;
    }
}

