/*
 * Decompiled with CFR 0.152.
 */
package org.modelversioning.emfprofile.application.registry.ui.observer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import org.eclipse.core.commands.Command;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.services.ISourceProviderService;
import org.modelversioning.emfprofile.Stereotype;
import org.modelversioning.emfprofile.application.registry.ProfileApplicationDecorator;
import org.modelversioning.emfprofile.application.registry.ProfileApplicationRegistry;
import org.modelversioning.emfprofile.application.registry.ui.commands.sourceprovider.ToolbarCommandEnabledState;
import org.modelversioning.emfprofile.application.registry.ui.dialogs.ApplyStereotypeOnEObjectDialog;
import org.modelversioning.emfprofile.application.registry.ui.extensionpoint.decorator.EMFProfileApplicationDecorator;
import org.modelversioning.emfprofile.application.registry.ui.extensionpoint.decorator.PluginExtensionOperationsListener;
import org.modelversioning.emfprofile.application.registry.ui.extensionpoint.decorator.handler.EMFProfileApplicationDecoratorHandler;
import org.modelversioning.emfprofile.application.registry.ui.observer.DecoratableEditorPartListener;
import org.modelversioning.emfprofile.application.registry.ui.observer.ViewerState;
import org.modelversioning.emfprofile.application.registry.ui.views.filters.StereotypesOfEObjectViewerFilter;
import org.modelversioning.emfprofileapplication.StereotypeApplicability;
import org.modelversioning.emfprofileapplication.StereotypeApplication;

public class ActiveEditorObserver
implements PluginExtensionOperationsListener {
    public static ActiveEditorObserver INSTANCE = new ActiveEditorObserver();
    private Map<IWorkbenchPart, String> editorPartToModelIdMap = new HashMap<IWorkbenchPart, String>();
    private Map<IWorkbenchPart, ViewerState> editorPartToViewerStateMap = new HashMap<IWorkbenchPart, ViewerState>();
    private IWorkbenchPage activePage;
    private EMFProfileApplicationDecoratorHandler decoratorHandler;
    private TreeViewer viewer;
    private ToolbarCommandEnabledState toolbarCommandEnabeldStateService;
    private StereotypesOfEObjectViewerFilter viewerFilter = new StereotypesOfEObjectViewerFilter(null);
    private boolean viewerFilterActivated = false;
    private DecoratableEditorPartListener decoratableEditorPartListener;

    private ActiveEditorObserver() {
    }

    public IWorkbenchPart getLastActiveEditorPart() {
        return this.decoratableEditorPartListener.getLastActiveEditPart();
    }

    public void setViewer(TreeViewer viewer) {
        this.decoratorHandler = EMFProfileApplicationDecoratorHandler.getInstance();
        this.decoratorHandler.setPluginExtensionOperationsListener(INSTANCE);
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            throw new RuntimeException("could not locate workbench active window!");
        }
        ISourceProviderService sourceProviderService = (ISourceProviderService)window.getService(ISourceProviderService.class);
        this.toolbarCommandEnabeldStateService = (ToolbarCommandEnabledState)sourceProviderService.getSourceProvider("org.modelversioning.emfprofile.application.registry.ui.commands.sourceprovider.active");
        this.activePage = window.getActivePage();
        if (this.activePage == null) {
            throw new RuntimeException("could not locate active page for active window ");
        }
        this.viewer = viewer;
        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        Command cmd = commandService.getCommand("org.modelversioning.emfprofile.application.registry.ui.commands.stereotypeapplicationsonelement");
        this.setActivateViewFilter((Boolean)cmd.getState("org.eclipse.ui.commands.toggleState").getValue());
        IEditorPart editorPart = this.activePage.getActiveEditor();
        IEditorPart lastActiveEditorPart = null;
        if (editorPart != null && this.decoratorHandler.hasDecoratorForEditorPart((IWorkbenchPart)editorPart)) {
            this.editorPartToModelIdMap.put((IWorkbenchPart)editorPart, UUID.randomUUID().toString());
            lastActiveEditorPart = editorPart;
            this.toolbarCommandEnabeldStateService.setEnabled(true);
        }
        this.decoratableEditorPartListener = new DecoratableEditorPartListener(this.decoratorHandler, this.editorPartToModelIdMap, (IWorkbenchPart)lastActiveEditorPart, viewer, this.toolbarCommandEnabeldStateService, this.editorPartToViewerStateMap);
        this.activePage.addPartListener((IPartListener)this.decoratableEditorPartListener);
        PlatformUI.getWorkbench().addWorkbenchListener(new IWorkbenchListener(){

            public boolean preShutdown(IWorkbench workbench, boolean forced) {
                ActiveEditorObserver.this.cleanUp();
                ActiveEditorObserver.this.decoratableEditorPartListener.cleanUpForAllEditorParts();
                return true;
            }

            public void postShutdown(IWorkbench workbench) {
            }
        });
    }

    public void refreshViewer() {
        if (this.viewer == null || this.viewer.getTree().isDisposed()) {
            return;
        }
        this.viewer.getTree().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (ActiveEditorObserver.this.viewer.getInput().equals(Collections.emptyList())) {
                    ActiveEditorObserver.this.viewer.setInput((Object)ProfileApplicationRegistry.INSTANCE.getProfileApplications(ActiveEditorObserver.this.editorPartToModelIdMap.get(ActiveEditorObserver.this.decoratableEditorPartListener.getLastActiveEditPart())));
                } else {
                    ActiveEditorObserver.this.viewer.refresh();
                    ActiveEditorObserver.this.viewer.expandToLevel(2);
                }
            }
        });
    }

    public void refreshViewer(final Object object) {
        if (this.viewer == null || this.viewer.getTree().isDisposed()) {
            return;
        }
        this.viewer.getTree().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (object instanceof Collection) {
                    Iterator iterator = ((Collection)object).iterator();
                    while (iterator.hasNext()) {
                        ActiveEditorObserver.this.viewer.refresh(iterator.next());
                    }
                } else {
                    ActiveEditorObserver.this.viewer.refresh(object);
                }
                ActiveEditorObserver.this.viewer.expandToLevel(2);
            }
        });
    }

    public void updateViewer(final Object element) {
        if (this.viewer == null || this.viewer.getTree().isDisposed()) {
            return;
        }
        this.viewer.getTree().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                ActiveEditorObserver.this.viewer.update(element, null);
            }
        });
    }

    public void revealElement(final Object element) {
        if (this.viewer == null || this.viewer.getTree().isDisposed()) {
            return;
        }
        this.viewer.getTree().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                ActiveEditorObserver.this.viewer.reveal(element);
            }
        });
    }

    public String getModelIdForWorkbenchPart(IWorkbenchPart part) {
        return this.editorPartToModelIdMap.get(part);
    }

    @Override
    public void applyStereotype(EObject eObject) {
        Assert.isNotNull((Object)eObject);
        HashMap<ProfileApplicationDecorator, Collection<StereotypeApplicability>> profileToStereotypeApplicabilityForEObjectMap = new HashMap<ProfileApplicationDecorator, Collection<StereotypeApplicability>>();
        for (ProfileApplicationDecorator profileApplication : ProfileApplicationRegistry.INSTANCE.getProfileApplications(this.editorPartToModelIdMap.get(this.decoratableEditorPartListener.getLastActiveEditPart()))) {
            profileToStereotypeApplicabilityForEObjectMap.put(profileApplication, profileApplication.getApplicableStereotypes(eObject));
        }
        boolean mayApplyStereotype = false;
        for (Collection stereotypesApplicabilities : profileToStereotypeApplicabilityForEObjectMap.values()) {
            if (stereotypesApplicabilities.isEmpty()) continue;
            mayApplyStereotype = true;
            break;
        }
        if (mayApplyStereotype) {
            ApplyStereotypeOnEObjectDialog applySteretypeDialog = new ApplyStereotypeOnEObjectDialog(profileToStereotypeApplicabilityForEObjectMap);
            applySteretypeDialog.openApplyStereotypeDialog(eObject);
        } else {
            MessageDialog.openInformation((Shell)this.viewer.getControl().getShell(), (String)"Info", (String)("Can not apply any stereotype to EObject: " + eObject.toString()));
        }
    }

    @Override
    public void eObjectSelected(EObject eObject) {
        if (eObject == null) {
            if (this.viewerFilter.getSelectedEObject() != null) {
                this.viewerFilter.setSelectedEObject(eObject);
                if (this.viewerFilterActivated) {
                    this.refreshViewer();
                }
            }
        } else if (!eObject.equals(this.viewerFilter.getSelectedEObject())) {
            this.viewerFilter.setSelectedEObject(eObject);
            if (this.viewerFilterActivated) {
                this.refreshViewer();
            }
        }
    }

    public void setActivateViewFilter(boolean activateFilter) {
        this.viewerFilterActivated = activateFilter;
        if (activateFilter) {
            this.viewer.addFilter((ViewerFilter)this.viewerFilter);
        } else {
            this.viewer.removeFilter((ViewerFilter)this.viewerFilter);
        }
        this.viewer.expandToLevel(2);
    }

    private void showError(String message, Throwable throwable) {
        ErrorDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Error Occured", (String)message, (IStatus)new Status(4, "org.modelversioning.emfprofile.application.registry.ui", throwable.getMessage(), throwable));
    }

    public void refreshDecorations(Collection<EObject> eObjects) {
        for (EObject eObject : eObjects) {
            this.refreshDecoration(eObject);
        }
    }

    public void refreshDecoration(final EObject eObject) {
        EMFProfileApplicationDecorator decorator;
        if (this.decoratableEditorPartListener.getCleaningUpForEditorPart() != null) {
            if (this.decoratableEditorPartListener.isCleaningUpForClosedEditorPart()) {
                return;
            }
            decorator = this.decoratorHandler.getDecoratorForEditorPart(this.decoratableEditorPartListener.getCleaningUpForEditorPart());
        } else {
            decorator = this.decoratorHandler.getDecoratorForEditorPart(this.decoratableEditorPartListener.getLastActiveEditPart());
        }
        final ArrayList<Image> images = new ArrayList<Image>();
        final ArrayList<String> toolTipTexts = new ArrayList<String>();
        for (ProfileApplicationDecorator profileApplication : ProfileApplicationRegistry.INSTANCE.getProfileApplications(this.getModelIdForWorkbenchPart(this.decoratableEditorPartListener.getLastActiveEditPart()))) {
            EList stereotypeApplications = profileApplication.getStereotypeApplications(eObject);
            for (StereotypeApplication stereotypeApplication : stereotypeApplications) {
                images.add(((ILabelProvider)this.viewer.getLabelProvider()).getImage((Object)stereotypeApplication));
                toolTipTexts.add(this.getStereotypeLabel(stereotypeApplication));
            }
        }
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((Resource)eObject.eResource());
                    if (editingDomain != null) {
                        editingDomain.runExclusive(new Runnable(){

                            @Override
                            public void run() {
                                decorator.decorate(eObject, images, toolTipTexts);
                            }
                        });
                    } else {
                        decorator.decorate(eObject, images, toolTipTexts);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    ActiveEditorObserver.this.showError("Calling decorate method on decorator for editor id: " + ActiveEditorObserver.this.decoratableEditorPartListener.getLastActiveEditPart().getSite().getId() + " throw an exception:", e);
                }
            }
        });
    }

    private String getStereotypeLabel(StereotypeApplication stereotypeApplication) {
        if (stereotypeApplication.eClass() instanceof Stereotype) {
            return "<<" + ((Stereotype)stereotypeApplication.eClass()).getName() + ">>";
        }
        return "Stereotype application";
    }

    public void cleanUp() {
        this.decoratorHandler.unsetPluginExtensionOperationsListener();
        this.activePage.removePartListener((IPartListener)this.decoratableEditorPartListener);
        if (!PlatformUI.getWorkbench().isClosing()) {
            this.decoratableEditorPartListener.cleanUpForAllEditorParts();
        }
    }

    public void setProfileApplicationChanged() {
        this.viewer.getTree().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                ISelection selection = ActiveEditorObserver.this.viewer.getSelection();
                if (selection != null && selection instanceof IStructuredSelection) {
                    EObject eObject = (EObject)((IStructuredSelection)selection).getFirstElement();
                    if (eObject == null) {
                        return;
                    }
                    ProfileApplicationDecorator profileApplication = ActiveEditorObserver.this.findProfileApplicationDecorator(eObject);
                    if (profileApplication == null) {
                        return;
                    }
                    profileApplication.setDirty(true);
                    ActiveEditorObserver.this.updateViewer(profileApplication);
                }
            }
        });
    }

    public ProfileApplicationDecorator findProfileApplicationDecorator(EObject eObject) {
        return ProfileApplicationRegistry.INSTANCE.getProfileApplicationDecoratorOfContainedEObject(this.editorPartToModelIdMap.get(this.decoratableEditorPartListener.getLastActiveEditPart()), eObject);
    }
}

