/*
 * Decompiled with CFR 0.152.
 */
package org.modelversioning.emfprofile.application.registry.ui.providers;

import java.net.URL;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;
import org.modelversioning.emfprofile.Stereotype;
import org.modelversioning.emfprofile.application.registry.ProfileApplicationDecorator;
import org.modelversioning.emfprofile.application.registry.ui.views.EMFProfileApplicationsView;
import org.modelversioning.emfprofileapplication.StereotypeApplicability;
import org.modelversioning.emfprofileapplication.StereotypeApplication;

public class ProfileProviderLabelAdapter
implements ILabelProvider {
    private AdapterFactoryLabelProvider provider;

    public ProfileProviderLabelAdapter(ComposedAdapterFactory adapterFactory) {
        this.provider = new AdapterFactoryLabelProvider((AdapterFactory)adapterFactory);
    }

    private ILabelProvider getLabelProvider(Object element) {
        return this.provider;
    }

    public void addListener(ILabelProviderListener listener) {
        this.provider.addListener(listener);
    }

    public void dispose() {
        this.provider.dispose();
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
        this.provider.removeListener(listener);
    }

    public Image getImage(Object element) {
        URL url;
        Stereotype stereotype = null;
        if (element instanceof StereotypeApplication) {
            stereotype = ((StereotypeApplication)element).getStereotype();
        } else if (element instanceof StereotypeApplicability) {
            stereotype = ((StereotypeApplicability)element).getStereotype();
        }
        if (stereotype != null && stereotype.hasIcon() && (url = this.getPlatformURLToImageOfStereotype(stereotype)) != null) {
            try {
                Image image = EMFProfileApplicationsView.createImage(ImageDescriptor.createFromURL((URL)url));
                return image;
            }
            catch (Exception e) {
                e.printStackTrace();
                System.err.println(e.getMessage());
            }
        }
        return this.getLabelProvider(element).getImage(element);
    }

    private URL getPlatformURLToImageOfStereotype(Stereotype stereotype) {
        URL url = null;
        try {
            String uriToProfileResource = EcoreUtil.getURI((EObject)stereotype.getProfile()).toString();
            String strResource = "resource/";
            String result = uriToProfileResource.substring(0, uriToProfileResource.indexOf("/", uriToProfileResource.indexOf(strResource) + strResource.length() + 1) + 1);
            result = String.valueOf(result) + stereotype.getIconPath();
            url = new URL(result);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println(e.getMessage());
        }
        return url;
    }

    public String getText(Object element) {
        if (element instanceof ProfileApplicationDecorator) {
            ProfileApplicationDecorator profileApplicationDecorator = (ProfileApplicationDecorator)element;
            return profileApplicationDecorator.isDirty() ? "*" + profileApplicationDecorator.getName() : profileApplicationDecorator.getName();
        }
        return this.getLabelProvider(element).getText(element);
    }
}

