/*
 * Decompiled with CFR 0.152.
 */
package org.modelversioning.emfprofile.application.registry.ui.commands.handlers;

import java.io.IOException;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.handlers.HandlerUtil;
import org.modelversioning.emfprofile.application.registry.ProfileApplicationDecorator;
import org.modelversioning.emfprofile.application.registry.ui.observer.ActiveEditorObserver;

public class SaveProfileApplicationHandler
extends AbstractHandler
implements IHandler {
    public static final String COMMAND_ID = "org.modelversioning.emfprofile.application.registry.ui.commands.saveprofileapplication";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection currentSelection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (currentSelection != null && currentSelection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)currentSelection;
            Object element = structuredSelection.getFirstElement();
            if (element instanceof ProfileApplicationDecorator) {
                final ProfileApplicationDecorator profileApplication = (ProfileApplicationDecorator)element;
                WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

                    public void execute(IProgressMonitor monitor) {
                        try {
                            try {
                                profileApplication.save();
                            }
                            catch (IOException | CoreException e) {
                                SaveProfileApplicationHandler.this.showError("Error while saving profile application resource", e);
                                ActiveEditorObserver.INSTANCE.updateViewer(profileApplication);
                            }
                        }
                        finally {
                            ActiveEditorObserver.INSTANCE.updateViewer(profileApplication);
                        }
                    }
                };
                try {
                    new ProgressMonitorDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell()).run(true, false, (IRunnableWithProgress)operation);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.showError("Error while saving profile application resource", e);
                }
            } else {
                MessageDialog.openInformation((Shell)HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getShell(), (String)"Not a profile facade selected", (String)("selection: " + currentSelection.toString()));
            }
        } else {
            MessageDialog.openInformation((Shell)HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getShell(), (String)"Info", (String)"no selection in view");
        }
        return null;
    }

    private void showError(String message, Throwable throwable) {
        ErrorDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Error Occured", (String)message, (IStatus)new Status(4, "org.modelversioning.emfprofile.application.registry.ui", throwable.getMessage(), throwable));
    }
}

