/*
 * Decompiled with CFR 0.152.
 */
package org.modelversioning.emfprofile.application.registry.ui.observer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;
import org.modelversioning.emfprofile.application.registry.ProfileApplicationDecorator;
import org.modelversioning.emfprofile.application.registry.ProfileApplicationRegistry;
import org.modelversioning.emfprofile.application.registry.ui.commands.sourceprovider.ToolbarCommandEnabledState;
import org.modelversioning.emfprofile.application.registry.ui.extensionpoint.decorator.handler.EMFProfileApplicationDecoratorHandler;
import org.modelversioning.emfprofile.application.registry.ui.observer.ViewerState;

public final class DecoratableEditorPartListener
implements IPartListener {
    private EMFProfileApplicationDecoratorHandler decoratorHandler;
    private Map<IWorkbenchPart, String> editorPartToModelIdMap;
    private IWorkbenchPart lastActiveEditorPart;
    private IWorkbenchPart cleaningUpForEditorPart = null;
    private TreeViewer viewer;
    private ToolbarCommandEnabledState toolbarCommandEnabeldStateService;
    private Map<IWorkbenchPart, ViewerState> editorPartToViewerStateMap;
    private boolean cleaningUpForClosedEditor = false;
    IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
    ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
    Command unloadCmd = this.commandService.getCommand("org.modelversioning.emfprofile.application.registry.ui.commands.unloadprofileapplication");

    public DecoratableEditorPartListener(EMFProfileApplicationDecoratorHandler decoratorHandler, Map<IWorkbenchPart, String> editorPartToModelIdMap, IWorkbenchPart lastActiveEditorPart, TreeViewer viewer, ToolbarCommandEnabledState toolbarCommandEnabeldStateService, Map<IWorkbenchPart, ViewerState> editorPartToViewerStateMap) {
        this.decoratorHandler = decoratorHandler;
        this.editorPartToModelIdMap = editorPartToModelIdMap;
        this.lastActiveEditorPart = lastActiveEditorPart;
        this.viewer = viewer;
        this.toolbarCommandEnabeldStateService = toolbarCommandEnabeldStateService;
        this.editorPartToViewerStateMap = editorPartToViewerStateMap;
    }

    public void partOpened(IWorkbenchPart part) {
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
        if (this.decoratorHandler.hasDecoratorForEditorPart(part) && this.editorPartToModelIdMap.containsKey(part)) {
            if (part.equals(this.lastActiveEditorPart)) {
                this.setLastActiveEditorPart(null);
                try {
                    this.viewer.setInput(Collections.emptyList());
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
            this.cleaningUpForClosedEditor = true;
            this.cleanUp(part);
            this.cleaningUpForClosedEditor = false;
            this.editorPartToViewerStateMap.remove(part);
            this.editorPartToModelIdMap.remove(part);
        }
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partActivated(IWorkbenchPart part) {
        if (this.decoratorHandler.hasDecoratorForEditorPart(part)) {
            if (this.editorPartToModelIdMap.containsKey(part)) {
                if (!part.equals(this.lastActiveEditorPart)) {
                    if (this.lastActiveEditorPart != null) {
                        this.editorPartToViewerStateMap.put(this.lastActiveEditorPart, new ViewerState(this.viewer));
                    }
                    this.editorPartToViewerStateMap.get(part).restoreTreeViewerState(this.viewer);
                    this.editorPartToViewerStateMap.remove(part);
                }
            } else {
                this.editorPartToModelIdMap.put(part, UUID.randomUUID().toString());
                if (this.lastActiveEditorPart != null) {
                    this.editorPartToViewerStateMap.put(this.lastActiveEditorPart, new ViewerState(this.viewer));
                    this.viewer.setInput(Collections.emptyList());
                }
            }
            this.setLastActiveEditorPart((IEditorPart)part);
        } else if (part instanceof IEditorPart && this.lastActiveEditorPart != null) {
            this.editorPartToViewerStateMap.put(this.lastActiveEditorPart, new ViewerState(this.viewer));
            this.setLastActiveEditorPart(null);
            this.viewer.setInput(Collections.emptyList());
        }
    }

    private void setLastActiveEditorPart(IEditorPart editorPart) {
        this.lastActiveEditorPart = editorPart;
        if (this.lastActiveEditorPart == null) {
            this.toolbarCommandEnabeldStateService.setEnabled(false);
        } else {
            this.toolbarCommandEnabeldStateService.setEnabled(true);
        }
    }

    public IWorkbenchPart getLastActiveEditPart() {
        return this.lastActiveEditorPart;
    }

    public IWorkbenchPart getCleaningUpForEditorPart() {
        return this.cleaningUpForEditorPart;
    }

    public void cleanUpForAllEditorParts() {
        for (IWorkbenchPart editorPart : this.editorPartToModelIdMap.keySet()) {
            this.cleanUp(editorPart);
        }
        this.editorPartToModelIdMap.clear();
        this.editorPartToViewerStateMap.clear();
    }

    private void cleanUp(IWorkbenchPart editorPart) {
        this.cleaningUpForEditorPart = editorPart;
        String modelId = this.editorPartToModelIdMap.get(editorPart);
        ArrayList profileApplications = new ArrayList(ProfileApplicationRegistry.INSTANCE.getProfileApplications(modelId));
        for (ProfileApplicationDecorator profileApplication : profileApplications) {
            ExecutionEvent executionEvent = this.handlerService.createExecutionEvent(this.unloadCmd, new Event());
            ((IEvaluationContext)executionEvent.getApplicationContext()).addVariable("selection", (Object)new StructuredSelection((Object)profileApplication));
            try {
                this.unloadCmd.executeWithChecks(executionEvent);
            }
            catch (ExecutionException | NotEnabledException | NotHandledException | NotDefinedException e) {
                System.err.println("Calling unload command");
                e.printStackTrace();
            }
        }
        ProfileApplicationRegistry.INSTANCE.unloadAllProfileApplicationsForModel(modelId);
        this.cleaningUpForEditorPart = null;
    }

    public boolean isCleaningUpForClosedEditorPart() {
        return this.cleaningUpForClosedEditor;
    }
}

