/*
 * Decompiled with CFR 0.152.
 */
package org.modelversioning.emfprofile.application.registry.ui.observer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.SubContributionItem;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ui.PlatformUI;
import org.modelversioning.emfprofile.application.registry.ProfileApplicationDecorator;
import org.modelversioning.emfprofile.application.registry.ui.observer.ActiveEditorObserver;
import org.modelversioning.emfprofileapplication.StereotypeApplication;

public class NestingCommonModelElementsInStereotypeApplications
implements ISelectionChangedListener,
IMenuListener {
    public static final String NESTING_COMMON_MODEL_ELEMENTS_MENU_NAME = "Nesting Common Model Elements Menu";
    public static final String NESTING_COMMON_MODEL_ELEMENTS_MENU_ID = "EMFProfileApplicationRegistryUI_NestingCommonModelElementsMenuID";
    public static final String UI_CREATE_CHILD_MENU_ITEM = "&New Child";
    public static final String UI_CREATE_SIBLING_MENU_ITEM = "N&ew Sibling";
    private Collection<IAction> createChildActions;
    private IMenuManager createChildMenuManager;
    private Collection<IAction> createSiblingActions;
    private IMenuManager createSiblingMenuManager;

    public void contributeToMenu(IMenuManager menuManager) {
        MenuManager submenuManager = new MenuManager(NESTING_COMMON_MODEL_ELEMENTS_MENU_NAME, NESTING_COMMON_MODEL_ELEMENTS_MENU_ID);
        menuManager.insertAfter("additions", (IContributionItem)submenuManager);
        submenuManager.add((IContributionItem)new Separator("settings"));
        submenuManager.add((IContributionItem)new Separator("actions"));
        submenuManager.add((IContributionItem)new Separator("additions"));
        submenuManager.add((IContributionItem)new Separator("additions-end"));
        this.createChildMenuManager = new MenuManager(UI_CREATE_CHILD_MENU_ITEM);
        submenuManager.insertBefore("additions", (IContributionItem)this.createChildMenuManager);
        this.createSiblingMenuManager = new MenuManager(UI_CREATE_SIBLING_MENU_ITEM);
        submenuManager.insertBefore("additions", (IContributionItem)this.createSiblingMenuManager);
        submenuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager menuManager) {
                menuManager.updateAll(true);
            }
        });
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ISelection selection;
        if (ActiveEditorObserver.INSTANCE.getLastActiveEditorPart() == null) {
            return;
        }
        if (this.createChildMenuManager != null) {
            this.depopulateManager((IContributionManager)this.createChildMenuManager, this.createChildActions);
        }
        if (this.createSiblingMenuManager != null) {
            this.depopulateManager((IContributionManager)this.createSiblingMenuManager, this.createSiblingActions);
        }
        if ((selection = event.getSelection()) instanceof IStructuredSelection && ((IStructuredSelection)selection).size() == 1) {
            EObject eObject = (EObject)((IStructuredSelection)selection).getFirstElement();
            if (eObject instanceof ProfileApplicationDecorator) {
                return;
            }
            ProfileApplicationDecorator profileApplication = ActiveEditorObserver.INSTANCE.findProfileApplicationDecorator(eObject);
            this.createChildActions = this.generateCreateChildActions(eObject, profileApplication);
            this.createSiblingActions = eObject instanceof StereotypeApplication ? Collections.emptyList() : this.generateCreateSiblingActions(eObject, profileApplication);
        }
        if (this.createChildMenuManager != null) {
            this.populateManager((IContributionManager)this.createChildMenuManager, this.createChildActions, null);
            this.createChildMenuManager.update(true);
        }
        if (this.createSiblingMenuManager != null) {
            this.populateManager((IContributionManager)this.createSiblingMenuManager, this.createSiblingActions, null);
            this.createSiblingMenuManager.update(true);
        }
    }

    private Collection<IAction> generateCreateChildActions(final EObject eObject, final ProfileApplicationDecorator profileApplication) {
        ArrayList<IAction> actions = new ArrayList<IAction>();
        EList references = eObject.eClass().getEAllContainments();
        for (final EReference reference : references) {
            final EClass type = NestingCommonModelElementsInStereotypeApplications.getInstantiableClass(reference.getEReferenceType());
            if (type == null || type.getName().equals("EAnnotation") || type.getName().equals("ETypeParameter") || type.getName().equals("EOperation") || type.getName().equals("EAttribute") || type.getName().equals("EGenericType")) continue;
            Action action = new Action(){

                public void run() {
                    EObject newEObject = EcoreUtil.create((EClass)type);
                    profileApplication.addNestedEObject(eObject, reference, newEObject);
                    ActiveEditorObserver.INSTANCE.refreshViewer(eObject);
                    ActiveEditorObserver.INSTANCE.updateViewer(profileApplication);
                    ActiveEditorObserver.INSTANCE.revealElement(newEObject);
                    boolean isEnabled = false;
                    if (reference.isMany()) {
                        if (reference.getUpperBound() == -1 || reference.getUpperBound() == -2) {
                            isEnabled = true;
                        } else if (((Collection)eObject.eGet((EStructuralFeature)reference)).size() < reference.getUpperBound()) {
                            isEnabled = true;
                        }
                    } else if (!eObject.eIsSet((EStructuralFeature)reference)) {
                        isEnabled = true;
                    }
                    this.setEnabled(isEnabled);
                }
            };
            action.setText(String.valueOf(reference.getName()) + " " + type.getName());
            action.setToolTipText(String.valueOf(reference.getName()) + " " + type.getName());
            action.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_ELEMENTS"));
            boolean isEnabled = false;
            if (reference.isMany()) {
                if (reference.getUpperBound() == -1 || reference.getUpperBound() == -2) {
                    isEnabled = true;
                } else if (((Collection)eObject.eGet((EStructuralFeature)reference)).size() < reference.getUpperBound()) {
                    isEnabled = true;
                }
            } else if (!eObject.eIsSet((EStructuralFeature)reference)) {
                isEnabled = true;
            }
            action.setEnabled(isEnabled);
            actions.add((IAction)action);
        }
        return actions;
    }

    private Collection<IAction> generateCreateSiblingActions(EObject eObject, ProfileApplicationDecorator profileApplication) {
        return this.generateCreateChildActions(eObject.eContainer(), profileApplication);
    }

    public void populateManager(IContributionManager manager, Collection<? extends IAction> actions, String contributionID) {
        if (actions != null) {
            for (IAction iAction : actions) {
                if (contributionID != null) {
                    manager.insertBefore(contributionID, iAction);
                    continue;
                }
                manager.add(iAction);
            }
        }
    }

    public void depopulateManager(IContributionManager manager, Collection<? extends IAction> actions) {
        if (actions != null) {
            IContributionItem[] items = manager.getItems();
            int i = 0;
            while (i < items.length) {
                IAction action;
                IContributionItem contributionItem = items[i];
                while (contributionItem instanceof SubContributionItem) {
                    contributionItem = ((SubContributionItem)contributionItem).getInnerItem();
                }
                if (contributionItem instanceof ActionContributionItem && actions.contains(action = ((ActionContributionItem)contributionItem).getAction())) {
                    manager.remove(contributionItem);
                }
                ++i;
            }
        }
    }

    public void menuAboutToShow(IMenuManager menuManager) {
        MenuManager submenuManager = null;
        submenuManager = new MenuManager(UI_CREATE_CHILD_MENU_ITEM);
        this.populateManager((IContributionManager)submenuManager, this.createChildActions, null);
        menuManager.insertBefore("edit", (IContributionItem)submenuManager);
        submenuManager = new MenuManager(UI_CREATE_SIBLING_MENU_ITEM);
        this.populateManager((IContributionManager)submenuManager, this.createSiblingActions, null);
        menuManager.insertBefore("edit", (IContributionItem)submenuManager);
    }

    private static EClass getInstantiableClass(EClass target) {
        if (!target.isAbstract()) {
            return target;
        }
        EList classifiers = target.getEPackage().getEClassifiers();
        for (Object object : classifiers) {
            EClass eClass;
            if (!(object instanceof EClass) || (eClass = (EClass)object).isAbstract() || !target.isSuperTypeOf(eClass)) continue;
            return eClass;
        }
        return null;
    }
}

