/*
 * Decompiled with CFR 0.152.
 */
package org.modelversioning.emfprofile.application.registry.ui.wizards;

import java.util.Collection;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.modelversioning.emfprofile.application.registry.ProfileApplicationDecorator;
import org.modelversioning.emfprofile.application.registry.ProfileApplicationRegistry;
import org.modelversioning.emfprofile.application.registry.ui.ProfileApplicationConstantsAndUtil;
import org.modelversioning.emfprofile.application.registry.ui.observer.ActiveEditorObserver;
import org.modelversioning.emfprofile.application.registry.ui.wizards.SelectProfileApplicationFilePage;
import org.modelversioning.emfprofileapplication.StereotypeApplication;

public class LoadProfileApplicationWizard
extends Wizard {
    private static final String PROFILE_APPLICATION_PAGE_NAME = "newFilePage1";
    private static final String WINDOW_TITLE = "Select Profile Application File";
    private IWorkbenchPart targetPart = null;
    private SelectProfileApplicationFilePage profileAppFilePage = null;

    public LoadProfileApplicationWizard() {
        this.setHelpAvailable(false);
        this.setWindowTitle(WINDOW_TITLE);
    }

    public boolean performFinish() {
        ProfileApplicationDecorator profileApplication;
        block5: {
            IFile profileApplicationFile = this.profileAppFilePage.getSelectedFile();
            String modelId = ActiveEditorObserver.INSTANCE.getModelIdForWorkbenchPart(this.targetPart);
            if (modelId == null) {
                throw new RuntimeException("Could not find modelId for a part: " + this.targetPart);
            }
            profileApplication = ProfileApplicationRegistry.INSTANCE.loadProfileApplicationForModel(modelId, profileApplicationFile, ProfileApplicationConstantsAndUtil.getResourceSet(this.targetPart));
            if (profileApplication != null) break block5;
            MessageDialog.openInformation((Shell)this.targetPart.getSite().getShell(), (String)"Profile Application already loaded", (String)("Profile Application already loaded from file: " + profileApplicationFile.getLocation().toString()));
            return false;
        }
        try {
            ActiveEditorObserver.INSTANCE.refreshViewer();
            BasicEList eObjects = new BasicEList();
            for (StereotypeApplication stereotypeApplication : profileApplication.getStereotypeApplications()) {
                eObjects.add((Object)stereotypeApplication.getAppliedTo());
            }
            ActiveEditorObserver.INSTANCE.refreshDecorations((Collection<EObject>)eObjects);
        }
        catch (Exception e) {
            Status status = new Status(4, "org.modelversioning.emfprofile.application.registry.ui", e.getMessage(), (Throwable)e);
            ErrorDialog.openError((Shell)this.targetPart.getSite().getShell(), (String)"Error Loading Profile Application", (String)e.getMessage(), (IStatus)status);
            return false;
        }
        return true;
    }

    public void addPages() {
        super.addPages();
        this.profileAppFilePage = new SelectProfileApplicationFilePage(PROFILE_APPLICATION_PAGE_NAME, WINDOW_TITLE, null);
        super.addPage((IWizardPage)this.profileAppFilePage);
    }

    public void setWorkbenchPart(IWorkbenchPart targetPart) {
        this.targetPart = targetPart;
    }
}

