package org.modelversioning.emfprofile.diagram.edit.policies;

import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.emf.commands.core.commands.DuplicateEObjectsCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DuplicateElementsRequest;
import org.modelversioning.emfprofile.diagram.edit.commands.EClassCreateCommand;
import org.modelversioning.emfprofile.diagram.edit.commands.EDataTypeCreateCommand;
import org.modelversioning.emfprofile.diagram.edit.commands.EEnumCreateCommand;
import org.modelversioning.emfprofile.diagram.edit.commands.EPackageCreateCommand;
import org.modelversioning.emfprofile.diagram.edit.commands.StereotypeCreateCommand;
import org.modelversioning.emfprofile.diagram.providers.EMFProfileElementTypes;

/**
 * @generated
 */
public class ProfileItemSemanticEditPolicy extends
		EMFProfileBaseItemSemanticEditPolicy {

	/**
	 * @generated
	 */
	public ProfileItemSemanticEditPolicy() {
		super(EMFProfileElementTypes.Profile_1000);
	}

	/**
	 * @generated
	 */
	protected Command getCreateCommand(CreateElementRequest req) {
		if (EMFProfileElementTypes.Stereotype_2006 == req.getElementType()) {
			return getGEFWrapper(new StereotypeCreateCommand(req));
		}
		if (EMFProfileElementTypes.EClass_2002 == req.getElementType()) {
			return getGEFWrapper(new EClassCreateCommand(req));
		}
		if (EMFProfileElementTypes.EPackage_2003 == req.getElementType()) {
			return getGEFWrapper(new EPackageCreateCommand(req));
		}
		if (EMFProfileElementTypes.EEnum_2004 == req.getElementType()) {
			return getGEFWrapper(new EEnumCreateCommand(req));
		}
		if (EMFProfileElementTypes.EDataType_2005 == req.getElementType()) {
			return getGEFWrapper(new EDataTypeCreateCommand(req));
		}
		return super.getCreateCommand(req);
	}

	/**
	 * @generated
	 */
	protected Command getDuplicateCommand(DuplicateElementsRequest req) {
		TransactionalEditingDomain editingDomain = ((IGraphicalEditPart) getHost())
				.getEditingDomain();
		return getGEFWrapper(new DuplicateAnythingCommand(editingDomain, req));
	}

	/**
	 * @generated
	 */
	private static class DuplicateAnythingCommand extends
			DuplicateEObjectsCommand {

		/**
		 * @generated
		 */
		public DuplicateAnythingCommand(
				TransactionalEditingDomain editingDomain,
				DuplicateElementsRequest req) {
			super(editingDomain, req.getLabel(), req
					.getElementsToBeDuplicated(), req
					.getAllDuplicatedElementsMap());
		}

	}

}
