/*
 * Decompiled with CFR 0.152.
 */
package org.modelversioning.emfprofile.diagram.expressions;

import java.util.Collections;
import java.util.Map;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.EvaluationEnvironment;
import org.eclipse.ocl.ParserException;
import org.eclipse.ocl.ecore.EcoreFactory;
import org.eclipse.ocl.ecore.OCL;
import org.eclipse.ocl.ecore.Variable;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.options.Option;
import org.eclipse.ocl.options.ParsingOptions;
import org.modelversioning.emfprofile.diagram.expressions.EMFProfileAbstractExpression;
import org.modelversioning.emfprofile.diagram.part.EMFProfileDiagramEditorPlugin;

public class EMFProfileOCLFactory {
    private final EMFProfileAbstractExpression[] expressions = new EMFProfileAbstractExpression[3];

    protected EMFProfileOCLFactory() {
    }

    public static EMFProfileAbstractExpression getExpression(int index, EClassifier context, Map<String, EClassifier> environment) {
        EMFProfileOCLFactory cached = EMFProfileDiagramEditorPlugin.getInstance().getEMFProfileOCLFactory();
        if (cached == null) {
            cached = new EMFProfileOCLFactory();
            EMFProfileDiagramEditorPlugin.getInstance().setEMFProfileOCLFactory(cached);
        }
        if (index < 0 || index >= cached.expressions.length) {
            throw new IllegalArgumentException();
        }
        if (cached.expressions[index] == null) {
            String[] exprBodies = new String[]{"not oclIsKindOf(ecore::EEnum)", "self <> oppositeEnd and not oppositeEnd.eSuperTypes->includes(self) and not self.eAllSuperTypes->includes(oppositeEnd)", "self.oclIsKindOf(ecore::EClass)"};
            cached.expressions[index] = EMFProfileOCLFactory.getExpression(exprBodies[index], context, environment == null ? Collections.emptyMap() : environment);
        }
        return cached.expressions[index];
    }

    public static EMFProfileAbstractExpression getExpression(String body, EClassifier context, Map<String, EClassifier> environment) {
        return new Expression(body, context, environment);
    }

    public static EMFProfileAbstractExpression getExpression(String body, EClassifier context) {
        return EMFProfileOCLFactory.getExpression(body, context, Collections.emptyMap());
    }

    private static class Expression
    extends EMFProfileAbstractExpression {
        private final OCL oclInstance = OCL.newInstance();
        private org.eclipse.ocl.ecore.OCLExpression oclExpression;

        public Expression(String body, EClassifier context, Map<String, EClassifier> environment) {
            super(body, context);
            Expression.initCustomEnv(this.oclInstance.getEnvironment(), environment);
            OCL.Helper oclHelper = this.oclInstance.createOCLHelper();
            oclHelper.setContext((Object)this.context());
            try {
                this.oclExpression = oclHelper.createQuery(this.body());
                this.setStatus(0, null, null);
            }
            catch (ParserException e) {
                this.setStatus(4, e.getMessage(), e);
            }
        }

        @Override
        protected Object doEvaluate(Object context, Map env) {
            if (this.oclExpression == null) {
                return null;
            }
            EvaluationEnvironment evalEnv = this.oclInstance.getEvaluationEnvironment();
            for (Object nextKey : env.keySet()) {
                evalEnv.replace((String)nextKey, env.get(nextKey));
            }
            try {
                Object result = this.oclInstance.evaluate(context, (OCLExpression)this.oclExpression);
                Object object = this.oclInstance.isInvalid(result) ? null : result;
                return object;
            }
            finally {
                evalEnv.clear();
                this.oclInstance.setExtentMap(null);
            }
        }

        private static void initCustomEnv(Environment<?, EClassifier, ?, ?, ?, EParameter, ?, ?, ?, ?, ?, ?> ecoreEnv, Map<String, EClassifier> environment) {
            ParsingOptions.setOption(ecoreEnv, (Option)ParsingOptions.implicitRootClass(ecoreEnv), (Object)EcorePackage.eINSTANCE.getEObject());
            for (String varName : environment.keySet()) {
                EClassifier varType = environment.get(varName);
                ecoreEnv.addElement(varName, (org.eclipse.ocl.expressions.Variable)Expression.createVar(ecoreEnv, varName, varType), false);
            }
        }

        private static Variable createVar(Environment<?, EClassifier, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?> ecoreEnv, String name, EClassifier type) {
            Variable var = EcoreFactory.eINSTANCE.createVariable();
            var.setName(name);
            var.setType((Object)((EClassifier)ecoreEnv.getUMLReflection().getOCLType((Object)type)));
            return var;
        }
    }
}

