/*
 * Decompiled with CFR 0.152.
 */
package org.modelversioning.emfprofile.diagram.application;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.modelversioning.emfprofile.diagram.part.Messages;

public class WizardNewFileCreationPage
extends WizardPage {
    private final IStructuredSelection currentSelection;
    private String initialFileName;
    private IPath initialContainerFullPath;
    private Text fileNameEditor;

    public WizardNewFileCreationPage(String name, IStructuredSelection currentSelection) {
        super(name);
        this.currentSelection = currentSelection;
        String home = System.getProperty("user.home");
        if (home != null) {
            this.initialContainerFullPath = new Path(home);
        }
    }

    protected IStructuredSelection getSelection() {
        return this.currentSelection;
    }

    public String getFileName() {
        if (this.fileNameEditor == null) {
            return this.initialFileName;
        }
        IPath path = this.getFilePath();
        if (path == null || path.isEmpty() || path.hasTrailingSeparator()) {
            return null;
        }
        return path.lastSegment();
    }

    public void setFileName(String fileName) {
        if (this.fileNameEditor == null) {
            this.initialFileName = fileName;
            return;
        }
        this.setFilePath(this.getContainerFullPath(), fileName);
    }

    public IPath getContainerFullPath() {
        if (this.fileNameEditor == null) {
            return this.initialContainerFullPath;
        }
        IPath path = this.getFilePath();
        if (path == null || path.isEmpty()) {
            return null;
        }
        if (path.hasTrailingSeparator()) {
            return path;
        }
        if ((path = path.removeLastSegments(1)).isEmpty()) {
            return null;
        }
        return path.addTrailingSeparator();
    }

    public void setContainerFullPath(IPath containerPath) {
        if (this.fileNameEditor == null) {
            this.initialContainerFullPath = containerPath;
            return;
        }
        this.setFilePath(containerPath, this.getFileName());
    }

    protected IPath getFilePath() {
        String fileName = this.fileNameEditor.getText().trim();
        if (fileName.length() == 0) {
            return null;
        }
        return new Path(this.fileNameEditor.getText());
    }

    protected void setFilePath(IPath containerPath, String fileName) {
        fileName = fileName == null ? "" : fileName.trim();
        if (containerPath == null) {
            this.fileNameEditor.setText(fileName);
        } else {
            if (!containerPath.hasTrailingSeparator()) {
                containerPath = containerPath.addTrailingSeparator();
            }
            IPath path = fileName.length() == 0 ? containerPath : containerPath.append(fileName);
            this.fileNameEditor.setText(path.toOSString());
        }
        this.setPageComplete(this.validatePage());
    }

    public void createControl(Composite parent) {
        Composite plate = new Composite(parent, 0);
        plate.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label(plate, 0);
        label.setText(Messages.WizardNewFileCreationPage_FileLabel);
        label.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 2, 1));
        this.fileNameEditor = new Text(plate, 2052);
        this.fileNameEditor.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Button button = new Button(plate, 8);
        button.setText(Messages.WizardNewFileCreationPage_BrowseButton);
        button.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.fileNameEditor.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WizardNewFileCreationPage.this.setPageComplete(WizardNewFileCreationPage.this.validatePage());
            }
        });
        button.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(WizardNewFileCreationPage.this.getShell(), 8192);
                dialog.setText(Messages.WizardNewFileCreationPage_SelectNewFileDialog);
                dialog.setFileName(WizardNewFileCreationPage.this.getFileName());
                String fileName = dialog.open();
                if (fileName != null) {
                    WizardNewFileCreationPage.this.fileNameEditor.setText(fileName);
                    WizardNewFileCreationPage.this.setPageComplete(WizardNewFileCreationPage.this.validatePage());
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.setFilePath(this.initialContainerFullPath, this.initialFileName);
        this.setControl((Control)plate);
    }

    protected boolean validatePage() {
        String fileName = this.fileNameEditor.getText().trim();
        if (fileName.length() == 0) {
            this.setErrorMessage(Messages.WizardNewFileCreationPage_EmptyFileNameError);
            return false;
        }
        if (!new Path("").isValidPath(fileName)) {
            this.setErrorMessage(Messages.WizardNewFileCreationPage_InvalidFileNameError);
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }
}

