/*
 * Decompiled with CFR 0.152.
 */
package org.modelversioning.emfprofile.diagram.part;

import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.modelversioning.emfprofile.EMFProfilePackage;
import org.modelversioning.emfprofile.Profile;
import org.modelversioning.emfprofile.diagram.expressions.EMFProfileOCLFactory;
import org.modelversioning.emfprofile.diagram.part.EMFProfileDiagramEditorPlugin;

public class EMFProfileVisualIDRegistry {
    private static final String DEBUG_KEY = "org.modelversioning.emfprofile.diagram/debug/visualID";

    public static int getVisualID(View view) {
        if (view instanceof Diagram) {
            if ("EMFProfile".equals(view.getType())) {
                return 1000;
            }
            return -1;
        }
        return EMFProfileVisualIDRegistry.getVisualID(view.getType());
    }

    public static String getModelID(View view) {
        Diagram diagram = view.getDiagram();
        while (view != diagram) {
            EAnnotation annotation = view.getEAnnotation("Shortcut");
            if (annotation != null) {
                return (String)annotation.getDetails().get((Object)"modelID");
            }
            view = (View)view.eContainer();
        }
        return diagram != null ? diagram.getType() : null;
    }

    public static int getVisualID(String type) {
        try {
            return Integer.parseInt(type);
        }
        catch (NumberFormatException numberFormatException) {
            if (Boolean.TRUE.toString().equalsIgnoreCase(Platform.getDebugOption((String)DEBUG_KEY))) {
                EMFProfileDiagramEditorPlugin.getInstance().logError("Unable to parse view type as a visualID number: " + type);
            }
            return -1;
        }
    }

    public static String getType(int visualID) {
        return Integer.toString(visualID);
    }

    public static int getDiagramVisualID(EObject domainElement) {
        if (domainElement == null) {
            return -1;
        }
        if (EMFProfilePackage.eINSTANCE.getProfile().isSuperTypeOf(domainElement.eClass()) && EMFProfileVisualIDRegistry.isDiagram((Profile)domainElement)) {
            return 1000;
        }
        return -1;
    }

    public static int getNodeVisualID(View containerView, EObject domainElement) {
        int containerVisualID;
        if (domainElement == null) {
            return -1;
        }
        String containerModelID = EMFProfileVisualIDRegistry.getModelID(containerView);
        if (!"EMFProfile".equals(containerModelID) && !"ecore".equals(containerModelID)) {
            return -1;
        }
        if ("EMFProfile".equals(containerModelID)) {
            containerVisualID = EMFProfileVisualIDRegistry.getVisualID(containerView);
        } else if (containerView instanceof Diagram) {
            containerVisualID = 1000;
        } else {
            return -1;
        }
        switch (containerVisualID) {
            case 1000: {
                if (EMFProfilePackage.eINSTANCE.getStereotype().isSuperTypeOf(domainElement.eClass())) {
                    return 2006;
                }
                if (EcorePackage.eINSTANCE.getEClass().isSuperTypeOf(domainElement.eClass())) {
                    return 2002;
                }
                if (EcorePackage.eINSTANCE.getEPackage().isSuperTypeOf(domainElement.eClass())) {
                    return 2003;
                }
                if (EcorePackage.eINSTANCE.getEEnum().isSuperTypeOf(domainElement.eClass())) {
                    return 2004;
                }
                if (!EcorePackage.eINSTANCE.getEDataType().isSuperTypeOf(domainElement.eClass()) || !EMFProfileVisualIDRegistry.isEDataType_2005((EDataType)domainElement)) break;
                return 2005;
            }
            case 7008: {
                if (!EcorePackage.eINSTANCE.getEAttribute().isSuperTypeOf(domainElement.eClass())) break;
                return 3001;
            }
            case 7004: {
                if (!EcorePackage.eINSTANCE.getEAttribute().isSuperTypeOf(domainElement.eClass())) break;
                return 3004;
            }
            case 7005: {
                if (!EcorePackage.eINSTANCE.getEOperation().isSuperTypeOf(domainElement.eClass())) break;
                return 3005;
            }
            case 7002: {
                if (!EcorePackage.eINSTANCE.getEClass().isSuperTypeOf(domainElement.eClass())) break;
                return 3002;
            }
            case 7006: {
                if (!EcorePackage.eINSTANCE.getEAttribute().isSuperTypeOf(domainElement.eClass())) break;
                return 3004;
            }
            case 7007: {
                if (!EcorePackage.eINSTANCE.getEOperation().isSuperTypeOf(domainElement.eClass())) break;
                return 3005;
            }
            case 7003: {
                if (!EcorePackage.eINSTANCE.getEEnumLiteral().isSuperTypeOf(domainElement.eClass())) break;
                return 3003;
            }
        }
        return -1;
    }

    public static boolean canCreateNode(View containerView, int nodeVisualID) {
        int containerVisualID;
        String containerModelID = EMFProfileVisualIDRegistry.getModelID(containerView);
        if (!"EMFProfile".equals(containerModelID) && !"ecore".equals(containerModelID)) {
            return false;
        }
        if ("EMFProfile".equals(containerModelID)) {
            containerVisualID = EMFProfileVisualIDRegistry.getVisualID(containerView);
        } else if (containerView instanceof Diagram) {
            containerVisualID = 1000;
        } else {
            return false;
        }
        switch (containerVisualID) {
            case 1000: {
                if (2006 == nodeVisualID) {
                    return true;
                }
                if (2002 == nodeVisualID) {
                    return true;
                }
                if (2003 == nodeVisualID) {
                    return true;
                }
                if (2004 == nodeVisualID) {
                    return true;
                }
                if (2005 != nodeVisualID) break;
                return true;
            }
            case 2006: {
                if (5008 == nodeVisualID) {
                    return true;
                }
                if (7008 != nodeVisualID) break;
                return true;
            }
            case 2002: {
                if (5002 == nodeVisualID) {
                    return true;
                }
                if (7004 == nodeVisualID) {
                    return true;
                }
                if (7005 != nodeVisualID) break;
                return true;
            }
            case 2003: {
                if (5004 == nodeVisualID) {
                    return true;
                }
                if (7002 != nodeVisualID) break;
                return true;
            }
            case 2004: {
                if (5005 == nodeVisualID) {
                    return true;
                }
                if (7003 != nodeVisualID) break;
                return true;
            }
            case 2005: {
                if (5006 == nodeVisualID) {
                    return true;
                }
                if (5007 != nodeVisualID) break;
                return true;
            }
            case 3002: {
                if (5003 == nodeVisualID) {
                    return true;
                }
                if (7006 == nodeVisualID) {
                    return true;
                }
                if (7007 != nodeVisualID) break;
                return true;
            }
            case 7008: {
                if (3001 != nodeVisualID) break;
                return true;
            }
            case 7004: {
                if (3004 != nodeVisualID) break;
                return true;
            }
            case 7005: {
                if (3005 != nodeVisualID) break;
                return true;
            }
            case 7002: {
                if (3002 != nodeVisualID) break;
                return true;
            }
            case 7006: {
                if (3004 != nodeVisualID) break;
                return true;
            }
            case 7007: {
                if (3005 != nodeVisualID) break;
                return true;
            }
            case 7003: {
                if (3003 != nodeVisualID) break;
                return true;
            }
            case 4005: {
                if (6004 != nodeVisualID) break;
                return true;
            }
            case 4003: {
                if (6001 == nodeVisualID) {
                    return true;
                }
                if (6002 != nodeVisualID) break;
                return true;
            }
        }
        return false;
    }

    public static int getLinkWithClassVisualID(EObject domainElement) {
        if (domainElement == null) {
            return -1;
        }
        if (EMFProfilePackage.eINSTANCE.getExtension().isSuperTypeOf(domainElement.eClass())) {
            return 4005;
        }
        if (EcorePackage.eINSTANCE.getEReference().isSuperTypeOf(domainElement.eClass())) {
            return 4003;
        }
        return -1;
    }

    private static boolean isDiagram(Profile element) {
        return true;
    }

    private static boolean isEDataType_2005(EDataType domainElement) {
        Object result = EMFProfileOCLFactory.getExpression(0, (EClassifier)EcorePackage.eINSTANCE.getEDataType(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }
}

