/*
 * Decompiled with CFR 0.152.
 */
package org.modelversioning.emfprofile.diagram.part;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.gef.EditPartViewer;

public class ValidationMarker {
    private static final String KEY = "validation_marker";
    public static final ValidationMarker[] EMPTY_ARRAY = new ValidationMarker[0];
    private final String location;
    private final String message;
    private final int statusSeverity;

    public ValidationMarker(String location, String message, int statusSeverity) {
        this.location = location;
        this.message = message;
        this.statusSeverity = statusSeverity;
    }

    public String getLocation() {
        return this.location;
    }

    public String getMessage() {
        return this.message;
    }

    public int getStatusSeverity() {
        return this.statusSeverity;
    }

    private static Map getMarkers(EditPartViewer viewer) {
        HashMap markers = (HashMap)viewer.getProperty(KEY);
        if (markers == null) {
            markers = new HashMap();
            viewer.setProperty(KEY, markers);
        }
        return markers;
    }

    private static Set getMarkers(EditPartViewer viewer, String viewId, boolean create) {
        HashSet markers = (HashSet)ValidationMarker.getMarkers(viewer).get(viewId);
        if (markers == null) {
            if (!create) {
                return Collections.EMPTY_SET;
            }
            markers = new HashSet();
            ValidationMarker.getMarkers(viewer).put(viewId, markers);
        }
        return markers;
    }

    public static ValidationMarker[] getMarkers(EditPartViewer viewer, String viewId) {
        Set markers = ValidationMarker.getMarkers(viewer, viewId, false);
        if (markers.isEmpty()) {
            return EMPTY_ARRAY;
        }
        return markers.toArray(new ValidationMarker[markers.size()]);
    }

    public static void removeAllMarkers(EditPartViewer viewer) {
        ValidationMarker.getMarkers(viewer).clear();
    }

    public void add(EditPartViewer viewer, String viewId) {
        ValidationMarker.getMarkers(viewer, viewId, true).add(this);
    }
}

