/*
 * Decompiled with CFR 0.152.
 */
package org.modelversioning.emfprofile.diagram.providers;

import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.notation.View;
import org.modelversioning.emfprofile.diagram.part.EMFProfileDiagramEditorPlugin;
import org.modelversioning.emfprofile.diagram.part.EMFProfileVisualIDRegistry;

public class EMFProfileValidationProvider {
    private static boolean constraintsActive = false;

    public static boolean shouldConstraintsBePrivate() {
        return false;
    }

    public static void runWithConstraints(TransactionalEditingDomain editingDomain, Runnable operation) {
        final Runnable op = operation;
        Runnable task = new Runnable(){

            @Override
            public void run() {
                try {
                    constraintsActive = true;
                    op.run();
                }
                finally {
                    constraintsActive = false;
                }
            }
        };
        if (editingDomain != null) {
            try {
                editingDomain.runExclusive(task);
            }
            catch (Exception e) {
                EMFProfileDiagramEditorPlugin.getInstance().logError("Validation failed", e);
            }
        } else {
            task.run();
        }
    }

    static boolean isInDefaultEditorContext(Object object) {
        if (EMFProfileValidationProvider.shouldConstraintsBePrivate() && !constraintsActive) {
            return false;
        }
        if (object instanceof View) {
            return constraintsActive && "EMFProfile".equals(EMFProfileVisualIDRegistry.getModelID((View)object));
        }
        return true;
    }
}

