/*
 * Decompiled with CFR 0.152.
 */
package org.modelversioning.emfprofile.project.ui.wizard;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;
import org.modelversioning.emfprofile.project.ui.wizard.ProfileProjectData;

public class ProfileProjectNewPage
extends WizardNewProjectCreationPage {
    private ProfileProjectData data;
    private IStructuredSelection selection;
    private Text profileNameField;
    private Text profileNamespaceField;
    private Listener fieldModifyListener = new Listener(){

        public void handleEvent(Event e) {
            boolean valid = ProfileProjectNewPage.this.validatePage();
            ProfileProjectNewPage.this.setPageComplete(valid);
        }
    };

    public ProfileProjectNewPage(String pageName, ProfileProjectData data, IStructuredSelection selection) {
        super(pageName);
        this.selection = selection;
        this.data = data;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        Composite control = (Composite)this.getControl();
        GridLayout layout = new GridLayout();
        control.setLayout((Layout)layout);
        this.createProfileInformationGroup(control);
        this.createWorkingSetGroup(control, this.selection, new String[]{"org.eclipse.jdt.ui.JavaWorkingSetPage", "org.eclipse.pde.ui.pluginWorkingSet", "org.eclipse.ui.resourceWorkingSetPage"});
        Dialog.applyDialogFont((Control)control);
        this.setControl((Control)control);
    }

    private void createProfileInformationGroup(Composite container) {
        Group group = new Group(container, 0);
        group.setText("EMF Profile Information");
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(768));
        Label profileLabel = new Label((Composite)group, 0);
        profileLabel.setText("Profile name");
        profileLabel.setFont(container.getFont());
        this.profileNameField = new Text((Composite)group, 2048);
        GridData data = new GridData(768);
        data.widthHint = 250;
        this.profileNameField.setLayoutData((Object)data);
        this.profileNameField.setFont(container.getFont());
        this.profileNameField.addListener(24, this.fieldModifyListener);
        Label profileURILabel = new Label((Composite)group, 0);
        profileURILabel.setText("Profile namespace");
        profileURILabel.setFont(container.getFont());
        this.profileNamespaceField = new Text((Composite)group, 2048);
        data = new GridData(768);
        data.widthHint = 250;
        this.profileNamespaceField.setLayoutData((Object)data);
        this.profileNamespaceField.setFont(container.getFont());
        this.profileNamespaceField.addListener(24, this.fieldModifyListener);
    }

    protected boolean validatePage() {
        if (!super.validatePage()) {
            return false;
        }
        if (this.getProfileName().equals("")) {
            this.setErrorMessage(null);
            this.setMessage("Enter a name for the profile.");
            return false;
        }
        if (this.getProfileNamespace().equals("")) {
            this.setErrorMessage(null);
            this.setMessage("Enter a namespace for the profile.");
            return false;
        }
        this.setErrorMessage(null);
        this.setMessage(null);
        return true;
    }

    public String getProfileName() {
        if (this.profileNameField == null) {
            return "";
        }
        return this.profileNameField.getText().trim();
    }

    public String getProfileNamespace() {
        if (this.profileNamespaceField == null) {
            return "";
        }
        return this.profileNamespaceField.getText().trim();
    }

    public void updateData() {
        this.data.setProjectName(this.getProjectName());
        this.data.setProfileName(this.getProfileName());
        this.data.setProfileNamespace(this.getProfileNamespace());
        this.data.setProjectHandle(this.getProjectHandle());
        this.data.setLocationPath(this.getLocationPath());
    }
}

