/*
 * Decompiled with CFR 0.152.
 */
package org.modelversioning.emfprofile.project.ui.wizard;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkingSet;
import org.modelversioning.emfprofile.project.ui.wizard.NewProfileProjectOperation;
import org.modelversioning.emfprofile.project.ui.wizard.ProfileProjectData;
import org.modelversioning.emfprofile.project.ui.wizard.ProfileProjectNewPage;

public class ProfileProjectNewWizard
extends Wizard
implements INewWizard {
    private ProfileProjectData projectData;
    private IWorkbench workbench;
    protected ProfileProjectNewPage mainPage;

    public ProfileProjectNewWizard() {
        this.setWindowTitle("New EMF Profile Project");
        this.setNeedsProgressMonitor(true);
        this.projectData = new ProfileProjectData();
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.mainPage = new ProfileProjectNewPage("main", this.projectData, selection);
        this.mainPage.setTitle("EMF Profile Project");
        this.mainPage.setDescription("Create a new EMF Profile project.");
        this.addPage((IWizardPage)this.mainPage);
    }

    public boolean performFinish() {
        this.mainPage.updateData();
        try {
            this.createEMFProfileProject();
            this.addToWorkingSets();
            return true;
        }
        catch (InvocationTargetException e) {
            System.err.println(e.getMessage());
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return false;
    }

    private void createEMFProfileProject() throws InvocationTargetException, InterruptedException {
        this.getContainer().run(false, true, (IRunnableWithProgress)new NewProfileProjectOperation(this.projectData));
    }

    private void addToWorkingSets() {
        IWorkingSet[] workingSets = this.mainPage.getSelectedWorkingSets();
        if (workingSets.length > 0) {
            this.workbench.getWorkingSetManager().addToWorkingSets((IAdaptable)this.mainPage.getProjectHandle(), workingSets);
        }
    }
}

