/*
 * Decompiled with CFR 0.152.
 */
package org.modelversioning.emfprofile.project;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class EMFProfileProjectNatureUtil {
    private static final String PLATFORM_RESOURCE_PREFIX = "platform:/resource";
    private static final String EXTENSION_POINT_PROFILE_RESOURCE_ATT_NAME = "profile_resource";
    private static final String EXTENSION_POINT_PROFILE_ELEM_NAME = "profile";

    public static void addNature(IProject project) throws CoreException {
        IProjectDescription description = project.getDescription();
        String[] prevNatures = description.getNatureIds();
        String[] newNatures = new String[prevNatures.length + 1];
        System.arraycopy(prevNatures, 0, newNatures, 1, prevNatures.length);
        newNatures[0] = "org.modelversioning.emfprofile.project.nature";
        description.setNatureIds(newNatures);
        project.setDescription(description, (IProgressMonitor)new NullProgressMonitor());
    }

    public static Collection<String> getProfileDiagramFileNames(IProject project) {
        IFile pluginXml = project.getFile("plugin.xml");
        if (pluginXml.exists()) {
            return EMFProfileProjectNatureUtil.extractProfileFileNames(pluginXml);
        }
        return Collections.emptyList();
    }

    private static Collection<String> extractProfileFileNames(IFile pluginXml) {
        try {
            ExtensionPointReader extensionPointReader = new ExtensionPointReader();
            SAXParser saxParser = SAXParserFactory.newInstance().newSAXParser();
            saxParser.parse(pluginXml.getContents(), (DefaultHandler)extensionPointReader);
            return extensionPointReader.profileDiagramFileNames;
        }
        catch (ParserConfigurationException parserConfigurationException) {
        }
        catch (SAXException sAXException) {
        }
        catch (IOException iOException) {
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return Collections.emptyList();
    }

    public static Collection<IFile> getProfileDiagramFiles(IProject project) {
        Collection<String> profileDiagramFileNames = EMFProfileProjectNatureUtil.getProfileDiagramFileNames(project);
        ArrayList<IFile> profileDiagramFiles = new ArrayList<IFile>();
        for (String profileDiagramFileName : profileDiagramFileNames) {
            IFile profileDiagramFile = project.getFile(profileDiagramFileName);
            profileDiagramFiles.add(profileDiagramFile);
        }
        return profileDiagramFiles;
    }

    public static Collection<URI> getProfileDiagramURIs(IProject project) {
        Collection<String> profileDiagramFileNames = EMFProfileProjectNatureUtil.getProfileDiagramFileNames(project);
        ArrayList<URI> profileDiagramURIs = new ArrayList<URI>();
        for (String profileDiagramFileName : profileDiagramFileNames) {
            URI uri = URI.createURI((String)(PLATFORM_RESOURCE_PREFIX + project.getName() + "/" + profileDiagramFileName));
            profileDiagramURIs.add(uri);
        }
        return profileDiagramURIs;
    }

    public static URI getDefaultProfileDiagramURI(IProject project) {
        IFile profileDiagramFile = project.getFile("profile.emfprofile_diagram");
        URI uri = URI.createURI((String)(PLATFORM_RESOURCE_PREFIX + profileDiagramFile.getFullPath().toString()));
        return uri;
    }

    static class ExtensionPointReader
    extends DefaultHandler {
        private Collection<String> profileDiagramFileNames = new ArrayList<String>();

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            String attributeValue;
            super.startElement(uri, localName, qName, attributes);
            if (EMFProfileProjectNatureUtil.EXTENSION_POINT_PROFILE_ELEM_NAME.equals(qName) && (attributeValue = attributes.getValue(EMFProfileProjectNatureUtil.EXTENSION_POINT_PROFILE_RESOURCE_ATT_NAME)) != null) {
                this.profileDiagramFileNames.add(attributeValue);
            }
        }

        public Collection<String> getProfileDiagramFileNames() {
            return this.profileDiagramFileNames;
        }
    }
}

