/*
 * Decompiled with CFR 0.152.
 */
package org.modelversioning.emfprofile.registry.internal;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.modelversioning.emfprofile.EMFProfilePlugin;
import org.modelversioning.emfprofile.project.EMFProfileProjectNatureUtil;
import org.modelversioning.emfprofile.registry.internal.ProfileRegistry;
import org.modelversioning.emfprofile.registry.internal.ProjectProfileProvider;

public class ProfileProjectSynchronizer
implements IResourceChangeListener {
    private ResourceSet resourceSet;
    private ProfileRegistry registry;

    public ProfileProjectSynchronizer(ProfileRegistry registry, ResourceSet resourceSet) {
        this.registry = registry;
        this.resourceSet = resourceSet;
    }

    public void registerProfileProjects() {
        this.registerProfiles(this.getAllWorkspaceProjects());
    }

    private IProject[] getAllWorkspaceProjects() {
        return ResourcesPlugin.getWorkspace().getRoot().getProjects();
    }

    private void registerProfiles(IProject[] allProjects) {
        IProject[] iProjectArray = allProjects;
        int n = allProjects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            try {
                if (this.isOpenProfileProject(project)) {
                    this.registerProfilesFromProject(project);
                }
            }
            catch (Exception e) {
                this.logWarning(e, "Errors while loading profiles from project " + project.getName());
            }
            ++n2;
        }
    }

    private boolean isOpenProfileProject(IProject project) {
        return project.isOpen() && this.isProfileProject((IResource)project);
    }

    private boolean isProfileProject(IResource resource) {
        if (resource instanceof IProject) {
            IProject project = (IProject)resource;
            try {
                if (project.hasNature("org.modelversioning.emfprofile.project.nature")) {
                    return true;
                }
            }
            catch (CoreException e) {
                return false;
            }
        }
        return false;
    }

    private void registerProfilesFromProject(IProject project) {
        Collection profileDiagramFiles = EMFProfileProjectNatureUtil.getProfileDiagramFiles((IProject)project);
        for (IFile profileDiagramFile : profileDiagramFiles) {
            Resource profileResource = this.resourceSet.getResource(this.createProfileURI(profileDiagramFile), true);
            ProjectProfileProvider profileProvider = new ProjectProfileProvider(project, profileResource);
            this.registry.doRegisterProfile(profileProvider);
        }
    }

    private URI createProfileURI(IFile profileDiagramFile) {
        return URI.createPlatformResourceURI((String)profileDiagramFile.getFullPath().toString(), (boolean)true);
    }

    public void startSynchronizing() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    public void stopSynchronizing() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        Collection<IProject> affectedProjects = this.getAffectedProfileProjects(event);
        for (IProject project : affectedProjects) {
            this.unregisterProfilesFromProject(project);
            if (this.isDeleteOrCloseEvent(event)) continue;
            try {
                this.registerProfilesFromProject(project);
            }
            catch (Exception e) {
                this.logWarning(e, "Errors while loading profiles from project " + project.getName());
            }
        }
        if (affectedProjects.size() > 0) {
            this.registry.notifyObservers();
        }
    }

    private Collection<IProject> getAffectedProfileProjects(IResourceChangeEvent event) {
        ArrayList<IProject> affectedProjects = new ArrayList<IProject>();
        if (event.getDelta() != null) {
            IResourceDelta[] iResourceDeltaArray = event.getDelta().getAffectedChildren();
            int n = iResourceDeltaArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResourceDelta affectedChildren = iResourceDeltaArray[n2];
                if (this.isProfileProject(affectedChildren.getResource())) {
                    affectedProjects.add((IProject)affectedChildren.getResource());
                }
                ++n2;
            }
        } else if (event.getResource() != null && event.getResource() instanceof IProject && this.isProfileProject(event.getResource())) {
            affectedProjects.add((IProject)event.getResource());
        }
        return affectedProjects;
    }

    private boolean isDeleteOrCloseEvent(IResourceChangeEvent event) {
        return 2 == event.getType() || 4 == event.getType();
    }

    private void unregisterProfilesFromProject(IProject project) {
        for (ProjectProfileProvider profileProvider : this.registry.getRegisteredProjectProfileProviders()) {
            if (!project.equals((Object)profileProvider.getProject())) continue;
            this.registry.doUnregisterProfile(profileProvider);
        }
    }

    private void logWarning(Exception exception, String msg) {
        EMFProfilePlugin.getPlugin().log((Object)new Status(2, "org.modelversioning.emfprofile", msg, (Throwable)exception));
    }
}

