/*
 * Decompiled with CFR 0.152.
 */
package org.modelversioning.emfprofile.registry.internal;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.modelversioning.emfprofile.Profile;
import org.modelversioning.emfprofile.registry.IProfileProvider;
import org.osgi.framework.Bundle;

public class BundleProfileProvider
implements IProfileProvider {
    private Bundle bundle;
    private Resource profileResource;
    private Profile profile;
    private String profileName;
    private String profileNsURI;

    public BundleProfileProvider(Bundle bundle, Resource profileResource) {
        this.bundle = bundle;
        this.profileResource = profileResource;
        this.initialize();
    }

    private void initialize() {
        if (this.profileResource == null) {
            throw new IllegalArgumentException("Resource is null");
        }
        if (this.profileResource.getContents().size() < 0) {
            throw new IllegalArgumentException("Resource is emtpy");
        }
        EObject eObject = (EObject)this.profileResource.getContents().get(0);
        if (!(eObject instanceof Profile)) {
            throw new IllegalArgumentException("Resource contains no profile");
        }
        this.initialize((Profile)eObject);
    }

    private void initialize(Profile profile) {
        this.profile = profile;
        this.profileName = profile.getName();
        this.profileNsURI = profile.getNsURI();
    }

    public Bundle getBundle() {
        return this.bundle;
    }

    @Override
    public Profile getProfile() {
        return this.profile;
    }

    @Override
    public String getProfileNsURI() {
        return this.profileNsURI;
    }

    @Override
    public String getProfileName() {
        return this.profileName;
    }

    @Override
    public IProfileProvider.ProfileLocationType getProfileLocationType() {
        return IProfileProvider.ProfileLocationType.BUNDLE;
    }
}

