/*
 * Decompiled with CFR 0.152.
 */
package org.modelversioning.emfprofile.registry.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.modelversioning.emfprofile.EMFProfilePlugin;
import org.modelversioning.emfprofile.registry.internal.BundleProfileProvider;
import org.osgi.framework.Bundle;

public class ExtensionPointReader {
    private final ResourceSet resourceSet;
    private Collection<BundleProfileProvider> bundleProfileProviders;

    public ExtensionPointReader(ResourceSet resourceSet) {
        this.resourceSet = resourceSet;
        this.bundleProfileProviders = new ArrayList<BundleProfileProvider>();
        this.loadBundleProfileProvidersFromExtensionPoint();
    }

    private void loadBundleProfileProvidersFromExtensionPoint() {
        IConfigurationElement[] config = Platform.getExtensionRegistry().getConfigurationElementsFor("org.modelversioning.emfprofile.profile");
        this.loadProfiles(config);
    }

    private void loadProfiles(IConfigurationElement[] config) {
        IConfigurationElement[] iConfigurationElementArray = config;
        int n = config.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configElement = iConfigurationElementArray[n2];
            try {
                BundleProfileProvider bundleProfileProvider = this.loadProfile(configElement);
                this.bundleProfileProviders.add(bundleProfileProvider);
            }
            catch (Exception e) {
                this.logWarning(e, "Could not load profile from extension point");
            }
            ++n2;
        }
    }

    private BundleProfileProvider loadProfile(IConfigurationElement configElement) {
        IContributor contributor = configElement.getContributor();
        String profileResourceName = configElement.getAttribute("profile_resource");
        Bundle bundle = Platform.getBundle((String)contributor.getName());
        Resource profileResource = this.resourceSet.getResource(this.createProfileURI(contributor, profileResourceName), true);
        return new BundleProfileProvider(bundle, profileResource);
    }

    private URI createProfileURI(IContributor contributor, String profileResourceName) {
        return URI.createURI((String)("platform:/plugin/" + contributor.getName() + "/" + profileResourceName));
    }

    public Collection<BundleProfileProvider> getProfileProvider() {
        return Collections.unmodifiableCollection(this.bundleProfileProviders);
    }

    private void logWarning(Exception exception, String msg) {
        EMFProfilePlugin.getPlugin().log((Object)new Status(2, "org.modelversioning.emfprofile", msg, (Throwable)exception));
    }
}

