/*
 * Decompiled with CFR 0.152.
 */
package org.modelversioning.emfprofile.registry.internal;

import org.eclipse.core.resources.IProject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.modelversioning.emfprofile.Profile;
import org.modelversioning.emfprofile.registry.IProfileProvider;

public class ProjectProfileProvider
implements IProfileProvider {
    private IProject project;
    private Resource profileResource;
    private Profile profile;
    private String profileName;
    private String profileNsURI;

    public ProjectProfileProvider(IProject project, Resource profileResource) {
        this.project = project;
        this.profileResource = profileResource;
        this.initialize();
    }

    private void initialize() {
        if (this.profileResource == null) {
            throw new IllegalArgumentException("Resource is null");
        }
        if (this.profileResource.getContents().size() < 0) {
            throw new IllegalArgumentException("Resource is emtpy");
        }
        Profile profile = this.obtainProfileFromResource();
        if (profile == null) {
            throw new IllegalArgumentException("Resource contains no profile");
        }
        this.initialize(profile);
    }

    private Profile obtainProfileFromResource() {
        for (EObject eObject : this.profileResource.getContents()) {
            if (!(eObject instanceof Profile)) continue;
            return (Profile)eObject;
        }
        return null;
    }

    private void initialize(Profile profile) {
        this.profile = profile;
        this.profileName = profile.getName();
        this.profileNsURI = profile.getNsURI();
    }

    public IProject getProject() {
        return this.project;
    }

    @Override
    public Profile getProfile() {
        return this.profile;
    }

    @Override
    public String getProfileNsURI() {
        return this.profileNsURI;
    }

    @Override
    public String getProfileName() {
        return this.profileName;
    }

    @Override
    public IProfileProvider.ProfileLocationType getProfileLocationType() {
        return IProfileProvider.ProfileLocationType.WORKSPACE;
    }
}

