/*
 * Decompiled with CFR 0.152.
 */
package org.modelversioning.emfprofile.registry.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.modelversioning.emfprofile.Extension;
import org.modelversioning.emfprofile.Profile;
import org.modelversioning.emfprofile.Stereotype;
import org.modelversioning.emfprofile.registry.IProfileProvider;
import org.modelversioning.emfprofile.registry.IProfileRegistry;
import org.modelversioning.emfprofile.registry.internal.BundleProfileProvider;
import org.modelversioning.emfprofile.registry.internal.ExtensionPointReader;
import org.modelversioning.emfprofile.registry.internal.ProfileProjectSynchronizer;
import org.modelversioning.emfprofile.registry.internal.ProjectProfileProvider;

public class ProfileRegistry
extends Observable
implements IProfileRegistry {
    private final ResourceSet resourceSet = new ResourceSetImpl();
    private final Map<String, IProfileProvider> registeredProfileProviders = new HashMap<String, IProfileProvider>();
    private final Collection<Profile> registeredProfiles = new ArrayList<Profile>();
    private ProfileProjectSynchronizer projectSynchronizer;

    public ProfileRegistry() {
        this.loadProfileProvidersFromExtensionPoint();
        this.setUpProfileProjectSynchronizer();
        this.notifyObservers();
    }

    private void loadProfileProvidersFromExtensionPoint() {
        ExtensionPointReader extensionPointReader = new ExtensionPointReader(this.resourceSet);
        for (BundleProfileProvider provider : extensionPointReader.getProfileProvider()) {
            this.doRegisterProfile(provider);
        }
    }

    private void setUpProfileProjectSynchronizer() {
        this.projectSynchronizer = new ProfileProjectSynchronizer(this, this.resourceSet);
        this.projectSynchronizer.registerProfileProjects();
        this.projectSynchronizer.startSynchronizing();
    }

    @Override
    public Collection<Profile> getRegisteredProfiles() {
        return Collections.unmodifiableCollection(this.registeredProfiles);
    }

    @Override
    public Collection<IProfileProvider> getRegisteredProfileProviders() {
        return Collections.unmodifiableCollection(this.registeredProfileProviders.values());
    }

    @Override
    public void registerProfile(IProfileProvider profileProvider) {
        this.doRegisterProfile(profileProvider);
        this.notifyObservers();
    }

    protected void doRegisterProfile(IProfileProvider profileProvider) {
        Profile profile = profileProvider.getProfile();
        if (this.isValidProfile(profile)) {
            this.registeredProfileProviders.put(profileProvider.getProfileNsURI(), profileProvider);
            this.registeredProfiles.add(profile);
            EPackage.Registry.INSTANCE.remove((Object)profileProvider.getProfileNsURI());
            EPackage.Registry.INSTANCE.put((Object)profileProvider.getProfileNsURI(), (Object)profile);
            this.registerExtendedPackages(profile);
            this.setChanged();
        }
    }

    private void registerExtendedPackages(Profile profile) {
        ArrayList<EPackage> registeredPackages = new ArrayList<EPackage>();
        for (Stereotype stereotype : profile.getStereotypes()) {
            for (Extension extension : stereotype.getAllExtensions()) {
                EPackage ePackage = extension.getTarget().getEPackage();
                if (registeredPackages.contains(ePackage)) continue;
                EPackage.Registry.INSTANCE.put((Object)ePackage.getNsURI(), (Object)ePackage);
                registeredPackages.add(ePackage);
            }
        }
        for (EPackage subPackage : profile.getESubpackages()) {
            if (!(subPackage instanceof Profile)) continue;
            this.registerExtendedPackages((Profile)subPackage);
        }
    }

    private boolean isValidProfile(Profile profile) {
        Diagnostic diagnostic = Diagnostician.INSTANCE.validate((EObject)profile, Collections.emptyMap());
        return diagnostic.getSeverity() == 0;
    }

    @Override
    public void unregisterProfile(IProfileProvider profileProvider) {
        this.doUnregisterProfile(profileProvider);
        this.notifyObservers();
    }

    protected void doUnregisterProfile(IProfileProvider profileProvider) {
        this.registeredProfileProviders.remove(profileProvider.getProfileNsURI());
        this.registeredProfiles.remove(profileProvider.getProfile());
        EPackage.Registry.INSTANCE.remove((Object)profileProvider.getProfileNsURI());
        profileProvider.getProfile().eResource().unload();
        this.setChanged();
    }

    protected Collection<ProjectProfileProvider> getRegisteredProjectProfileProviders() {
        ArrayList<ProjectProfileProvider> projectProfileProviders = new ArrayList<ProjectProfileProvider>();
        for (IProfileProvider profileProvider : this.registeredProfileProviders.values()) {
            if (!(profileProvider instanceof ProjectProfileProvider)) continue;
            ProjectProfileProvider projectProfileProvider = (ProjectProfileProvider)profileProvider;
            projectProfileProviders.add(projectProfileProvider);
        }
        return projectProfileProviders;
    }
}

