/*
 * Decompiled with CFR 0.152.
 */
package org.modelversioning.emfprofileapplication.util;

import java.util.Map;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.modelversioning.emfprofile.EMFProfilePlugin;
import org.modelversioning.emfprofileapplication.EMFProfileApplicationPackage;
import org.modelversioning.emfprofileapplication.ProfileApplication;
import org.modelversioning.emfprofileapplication.ProfileImport;
import org.modelversioning.emfprofileapplication.StereotypeApplicability;
import org.modelversioning.emfprofileapplication.StereotypeApplication;
import org.modelversioning.emfprofileapplication.validation.InapplicableExtensionApplicationConstraintValidator;
import org.modelversioning.emfprofileapplication.validation.InapplicableExtensionApplicationViolation;
import org.modelversioning.emfprofileapplication.validation.LowerBoundConstraintValidator;
import org.modelversioning.emfprofileapplication.validation.LowerBoundConstraintViolation;
import org.modelversioning.emfprofileapplication.validation.UpperBoundConstraintValidator;
import org.modelversioning.emfprofileapplication.validation.UpperBoundConstraintViolation;

public class EMFProfileApplicationValidator
extends EObjectValidator {
    public static final EMFProfileApplicationValidator INSTANCE = new EMFProfileApplicationValidator();
    public static final String DIAGNOSTIC_SOURCE = "org.modelversioning.emfprofileapplication";
    private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 0;
    protected static final int DIAGNOSTIC_CODE_COUNT = 0;
    public static final int VIOLATED_UPPER_BOUND = 1;
    public static final int VIOLATED_LOWER_BOUND = 2;
    private static final int APPLIED_INAPPLICABLE_EXTENSION = 3;

    protected EPackage getEPackage() {
        return EMFProfileApplicationPackage.eINSTANCE;
    }

    protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        switch (classifierID) {
            case 0: {
                return this.validateProfileApplication((ProfileApplication)value, diagnostics, context);
            }
            case 1: {
                return this.validateProfileImport((ProfileImport)value, diagnostics, context);
            }
            case 2: {
                return this.validateStereotypeApplication((StereotypeApplication)value, diagnostics, context);
            }
            case 3: {
                return this.validateStereotypeApplicability((StereotypeApplicability)value, diagnostics, context);
            }
        }
        return true;
    }

    public boolean validateProfileApplication(ProfileApplication profileApplication, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(profileApplication, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(profileApplication, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(profileApplication, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(profileApplication, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(profileApplication, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(profileApplication, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(profileApplication, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(profileApplication, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(profileApplication, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateProfileApplication_violatedUpperBound(profileApplication, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateProfileApplication_violatedLowerBound(profileApplication, diagnostics, context);
        }
        return result;
    }

    public boolean validateProfileApplication_violatedUpperBound(ProfileApplication profileApplication, DiagnosticChain diagnostics, Map<Object, Object> context) {
        UpperBoundConstraintValidator validator = new UpperBoundConstraintValidator(profileApplication);
        EList<UpperBoundConstraintViolation> violations = validator.getViolations();
        if (violations.size() == 0) {
            return true;
        }
        this.addUpperBoundDiagnostic(violations, diagnostics, context);
        return false;
    }

    private void addUpperBoundDiagnostic(EList<UpperBoundConstraintViolation> violations, DiagnosticChain diagnostics, Map<Object, Object> context) {
        for (UpperBoundConstraintViolation violation : violations) {
            diagnostics.add((Diagnostic)this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 1, "ProfileApplication.ConstraintViolation.upper_bound", new Object[]{violation.getStereotype().getName(), violation.getExtension().toString(), violation.getModelObject()}, new Object[]{violation}, context));
        }
    }

    public boolean validateProfileApplication_violatedLowerBound(ProfileApplication profileApplication, DiagnosticChain diagnostics, Map<Object, Object> context) {
        EObject rootObject = this.obtainRootModelObject(this.obtainContextObject(context), profileApplication);
        LowerBoundConstraintValidator validator = new LowerBoundConstraintValidator(profileApplication, rootObject);
        EList<LowerBoundConstraintViolation> violations = validator.getViolations();
        if (violations.size() == 0) {
            return true;
        }
        this.addLowerBoundDiagnostic(violations, diagnostics, context);
        return false;
    }

    private void addLowerBoundDiagnostic(EList<LowerBoundConstraintViolation> violations, DiagnosticChain diagnostics, Map<Object, Object> context) {
        for (LowerBoundConstraintViolation violation : violations) {
            diagnostics.add((Diagnostic)this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 2, "ProfileApplication.ConstraintViolation.lower_bound", new Object[]{violation.getExtension().getSource().getName(), violation.getExtension().toString(), violation.getModelObject().toString()}, new Object[]{violation}, context));
        }
    }

    private EObject obtainRootModelObject(EObject contextObject, ProfileApplication profileApplication) {
        EObject rootObject = null;
        if (profileApplication.getAnnotatedObjects().size() > 0) {
            rootObject = EcoreUtil.getRootContainer((EObject)((EObject)profileApplication.getAnnotatedObjects().get(0)));
        } else if (contextObject != null) {
            rootObject = EcoreUtil.getRootContainer((EObject)contextObject);
        }
        return rootObject;
    }

    private EObject obtainContextObject(Map<Object, Object> context) {
        Object contextObject = context.get("MODEL_OBJECT");
        if (contextObject != null && contextObject instanceof EObject) {
            return (EObject)contextObject;
        }
        return null;
    }

    public boolean validateProfileImport(ProfileImport profileImport, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(profileImport, diagnostics, context);
    }

    public boolean validateStereotypeApplication(StereotypeApplication stereotypeApplication, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(stereotypeApplication, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(stereotypeApplication, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(stereotypeApplication, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(stereotypeApplication, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(stereotypeApplication, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(stereotypeApplication, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(stereotypeApplication, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(stereotypeApplication, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(stereotypeApplication, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateStereotypeApplication_appliedInapplicableExtension(stereotypeApplication, diagnostics, context);
        }
        return result;
    }

    public boolean validateStereotypeApplication_appliedInapplicableExtension(StereotypeApplication stereotypeApplication, DiagnosticChain diagnostics, Map<Object, Object> context) {
        InapplicableExtensionApplicationConstraintValidator validator = new InapplicableExtensionApplicationConstraintValidator(stereotypeApplication);
        if (validator.isViolated()) {
            if (diagnostics != null) {
                InapplicableExtensionApplicationViolation violation = validator.createViolation();
                diagnostics.add((Diagnostic)this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 3, "ProfileApplication.ConstraintViolation.applied_inapplicable_extension", new Object[]{violation.getStereotype().getName(), violation.getExtension().toString(), violation.getModelObject()}, new Object[]{violation}, context));
            }
            return false;
        }
        return true;
    }

    public boolean validateStereotypeApplicability(StereotypeApplicability stereotypeApplicability, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(stereotypeApplicability, diagnostics, context);
    }

    public ResourceLocator getResourceLocator() {
        return EMFProfilePlugin.INSTANCE;
    }
}

