/*
 * Decompiled with CFR 0.152.
 */
package org.modelversioning.emfprofileapplication.validation;

import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.modelversioning.emfprofile.Extension;
import org.modelversioning.emfprofile.Profile;
import org.modelversioning.emfprofile.Stereotype;
import org.modelversioning.emfprofileapplication.ProfileApplication;
import org.modelversioning.emfprofileapplication.ProfileImport;
import org.modelversioning.emfprofileapplication.StereotypeApplication;
import org.modelversioning.emfprofileapplication.validation.LowerBoundConstraintViolation;

public class LowerBoundConstraintValidator {
    private final ProfileApplication profileApplication;
    private final EObject rootModelObject;
    private EList<LowerBoundConstraintViolation> violations = new BasicEList();

    public LowerBoundConstraintValidator(ProfileApplication profileApplication, EObject rootModelObject) {
        this.profileApplication = profileApplication;
        this.rootModelObject = rootModelObject;
    }

    public EList<LowerBoundConstraintViolation> getViolations() {
        EList<Extension> extensions = this.collectRequiredExtensionsFromProfiles();
        this.checkExtensions(extensions);
        this.cleanViolationsConcerningSubsettedExtensions();
        return ECollections.unmodifiableEList(this.violations);
    }

    private EList<Extension> collectRequiredExtensionsFromProfiles() {
        EList<Profile> profiles = this.getUsedProfiles();
        return this.collectRequiredExtensions(profiles);
    }

    private EList<Profile> getUsedProfiles() {
        BasicEList profiles = new BasicEList();
        for (ProfileImport profileImport : this.profileApplication.getImportedProfiles()) {
            if (profileImport.getProfile() == null || profiles.contains((Object)profileImport.getProfile())) continue;
            profiles.add((Object)profileImport.getProfile());
        }
        return profiles;
    }

    private EList<Extension> collectRequiredExtensions(EList<Profile> profiles) {
        BasicEList extensions = new BasicEList();
        for (Profile profile : profiles) {
            for (Stereotype stereotype : profile.getStereotypes()) {
                for (Extension extension : stereotype.getExtensions()) {
                    if (!extension.isRequired()) continue;
                    extensions.add((Object)extension);
                }
            }
        }
        return extensions;
    }

    private void checkExtensions(EList<Extension> extensions) {
        for (Extension extension : extensions) {
            this.validateExtension(extension);
        }
    }

    private void validateExtension(Extension extension) {
        this.validateModelObjectForExtension(extension, this.rootModelObject);
        TreeIterator contents = this.rootModelObject.eAllContents();
        while (contents.hasNext()) {
            EObject modelObject = (EObject)contents.next();
            this.validateModelObjectForExtension(extension, modelObject);
        }
    }

    private void validateModelObjectForExtension(Extension extension, EObject modelObject) {
        if (this.isExtensionApplicable(extension, modelObject)) {
            EList<Extension> appliedExtensions = this.getAppliedExtensions(extension, modelObject);
            if (extension.getLowerBound() > appliedExtensions.size()) {
                this.violations.add((Object)new LowerBoundConstraintViolation(extension, modelObject));
            }
        }
    }

    private EList<Extension> getAppliedExtensions(Extension extension, EObject modelObject) {
        EList<StereotypeApplication> stereotypeApplications = this.profileApplication.getStereotypeApplications(modelObject);
        BasicEList appliedExtension = new BasicEList();
        for (StereotypeApplication stereotypeApplication : stereotypeApplications) {
            if (!EcoreUtil.equals((EObject)extension, (EObject)stereotypeApplication.getExtension()) && !this.isSubsetted(extension, stereotypeApplication.getExtension())) continue;
            appliedExtension.add((Object)stereotypeApplication.getExtension());
        }
        return appliedExtension;
    }

    private void cleanViolationsConcerningSubsettedExtensions() {
        for (LowerBoundConstraintViolation violation : new BasicEList(this.violations)) {
            if (!this.foundViolationForSubsettingForSameModelObject(violation)) continue;
            this.violations.remove((Object)violation);
        }
    }

    private boolean foundViolationForSubsettingForSameModelObject(LowerBoundConstraintViolation violation) {
        for (LowerBoundConstraintViolation currentViolation : this.violations) {
            if (!this.isSubsetted(violation.getExtension(), currentViolation.getExtension()) || !EcoreUtil.equals((EObject)currentViolation.getModelObject(), (EObject)violation.getModelObject())) continue;
            return true;
        }
        return false;
    }

    private boolean isSubsetted(Extension extension, Extension extension2) {
        for (Extension subsettedExtension : extension2.getSubsetted()) {
            if (!EcoreUtil.equals((EObject)subsettedExtension, (EObject)extension)) continue;
            return true;
        }
        return false;
    }

    private boolean isExtensionApplicable(Extension extension, EObject eObject) {
        Stereotype stereotype = extension.getSource();
        EList<Extension> applicableExtensions = stereotype.getApplicableExtensions(eObject, this.getEmptyExtensionList());
        return applicableExtensions.size() > 0 && applicableExtensions.contains((Object)extension);
    }

    private EList<Extension> getEmptyExtensionList() {
        return ECollections.emptyEList();
    }
}

