/*
 * Decompiled with CFR 0.152.
 */
package org.modelversioning.emfprofile.impl;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.modelversioning.emfprofile.Extension;

public class ExtensionApplicabilityAdvisor {
    Map<Extension, Integer> remainingApplications = new HashMap<Extension, Integer>();
    final EList<Extension> allExtensions;
    final EList<Extension> usedExtensions;

    public ExtensionApplicabilityAdvisor(EList<Extension> allExtensions, EList<Extension> usedExtensions) {
        this.allExtensions = allExtensions;
        this.usedExtensions = usedExtensions;
        this.initializeRemainingApplications();
        this.computeRemainingApplications();
    }

    private void initializeRemainingApplications() {
        for (Extension extension : this.allExtensions) {
            int upperBound = extension.getUpperBound();
            this.remainingApplications.put(extension, upperBound);
        }
    }

    private void computeRemainingApplications() {
        for (Extension extension : this.allExtensions) {
            int usedExtensionCount = this.countOccurrencesInUsedExtensions(extension);
            int remainingApplicationCount = this.remainingApplications.get(extension) - usedExtensionCount;
            this.remainingApplications.put(extension, remainingApplicationCount);
        }
    }

    private int countOccurrencesInUsedExtensions(Extension extension) {
        int count = 0;
        for (Extension usedExtension : this.usedExtensions) {
            if (!this.equals(extension, usedExtension) && !this.isSubsettingExtensionUsed(extension, usedExtension)) continue;
            ++count;
        }
        return count;
    }

    private boolean isSubsettingExtensionUsed(Extension extension, Extension usedExtension) {
        for (Extension subsettingExtension : extension.getSubsetting()) {
            if (!this.equals(usedExtension, subsettingExtension)) continue;
            return true;
        }
        return false;
    }

    private boolean equals(Extension extension1, Extension extension2) {
        return EcoreUtil.equals((EObject)extension1, (EObject)extension2);
    }

    public EList<Extension> getApplicableExtensions() {
        BasicEList reminingExtensions = new BasicEList();
        for (Extension extension : this.allExtensions) {
            if (this.getRemainingApplicationCount(extension) == 0) continue;
            reminingExtensions.add((Object)extension);
        }
        return ECollections.unmodifiableEList((EList)reminingExtensions);
    }

    private int getRemainingApplicationCount(Extension extension) {
        return this.remainingApplications.get(extension);
    }
}

