/*
 * Decompiled with CFR 0.152.
 */
package org.modelversioning.emfprofile.impl;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.modelversioning.emfprofile.Extension;
import org.modelversioning.emfprofile.IProfileFacade;
import org.modelversioning.emfprofile.Profile;
import org.modelversioning.emfprofile.Stereotype;
import org.modelversioning.emfprofileapplication.ProfileApplication;
import org.modelversioning.emfprofileapplication.ProfileImport;
import org.modelversioning.emfprofileapplication.StereotypeApplicability;
import org.modelversioning.emfprofileapplication.StereotypeApplication;
import org.modelversioning.emfprofileapplication.util.ProfileImportResolver;

public class ProfileFacadeImpl
implements IProfileFacade {
    private static final String STEREOTYPE_NOT_APPLICABLE = "Stereotype is not applicable to the object.";
    private static final String STEREOTYPE_APP_RESOURCE_ERROR = "Specified resource for the stereotype application is not set, null, or unloaded.";
    private static final long SAVE_JOB_TIMEOUT_MS = 60000L;
    private EList<Profile> profiles = new BasicEList();
    private Resource profileApplicationResource;
    private IFile profileApplicationFile;

    @Override
    public void makeApplicable(Profile profile) {
        for (Stereotype stereotype : profile.getStereotypes()) {
            if (stereotype.getESuperTypes().contains((Object)STEREOTYPE_APPLICATION_ECLASS)) continue;
            stereotype.getESuperTypes().add((Object)STEREOTYPE_APPLICATION_ECLASS);
        }
    }

    @Override
    public void save() throws IOException {
        if (this.profileApplicationResource != null) {
            if (this.requireTransaction()) {
                TransactionalEditingDomain domain = this.getTransactionalEditingDomain();
                this.doProfileApplicationResourceSave();
                ((BasicCommandStack)domain.getCommandStack()).saveIsDone();
            } else {
                this.doProfileApplicationResourceSave();
            }
        }
    }

    private void doProfileApplicationResourceSave() throws IOException {
        final HashMap<String, String> saveOptions = new HashMap<String, String>();
        saveOptions.put("SAVE_ONLY_IF_CHANGED", "MEMORY_BUFFER");
        WorkspaceJob job = new WorkspaceJob("Saving Profile Application"){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                try {
                    ProfileFacadeImpl.this.profileApplicationResource.save(saveOptions);
                    ProfileFacadeImpl.this.profileApplicationFile.refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (IOException e) {
                    return new Status(4, "org.modelversioning.emfprofile", e.getMessage(), (Throwable)e);
                }
                return new Status(0, "org.modelversioning.emfprofile", "OK");
            }
        };
        job.schedule();
        try {
            job.join(60000L, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (InterruptedException e) {
            throw new IOException("Interrupted while waiting for save to be finished", e);
        }
    }

    @Override
    public void loadProfile(Profile profile) {
        this.profiles.add((Object)profile);
        if (this.profileApplicationResource != null) {
            this.profileApplicationResource.getResourceSet().getPackageRegistry().put((Object)profile.getNsURI(), (Object)profile);
        }
    }

    @Override
    public void unloadProfile(Profile profile) {
        this.profiles.remove((Object)profile);
    }

    @Override
    public void loadProfiles(Resource resource) {
        for (EObject eObject : resource.getContents()) {
            if (!(eObject instanceof Profile)) continue;
            this.loadProfile((Profile)eObject);
        }
    }

    @Override
    public void loadProfiles(EList<Profile> profiles) {
        this.profiles.addAll(profiles);
    }

    @Override
    public EList<Profile> getLoadedProfiles() {
        return ECollections.unmodifiableEList(this.profiles);
    }

    @Override
    public void setProfileApplicationFileAndInitializeResource(IFile profileApplicationFile, ResourceSet resourceSet) throws IOException {
        this.setProfileApplicationResource(this.createProfileApplicationResource(profileApplicationFile, resourceSet));
        this.profileApplicationFile = profileApplicationFile;
        try {
            profileApplicationFile.touch(null);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    private Resource createProfileApplicationResource(IFile profileApplicationFile, ResourceSet resourceSet) throws IOException {
        Resource profileApplicationResource = resourceSet.createResource(URI.createFileURI((String)profileApplicationFile.getLocation().toString()));
        if (!profileApplicationFile.exists()) {
            profileApplicationResource.save(Collections.emptyMap());
        }
        profileApplicationResource.load(Collections.emptyMap());
        return profileApplicationResource;
    }

    @Override
    public void setProfileApplicationResource(Resource resource) throws IOException {
        this.profileApplicationResource = resource;
        if (!this.profileApplicationResource.isLoaded()) {
            this.profileApplicationResource.load(Collections.emptyMap());
        }
        EcoreUtil.resolveAll((Resource)this.profileApplicationResource);
        EList<ProfileApplication> profileApplications = this.getProfileApplications(this.profileApplicationResource);
        for (ProfileApplication application : profileApplications) {
            for (final ProfileImport profileImport : application.getImportedProfiles()) {
                if (this.requireTransaction()) {
                    TransactionalEditingDomain domain = this.getTransactionalEditingDomain();
                    domain.getCommandStack().execute((Command)new RecordingCommand(domain){

                        protected void doExecute() {
                            ProfileImportResolver.resolve(profileImport, ProfileFacadeImpl.this.profileApplicationResource.getResourceSet());
                        }
                    });
                } else {
                    ProfileImportResolver.resolve(profileImport, this.profileApplicationResource.getResourceSet());
                }
                this.profiles.add((Object)profileImport.getProfile());
            }
        }
        for (Profile profile : this.profiles) {
            this.profileApplicationResource.getResourceSet().getPackageRegistry().put((Object)profile.getNsURI(), (Object)profile);
        }
    }

    private EList<ProfileApplication> getProfileApplications(Resource resource) {
        BasicEList profileApplications = new BasicEList();
        for (EObject eObject : resource.getContents()) {
            if (!(eObject instanceof ProfileApplication)) continue;
            profileApplications.add((Object)((ProfileApplication)eObject));
        }
        return profileApplications;
    }

    @Override
    public EList<StereotypeApplicability> getApplicableStereotypes(EClass eClass) {
        BasicEList stereotypeApplicabilities = new BasicEList();
        for (Profile profile : this.profiles) {
            for (Stereotype stereotype : profile.getApplicableStereotypes(eClass)) {
                for (Extension extension : stereotype.getApplicableExtensions(eClass)) {
                    stereotypeApplicabilities.add((Object)this.createApplicableStereotype(stereotype, extension));
                }
            }
        }
        return stereotypeApplicabilities;
    }

    private StereotypeApplicability createApplicableStereotype(Stereotype stereotype, Extension extension) {
        StereotypeApplicability stereotypeApplicability = EMF_PROFILE_APPLICATION_FACTORY.createStereotypeApplicability();
        stereotypeApplicability.setStereotype(stereotype);
        stereotypeApplicability.setExtension(extension);
        return stereotypeApplicability;
    }

    @Override
    public EList<StereotypeApplicability> getApplicableStereotypes(EObject eObject) {
        EList<StereotypeApplicability> stereotypeApplicabilities = this.getApplicableStereotypes(eObject.eClass());
        for (StereotypeApplicability stereotypeApplicability : new BasicEList(stereotypeApplicabilities)) {
            if (this.isApplicable(stereotypeApplicability.getStereotype(), eObject, stereotypeApplicability.getExtension())) continue;
            stereotypeApplicabilities.remove((Object)stereotypeApplicability);
        }
        return stereotypeApplicabilities;
    }

    @Override
    public boolean isApplicable(Stereotype stereotype, EObject eObject) {
        return stereotype.isApplicable(eObject, this.extractAppliedExtensions(this.getAppliedStereotypes(eObject)));
    }

    @Override
    public boolean isApplicable(Stereotype stereotype, EObject eObject, Extension extension) {
        return stereotype.isApplicable(eObject, extension, this.extractAppliedExtensions(this.getAppliedStereotypes(eObject)));
    }

    private EList<Extension> extractAppliedExtensions(EList<StereotypeApplication> appliedStereotypes) {
        BasicEList appliedExtensions = new BasicEList();
        for (StereotypeApplication stereotypeApplication : appliedStereotypes) {
            appliedExtensions.add((Object)stereotypeApplication.getExtension());
        }
        return appliedExtensions;
    }

    @Override
    public StereotypeApplication apply(StereotypeApplicability stereotypeApplicability, EObject eObject) {
        return this.apply(stereotypeApplicability.getStereotype(), eObject, stereotypeApplicability.getExtension());
    }

    @Override
    public StereotypeApplication apply(Stereotype stereotype, EObject eObject) {
        Extension defaultExtension = this.getDefaultExtension(stereotype, eObject);
        return this.apply(stereotype, eObject, defaultExtension);
    }

    private Extension getDefaultExtension(Stereotype stereotype, EObject eObject) {
        EList<Extension> applicableExtensions = this.getApplicableExtensions(stereotype, eObject);
        if (applicableExtensions.size() > 0) {
            return (Extension)applicableExtensions.get(0);
        }
        throw new IllegalArgumentException(STEREOTYPE_NOT_APPLICABLE);
    }

    private EList<Extension> getApplicableExtensions(Stereotype stereotype, EObject eObject) {
        return stereotype.getApplicableExtensions(eObject, this.extractAppliedExtensions(this.getAppliedStereotypes(eObject)));
    }

    @Override
    public StereotypeApplication apply(Stereotype stereotype, EObject eObject, Extension extension) {
        if (!this.isApplicable(stereotype, eObject, extension)) {
            throw new IllegalArgumentException(STEREOTYPE_NOT_APPLICABLE);
        }
        StereotypeApplication stereotypeApplication = this.createStereotypeApplication(stereotype);
        this.setExtension(stereotypeApplication, extension);
        this.apply(stereotypeApplication, eObject);
        return stereotypeApplication;
    }

    private void setExtension(final StereotypeApplication stereotypeApplication, final Extension extension) {
        if (this.requireTransaction()) {
            TransactionalEditingDomain domain = this.getTransactionalEditingDomain();
            domain.getCommandStack().execute((Command)new RecordingCommand(domain){

                protected void doExecute() {
                    stereotypeApplication.setExtension(extension);
                }
            });
        } else {
            stereotypeApplication.setExtension(extension);
        }
    }

    protected StereotypeApplication createStereotypeApplication(Stereotype stereotype) {
        final StereotypeApplication stereotypeInstance = (StereotypeApplication)stereotype.getEPackage().getEFactoryInstance().create((EClass)stereotype);
        final ProfileApplication profileApplication = this.findOrCreateProfileApplication(stereotype.getProfile());
        if (this.requireTransaction()) {
            TransactionalEditingDomain domain = this.getTransactionalEditingDomain();
            domain.getCommandStack().execute((Command)new RecordingCommand(domain){

                protected void doExecute() {
                    profileApplication.getStereotypeApplications().add((Object)stereotypeInstance);
                }
            });
        } else {
            profileApplication.getStereotypeApplications().add((Object)stereotypeInstance);
        }
        return stereotypeInstance;
    }

    @Override
    public ProfileApplication findOrCreateProfileApplication(final Profile profile) {
        boolean found = false;
        ProfileApplication profileApplication = null;
        for (EObject eObject : this.profileApplicationResource.getContents()) {
            if (!(eObject instanceof ProfileApplication)) continue;
            found = true;
            final ProfileApplication finalProfileApplication = profileApplication = (ProfileApplication)eObject;
            if (!this.hasProfileImport(profileApplication, profile)) {
                if (this.requireTransaction()) {
                    TransactionalEditingDomain domain = this.getTransactionalEditingDomain();
                    domain.getCommandStack().execute((Command)new RecordingCommand(domain){

                        protected void doExecute() {
                            finalProfileApplication.getImportedProfiles().add((Object)ProfileFacadeImpl.this.createProfileImport(profile));
                        }
                    });
                } else {
                    finalProfileApplication.getImportedProfiles().add((Object)this.createProfileImport(profile));
                }
            }
            profileApplication = finalProfileApplication;
        }
        if (!found) {
            profileApplication = this.createProfileApplication();
            profileApplication.getImportedProfiles().add((Object)this.createProfileImport(profile));
            this.addToResource(profileApplication);
        }
        return profileApplication;
    }

    private ProfileApplication createProfileApplication() {
        return EMF_PROFILE_APPLICATION_FACTORY.createProfileApplication();
    }

    private boolean hasProfileImport(ProfileApplication profileApplication, Profile profile) {
        for (ProfileImport profileImport : profileApplication.getImportedProfiles()) {
            try {
                if (!profileImport.getNsURI().equals(profile.getNsURI())) continue;
                return true;
            }
            catch (NullPointerException npe) {
                return false;
            }
        }
        return false;
    }

    private ProfileImport createProfileImport(Profile profile) {
        ProfileImport profileImport = EMF_PROFILE_APPLICATION_FACTORY.createProfileImport();
        profileImport.setProfile(profile);
        return profileImport;
    }

    private void apply(final StereotypeApplication stereotypeApplication, final EObject eObject) {
        if (this.requireTransaction()) {
            TransactionalEditingDomain domain = this.getTransactionalEditingDomain();
            domain.getCommandStack().execute((Command)new RecordingCommand(domain){

                protected void doExecute() {
                    stereotypeApplication.setAppliedTo(eObject);
                }
            });
        } else {
            stereotypeApplication.setAppliedTo(eObject);
        }
    }

    protected void addToResource(final EObject eObject) {
        if (this.profileApplicationResource == null || !this.profileApplicationResource.isLoaded()) {
            throw new IllegalArgumentException(STEREOTYPE_APP_RESOURCE_ERROR);
        }
        if (!this.profileApplicationResource.getContents().contains((Object)eObject)) {
            if (this.requireTransaction()) {
                TransactionalEditingDomain domain = this.getTransactionalEditingDomain();
                domain.getCommandStack().execute((Command)new RecordingCommand(domain){

                    protected void doExecute() {
                        ProfileFacadeImpl.this.profileApplicationResource.getContents().add((Object)eObject);
                    }
                });
            } else {
                this.profileApplicationResource.getContents().add((Object)eObject);
            }
        }
    }

    @Override
    public EList<StereotypeApplication> getStereotypeApplications() {
        BasicEList stereotypeApplications = new BasicEList();
        for (ProfileApplication profileApplication : this.getProfileApplications(this.profileApplicationResource)) {
            stereotypeApplications.addAll(profileApplication.getStereotypeApplications());
        }
        return ECollections.unmodifiableEList((EList)stereotypeApplications);
    }

    @Override
    public EList<StereotypeApplication> getAppliedStereotypes(EObject eObject) {
        BasicEList stereotypeApplications = new BasicEList();
        for (ProfileApplication profileApplication : this.getProfileApplications(this.profileApplicationResource)) {
            stereotypeApplications.addAll(profileApplication.getStereotypeApplications(eObject));
        }
        return ECollections.unmodifiableEList((EList)stereotypeApplications);
    }

    protected EList<StereotypeApplication> getAppliedStereotypes(EObject eObject, Stereotype stereotype) {
        BasicEList stereotypeApplications = new BasicEList();
        for (ProfileApplication profileApplication : this.getProfileApplications(this.profileApplicationResource)) {
            stereotypeApplications.addAll(profileApplication.getStereotypeApplications(eObject, stereotype));
        }
        return ECollections.unmodifiableEList((EList)stereotypeApplications);
    }

    @Override
    public void removeStereotypeApplication(final StereotypeApplication stereotypeApplication) {
        if (this.requireTransaction()) {
            TransactionalEditingDomain domain = this.getTransactionalEditingDomain();
            domain.getCommandStack().execute((Command)new RecordingCommand(domain){

                protected void doExecute() {
                    EcoreUtil.remove((EObject)stereotypeApplication);
                }
            });
        } else {
            EcoreUtil.remove((EObject)stereotypeApplication);
        }
    }

    @Override
    public EList<EStructuralFeature> getStereotypeFeatures(Stereotype stereotype) {
        BasicEList features = new BasicEList();
        for (EStructuralFeature feature : stereotype.getEAllStructuralFeatures()) {
            if (STEREOTYPE_APPLICATION_APPLIED_TO_REFERENCE.equals(feature)) continue;
            features.add((Object)feature);
        }
        return features;
    }

    @Override
    public Object getTaggedValue(EObject stereotypeApplication, EStructuralFeature taggedValue) {
        return stereotypeApplication.eGet(taggedValue);
    }

    @Override
    public void setTaggedValue(EObject stereotypeApplication, EStructuralFeature taggedValue, Object newValue) {
        if (this.requireTransaction()) {
            TransactionalEditingDomain domain = this.getTransactionalEditingDomain();
            Command command = domain.createCommand(SetCommand.class, new CommandParameter((Object)stereotypeApplication, (Object)taggedValue, newValue));
            domain.getCommandStack().execute(command);
        } else {
            stereotypeApplication.eSet(taggedValue, newValue);
        }
    }

    private boolean requireTransaction() {
        return this.getTransactionalEditingDomain() != null;
    }

    private TransactionalEditingDomain getTransactionalEditingDomain() {
        return TransactionUtil.getEditingDomain((Resource)this.profileApplicationResource);
    }

    @Override
    public void unload() {
    }

    @Override
    public Diagnostic validateAll(EObject currentlySelectedEObject) {
        Map<String, EObject> context = this.createValidationContextMap(currentlySelectedEObject);
        Diagnostic diagnostic = null;
        for (ProfileApplication profileApplication : this.getProfileApplications(this.profileApplicationResource)) {
            diagnostic = Diagnostician.INSTANCE.validate((EObject)profileApplication, context);
            if (diagnostic.getSeverity() == 0) continue;
            return diagnostic;
        }
        if (diagnostic != null) {
            return diagnostic;
        }
        return EcoreUtil.computeDiagnostic((Resource)this.profileApplicationResource, (boolean)true);
    }

    private Map<String, EObject> createValidationContextMap(EObject currentlySelectedEObject) {
        HashMap<String, EObject> context = new HashMap<String, EObject>();
        context.put("MODEL_OBJECT", currentlySelectedEObject);
        return context;
    }

    @Override
    public Resource getProfileApplicationResource() {
        return this.profileApplicationResource;
    }

    @Override
    public EList<ProfileApplication> getProfileApplications() {
        return this.getProfileApplications(this.profileApplicationResource);
    }

    @Override
    public void removeEObject(final EObject eObject) {
        if (this.requireTransaction()) {
            TransactionalEditingDomain domain = this.getTransactionalEditingDomain();
            domain.getCommandStack().execute((Command)new RecordingCommand(domain){

                protected void doExecute() {
                    EcoreUtil.remove((EObject)eObject);
                }
            });
        } else {
            EcoreUtil.remove((EObject)eObject);
        }
    }

    @Override
    public void addNestedEObject(final EObject container, final EReference eReference, final EObject eObject) {
        if (this.requireTransaction()) {
            TransactionalEditingDomain domain = this.getTransactionalEditingDomain();
            domain.getCommandStack().execute((Command)new RecordingCommand(domain){

                protected void doExecute() {
                    if (eReference.isMany()) {
                        ((List)container.eGet((EStructuralFeature)eReference)).add(eObject);
                    } else {
                        container.eSet((EStructuralFeature)eReference, (Object)eObject);
                    }
                }
            });
        } else if (eReference.isMany()) {
            ((List)container.eGet((EStructuralFeature)eReference)).add(eObject);
        } else {
            container.eSet((EStructuralFeature)eReference, (Object)eObject);
        }
    }
}

