/*
 * Decompiled with CFR 0.152.
 */
package org.modelversioning.emfprofile.presentation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.provider.EcoreEditPlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.ui.action.LoadResourceAction;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class ExtendedLoadResourceAction
extends LoadResourceAction {
    private Shell shell;

    public EditingDomain getEditingDomain() {
        return super.getEditingDomain();
    }

    public ExtendedLoadResourceAction() {
    }

    public ExtendedLoadResourceAction(EditingDomain domain) {
        super(domain);
    }

    public void setEditingDomain(EditingDomain domain) {
        super.setEditingDomain(domain);
    }

    public void run() {
        Object firstResult;
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.shell, (ILabelProvider)new LabelProvider(){

            public Image getImage(Object element) {
                return ExtendedImageRegistry.getInstance().getImage(EcoreEditPlugin.INSTANCE.getImage("full/obj16/EPackage"));
            }
        });
        dialog.setTitle("Select Base Metamodel:");
        dialog.setMessage("Select a String (* = any string, ? = any char):");
        dialog.setElements(this.getRegistryEntries());
        if (dialog.open() == 0 && (firstResult = dialog.getFirstResult()) != null && firstResult instanceof String) {
            String testURI = firstResult.toString();
            URI packageURI = this.getRegistryEntryURI(firstResult);
            if (this.getEditingDomain() != null) {
                ResourceSet resourceSet = this.getEditingDomain().getResourceSet();
                Resource resource = resourceSet.getResource(packageURI, true);
                try {
                    resource.load(Collections.emptyMap());
                    resource.setURI(URI.createURI((String)((String)firstResult), (boolean)true));
                    EObject eObject = (EObject)resource.getContents().get(0);
                    if (eObject instanceof EPackage) {
                        resourceSet.getPackageRegistry().put((Object)testURI, (Object)eObject);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private URI getRegistryEntryURI(Object firstResult) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getURIConverter().getURIMap().putAll(EcorePlugin.computePlatformURIMap());
        Map ePackageNsURItoGenModelLocationMap = EcorePlugin.getEPackageNsURIToGenModelLocationMap();
        URI location = (URI)ePackageNsURItoGenModelLocationMap.get((String)firstResult);
        Resource resource = resourceSet.getResource(location, true);
        EcoreUtil.resolveAll((Resource)resource);
        URI realURI = null;
        block0: for (Resource resourceIt : resourceSet.getResources()) {
            for (EPackage ePackage : this.getAllPackages(resourceIt)) {
                if (!firstResult.equals(ePackage.getNsURI())) continue;
                realURI = resourceIt.getURI();
                continue block0;
            }
        }
        return realURI;
    }

    protected Collection<EPackage> getAllPackages(Resource resource) {
        ArrayList<EPackage> result = new ArrayList<EPackage>();
        EcoreUtil.ContentTreeIterator<Object> j = new EcoreUtil.ContentTreeIterator<Object>((Collection)resource.getContents()){
            private static final long serialVersionUID = 1L;

            protected Iterator<? extends EObject> getEObjectChildren(EObject eObject) {
                return eObject instanceof EPackage ? ((EPackage)eObject).getESubpackages().iterator() : Collections.emptyList().iterator();
            }
        };
        while (j.hasNext()) {
            Object content = j.next();
            if (!(content instanceof EPackage)) continue;
            result.add((EPackage)content);
        }
        return result;
    }

    public void update() {
        super.update();
    }

    public void setText(String text) {
        super.setText("Select Base Metamodel...");
    }

    public void setActiveWorkbenchPart(IWorkbenchPart workbenchPart) {
        super.setActiveWorkbenchPart(workbenchPart);
        System.out.println("WorkbenchPart: " + workbenchPart);
    }

    public Object[] getRegistryEntries() {
        Object[] result = EPackage.Registry.INSTANCE.keySet().toArray(new Object[EPackage.Registry.INSTANCE.size()]);
        Arrays.sort(result);
        return result;
    }
}

