/*
 * Decompiled with CFR 0.152.
 */
package org.modelversioning.emfprofile.tests;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import junit.framework.Assert;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.modelversioning.emfprofile.Extension;
import org.modelversioning.emfprofile.IProfileFacade;
import org.modelversioning.emfprofile.Profile;
import org.modelversioning.emfprofile.Stereotype;
import org.modelversioning.emfprofile.impl.ProfileFacadeImpl;
import org.modelversioning.emfprofileapplication.StereotypeApplication;

public class BasicProfileFacadeTest {
    private static final String ABSTRACT_STEREOTYPE_FOR_ECLASS_NAME = "AbstractForEClass";
    private static final String CONCRETE_STEREOTYPE_FOR_ECLASS_NAME = "ConcreteForEClassInherited";
    private static final String CONCRETE_STEREOTYPE_FOR_ECLASSIFIER_NAME = "ConcreteForEClassifiers";
    private static final String CONCRETE_STEREOTYPE_FOR_EATTRIBUTE_NAME = "ConcreteForEAttribute";
    private static final String SUB_STEREOTYPE_FOR_EATTRIBUTE_NAME = "SubForEAttribute";
    private static final String modelPath = "model/basic/sample_ecore_model.ecore";
    private static final String profilePath = "model/basic/profile_for_ecore_models.emfprofile_diagram";
    private static final String profileApplicationPath = "model/basic/annotation.emfprofile.xmi";
    private final ResourceSet resourceSet = new ResourceSetImpl();
    private Profile profile;
    private Resource model;

    @Before
    public void loadProfile() {
        String absolutePath = this.getAbsolutePath(profilePath);
        Resource resource = this.loadResource(absolutePath);
        this.profile = this.extractProfile(resource);
    }

    @Before
    public void loadModel() {
        String absolutePath = this.getAbsolutePath(modelPath);
        this.model = this.loadResource(absolutePath);
    }

    private Profile extractProfile(Resource resource) {
        return (Profile)resource.getContents().get(0);
    }

    private String getAbsolutePath(String relativePath) {
        return new File(relativePath).getAbsolutePath();
    }

    private Resource loadResource(String path) {
        return this.resourceSet.getResource(URI.createFileURI((String)path), true);
    }

    @Test
    public void testAppliedToValueAfterApplyingStereotype() throws IOException {
        IProfileFacade profileFacade = this.createProfileFacade();
        Stereotype stereotype = this.getStereotype(CONCRETE_STEREOTYPE_FOR_ECLASS_NAME);
        EClass person = this.getModelPersonEClass();
        StereotypeApplication stereotypeApplication = profileFacade.apply(stereotype, (EObject)person);
        Assert.assertEquals((Object)person, (Object)stereotypeApplication.getAppliedTo());
    }

    private EClass getModelPersonEClass() {
        return (EClass)this.getModelEPackage().eContents().get(0);
    }

    private EAttribute getModelPersonFirstNameEAttribute() {
        return (EAttribute)this.getModelPersonEClass().getEStructuralFeature("firstName");
    }

    private EObject getModelEPackage() {
        return (EObject)this.model.getContents().get(0);
    }

    private Stereotype getStereotype(String stereotypeName) {
        return this.profile.getStereotype(stereotypeName);
    }

    private IProfileFacade createProfileFacade() throws IOException {
        ProfileFacadeImpl profileFacade = new ProfileFacadeImpl();
        profileFacade.loadProfile(this.profile);
        Resource profileApplicationRes = this.createProfileApplicationResource();
        profileFacade.setProfileApplicationResource(profileApplicationRes);
        return profileFacade;
    }

    private Resource createProfileApplicationResource() throws IOException {
        String absolutePath = this.getAbsolutePath(profileApplicationPath);
        return this.createResource(absolutePath);
    }

    private Resource createResource(String path) throws IOException {
        this.deleteIfFileExists(path);
        Resource resource = this.resourceSet.createResource(URI.createFileURI((String)path));
        resource.save(Collections.emptyMap());
        return resource;
    }

    private void deleteIfFileExists(String path) {
        File file = new File(path);
        if (file.exists()) {
            file.delete();
        }
    }

    @Test
    public void testTypeOfAppliedStereotype() throws IOException {
        IProfileFacade profileFacade = this.createProfileFacade();
        Stereotype stereotype = this.getStereotype(CONCRETE_STEREOTYPE_FOR_ECLASS_NAME);
        EClass person = this.getModelPersonEClass();
        StereotypeApplication stereotypeApplication = profileFacade.apply(stereotype, (EObject)person);
        Assert.assertTrue((boolean)stereotypeApplication.eClass().equals(stereotype));
    }

    @Test
    public void testExtensionOfAppliedStereotype() throws IOException {
        IProfileFacade profileFacade = this.createProfileFacade();
        Stereotype stereotype = this.getStereotype(CONCRETE_STEREOTYPE_FOR_ECLASS_NAME);
        EClass person = this.getModelPersonEClass();
        StereotypeApplication stereotypeApplication = profileFacade.apply(stereotype, (EObject)person);
        Stereotype superStereotype = this.getStereotype(ABSTRACT_STEREOTYPE_FOR_ECLASS_NAME);
        Extension expectedExtension = (Extension)superStereotype.getExtensions().get(0);
        Assert.assertEquals((Object)expectedExtension, (Object)stereotypeApplication.getExtension());
    }

    @Test
    public void testSavingAndReloadingExistingProfileApplication() throws IOException {
        IProfileFacade profileFacade = this.createProfileFacade();
        Stereotype stereotype = this.getStereotype(CONCRETE_STEREOTYPE_FOR_ECLASS_NAME);
        EClass person = this.getModelPersonEClass();
        StereotypeApplication application = profileFacade.apply(stereotype, (EObject)person);
        EStructuralFeature taggedValue = stereotype.getTaggedValue("testTaggedValue");
        profileFacade.setTaggedValue((EObject)application, taggedValue, (Object)"test");
        profileFacade.save();
        profileFacade = new ProfileFacadeImpl();
        profileFacade.loadProfile(this.profile);
        String absolutePath = this.getAbsolutePath(profileApplicationPath);
        Resource profileApplicationRes = this.loadResource(absolutePath);
        profileFacade.setProfileApplicationResource(profileApplicationRes);
        EList appliedStereotypes = profileFacade.getAppliedStereotypes((EObject)person);
        Assert.assertEquals((int)1, (int)appliedStereotypes.size());
        StereotypeApplication stereotypeApplication = (StereotypeApplication)appliedStereotypes.get(0);
        Assert.assertTrue((boolean)stereotypeApplication.eClass().equals(stereotype));
        Assert.assertEquals((Object)person, (Object)stereotypeApplication.getAppliedTo());
        Object value = profileFacade.getTaggedValue((EObject)stereotypeApplication, taggedValue);
        Assert.assertEquals((Object)"test", (Object)value);
    }

    @Test
    public void testRemovingExistingProfileApplication() throws IOException {
        IProfileFacade profileFacade = this.createProfileFacade();
        Stereotype stereotype = this.getStereotype(CONCRETE_STEREOTYPE_FOR_ECLASS_NAME);
        EClass person = this.getModelPersonEClass();
        StereotypeApplication application = profileFacade.apply(stereotype, (EObject)person);
        EStructuralFeature taggedValue = stereotype.getTaggedValue("testTaggedValue");
        profileFacade.setTaggedValue((EObject)application, taggedValue, (Object)"test");
        profileFacade.save();
        profileFacade = new ProfileFacadeImpl();
        profileFacade.loadProfile(this.profile);
        String absolutePath = this.getAbsolutePath(profileApplicationPath);
        Resource profileApplicationRes = this.loadResource(absolutePath);
        profileFacade.setProfileApplicationResource(profileApplicationRes);
        Assert.assertEquals((int)1, (int)profileFacade.getAppliedStereotypes((EObject)person).size());
        StereotypeApplication stereotypeApplication = (StereotypeApplication)profileFacade.getAppliedStereotypes((EObject)person).get(0);
        profileFacade.removeStereotypeApplication(stereotypeApplication);
        Assert.assertEquals((int)0, (int)profileFacade.getAppliedStereotypes((EObject)person).size());
        profileFacade.save();
        Assert.assertEquals((int)0, (int)profileFacade.getAppliedStereotypes((EObject)person).size());
    }

    @Test
    public void testApplicabilityOfSubmetaclass() throws IOException {
        IProfileFacade profileFacade = this.createProfileFacade();
        Stereotype stereotype = this.getStereotype(CONCRETE_STEREOTYPE_FOR_ECLASSIFIER_NAME);
        EClass person = this.getModelPersonEClass();
        Assert.assertTrue((boolean)profileFacade.isApplicable(stereotype, (EObject)person));
    }

    @Test
    public void testInapplicabilityCausedByAbstract() throws IOException {
        IProfileFacade profileFacade = this.createProfileFacade();
        Stereotype stereotype = this.getStereotype(ABSTRACT_STEREOTYPE_FOR_ECLASS_NAME);
        EClass person = this.getModelPersonEClass();
        Assert.assertFalse((boolean)profileFacade.isApplicable(stereotype, (EObject)person));
    }

    @Test
    public void testInapplicabilityCausedByWrongBaseType() throws IOException {
        IProfileFacade profileFacade = this.createProfileFacade();
        Stereotype stereotype = this.getStereotype(CONCRETE_STEREOTYPE_FOR_ECLASSIFIER_NAME);
        EAttribute firstNameAttribute = this.getModelPersonFirstNameEAttribute();
        Assert.assertFalse((boolean)profileFacade.isApplicable(stereotype, (EObject)firstNameAttribute));
    }

    @Test
    public void testInapplicabilityCausedByUpperBound() throws IOException {
        IProfileFacade profileFacade = this.createProfileFacade();
        Stereotype stereotype = this.getStereotype(CONCRETE_STEREOTYPE_FOR_EATTRIBUTE_NAME);
        EAttribute firstNameAttribute = this.getModelPersonFirstNameEAttribute();
        Assert.assertTrue((boolean)profileFacade.isApplicable(stereotype, (EObject)firstNameAttribute));
        profileFacade.apply(stereotype, (EObject)firstNameAttribute);
        Assert.assertTrue((boolean)profileFacade.isApplicable(stereotype, (EObject)firstNameAttribute));
        profileFacade.apply(stereotype, (EObject)firstNameAttribute);
        Assert.assertFalse((boolean)profileFacade.isApplicable(stereotype, (EObject)firstNameAttribute));
    }

    @Test
    public void testInapplicabilityCausedByUpperBoundWithMixedStereotypes() throws IOException {
        IProfileFacade profileFacade = this.createProfileFacade();
        Stereotype stereotype1 = this.getStereotype(CONCRETE_STEREOTYPE_FOR_EATTRIBUTE_NAME);
        Stereotype stereotype2 = this.getStereotype(SUB_STEREOTYPE_FOR_EATTRIBUTE_NAME);
        EAttribute firstNameAttribute = this.getModelPersonFirstNameEAttribute();
        Assert.assertTrue((boolean)profileFacade.isApplicable(stereotype1, (EObject)firstNameAttribute));
        profileFacade.apply(stereotype1, (EObject)firstNameAttribute);
        Assert.assertTrue((boolean)profileFacade.isApplicable(stereotype2, (EObject)firstNameAttribute));
        profileFacade.apply(stereotype1, (EObject)firstNameAttribute);
        Assert.assertFalse((boolean)profileFacade.isApplicable(stereotype1, (EObject)firstNameAttribute));
    }

    @After
    public void deleteProfileApplicationResource() {
        String absolutePath = this.getAbsolutePath(profileApplicationPath);
        this.deleteIfFileExists(absolutePath);
    }
}

