/*
 * Decompiled with CFR 0.152.
 */
package org.modelversioning.emfprofile.tests;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import junit.framework.Assert;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.modelversioning.emfprofile.IProfileFacade;
import org.modelversioning.emfprofile.Profile;
import org.modelversioning.emfprofile.Stereotype;
import org.modelversioning.emfprofile.impl.ProfileFacadeImpl;

public class MetaProfileFacadeTest {
    private static final String METASTEREOTYPE_NAME = "MetaStereotype";
    private static final String SUB_METASTEREOTYPE_NAME = "SubMetaStereotype";
    private static final String SUB_STEREOTYPE_NAME = "SubStereotype";
    private static final String modelPath = "model/meta/sample_ecore_model.ecore";
    private static final String profilePath = "model/meta/metaprofile_for_ecore_models.emfprofile_diagram";
    private static final String profileApplicationPath = "model/meta/annotation.emfprofile.xmi";
    private final ResourceSet resourceSet = new ResourceSetImpl();
    private Profile profile;
    private Resource model;

    @Before
    public void loadProfile() {
        String absolutePath = this.getAbsolutePath(profilePath);
        Resource resource = this.loadResource(absolutePath);
        this.profile = this.extractProfile(resource);
    }

    @Before
    public void loadModel() {
        String absolutePath = this.getAbsolutePath(modelPath);
        this.model = this.loadResource(absolutePath);
    }

    private Profile extractProfile(Resource resource) {
        return (Profile)resource.getContents().get(0);
    }

    private String getAbsolutePath(String relativePath) {
        return new File(relativePath).getAbsolutePath();
    }

    private Resource loadResource(String path) {
        return this.resourceSet.getResource(URI.createFileURI((String)path), true);
    }

    private EClass getModelPersonEClass() {
        return (EClass)this.getModelEPackage().eContents().get(0);
    }

    private EAttribute getModelPersonFirstNameEAttribute() {
        return (EAttribute)this.getModelPersonEClass().getEStructuralFeature("firstName");
    }

    private EObject getModelEPackage() {
        return (EObject)this.model.getContents().get(0);
    }

    private Stereotype getStereotype(String stereotypeName) {
        return this.profile.getStereotype(stereotypeName);
    }

    private IProfileFacade createProfileFacade() throws IOException {
        ProfileFacadeImpl profileFacade = new ProfileFacadeImpl();
        profileFacade.loadProfile(this.profile);
        Resource profileApplicationRes = this.createProfileApplicationResource();
        profileFacade.setProfileApplicationResource(profileApplicationRes);
        return profileFacade;
    }

    private Resource createProfileApplicationResource() throws IOException {
        String absolutePath = this.getAbsolutePath(profileApplicationPath);
        return this.createResource(absolutePath);
    }

    private Resource createResource(String path) throws IOException {
        this.deleteIfFileExists(path);
        Resource resource = this.resourceSet.createResource(URI.createFileURI((String)path));
        resource.save(Collections.emptyMap());
        return resource;
    }

    private void deleteIfFileExists(String path) {
        File file = new File(path);
        if (file.exists()) {
            file.delete();
        }
    }

    @Test
    public void testApplicabilityOfMetaStereotypeToEClass() throws IOException {
        IProfileFacade profileFacade = this.createProfileFacade();
        Stereotype stereotype = this.getStereotype(METASTEREOTYPE_NAME);
        EClass person = this.getModelPersonEClass();
        Assert.assertTrue((boolean)profileFacade.isApplicable(stereotype, (EObject)person));
    }

    @Test
    public void testApplicabilityOfMetaStereotypeToEAttribute() throws IOException {
        IProfileFacade profileFacade = this.createProfileFacade();
        Stereotype stereotype = this.getStereotype(METASTEREOTYPE_NAME);
        EAttribute eAttribute = this.getModelPersonFirstNameEAttribute();
        Assert.assertTrue((boolean)profileFacade.isApplicable(stereotype, (EObject)eAttribute));
    }

    @Test
    public void testApplicabilityOfSubMetaStereotypeToEClass() throws IOException {
        IProfileFacade profileFacade = this.createProfileFacade();
        Stereotype stereotype = this.getStereotype(SUB_METASTEREOTYPE_NAME);
        EClass person = this.getModelPersonEClass();
        Assert.assertTrue((boolean)profileFacade.isApplicable(stereotype, (EObject)person));
    }

    @Test
    public void testApplicabilityOfSubMetaStereotypeToEAttribute() throws IOException {
        IProfileFacade profileFacade = this.createProfileFacade();
        Stereotype stereotype = this.getStereotype(SUB_METASTEREOTYPE_NAME);
        EAttribute eAttribute = this.getModelPersonFirstNameEAttribute();
        Assert.assertTrue((boolean)profileFacade.isApplicable(stereotype, (EObject)eAttribute));
    }

    @Test
    public void testApplicabilityOfSubStereotypeToEClass() throws IOException {
        IProfileFacade profileFacade = this.createProfileFacade();
        Stereotype stereotype = this.getStereotype(SUB_STEREOTYPE_NAME);
        EClass person = this.getModelPersonEClass();
        Assert.assertTrue((boolean)profileFacade.isApplicable(stereotype, (EObject)person));
    }

    @After
    public void deleteProfileApplicationResource() {
        String absolutePath = this.getAbsolutePath(profileApplicationPath);
        this.deleteIfFileExists(absolutePath);
    }
}

