/*
 * Decompiled with CFR 0.152.
 */
package org.modelversioning.emfprofile.tests;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import junit.framework.Assert;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.modelversioning.emfprofile.Extension;
import org.modelversioning.emfprofile.IProfileFacade;
import org.modelversioning.emfprofile.Profile;
import org.modelversioning.emfprofile.Stereotype;
import org.modelversioning.emfprofile.impl.ProfileFacadeImpl;

public class RedefineProfileFacadeTest {
    private static final String CONCRETE_STEREOTYPE_FOR_ESTRUCTURALFEATURE_NAME = "ConcreteForEAttribute";
    private static final String REDEFINING_STEREOTYPE_FOR_EATTRIBUTE_NAME = "RedefiningStereotype";
    private static final String modelPath = "model/redefine/sample_ecore_model.ecore";
    private static final String profileWithRedefinePath = "model/redefine/profile_with_redefine_for_ecore_models.emfprofile_diagram";
    private static final String profileApplicationPath = "model/redefine/annotation.emfprofile.xmi";
    private final ResourceSet resourceSet = new ResourceSetImpl();
    private Profile profileWithRedefine;
    private Resource model;
    private Resource profileApplicationResource;

    @Before
    public void loadProfileWithSubset() {
        String absolutePath = this.getAbsolutePath(profileWithRedefinePath);
        Resource resource = this.loadResource(absolutePath);
        this.profileWithRedefine = this.extractProfile(resource);
    }

    @Before
    public void loadModel() {
        String absolutePath = this.getAbsolutePath(modelPath);
        this.model = this.loadResource(absolutePath);
    }

    private Profile extractProfile(Resource resource) {
        return (Profile)resource.getContents().get(0);
    }

    private String getAbsolutePath(String relativePath) {
        return new File(relativePath).getAbsolutePath();
    }

    private Resource loadResource(String path) {
        return this.resourceSet.getResource(URI.createFileURI((String)path), true);
    }

    @Test
    public void testInapplicabilityOfRedefiningStereotypeUsingRedefinedExtension() throws IOException {
        IProfileFacade profileFacade = this.createProfileFacade();
        Extension redefinedExtension = this.getRedefinedExtension();
        Stereotype redefiningStereotype = this.getRedefiningStereotype();
        Assert.assertFalse((boolean)profileFacade.isApplicable(redefiningStereotype, (EObject)this.getModelPersonFirstNameEAttribute(), redefinedExtension));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testFailingApplicationOfRedefiningStereotypeUsingRedefinedExtension() throws IOException {
        IProfileFacade profileFacade = this.createProfileFacade();
        Extension redefinedExtension = this.getRedefinedExtension();
        Stereotype redefiningStereotype = this.getRedefiningStereotype();
        profileFacade.apply(redefiningStereotype, (EObject)this.getModelPersonFirstNameEAttribute(), redefinedExtension);
    }

    @Test
    public void testInapplicabilityOfRedefinedExtensionForTargetOfRedefiningExtension() throws IOException {
        IProfileFacade profileFacade = this.createProfileFacade();
        Extension redefinedExtension = this.getRedefinedExtension();
        Assert.assertFalse((boolean)profileFacade.isApplicable(this.getRedefinedStereotype(), (EObject)this.getModelPersonFirstNameEAttribute(), redefinedExtension));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testFailingApplicationOfOfRedefinedExtensionForTargetOfRedefiningExtension() throws IOException {
        IProfileFacade profileFacade = this.createProfileFacade();
        Extension redefinedExtension = this.getRedefinedExtension();
        profileFacade.apply(this.getRedefinedStereotype(), (EObject)this.getModelPersonFirstNameEAttribute(), redefinedExtension);
    }

    private Stereotype getRedefiningStereotype() {
        return this.getStereotype(this.profileWithRedefine, REDEFINING_STEREOTYPE_FOR_EATTRIBUTE_NAME);
    }

    private Stereotype getRedefinedStereotype() {
        return this.getStereotype(this.profileWithRedefine, CONCRETE_STEREOTYPE_FOR_ESTRUCTURALFEATURE_NAME);
    }

    private Extension getRedefinedExtension() {
        return (Extension)this.getRedefinedStereotype().getExtensions().get(0);
    }

    private IProfileFacade createProfileFacade() throws IOException {
        return this.createProfileFacade(this.profileWithRedefine);
    }

    private IProfileFacade createProfileFacade(Profile profile) throws IOException {
        ProfileFacadeImpl profileFacade = new ProfileFacadeImpl();
        profileFacade.loadProfile(profile);
        this.profileApplicationResource = this.createProfileApplicationResource();
        profileFacade.setProfileApplicationResource(this.profileApplicationResource);
        return profileFacade;
    }

    private Stereotype getStereotype(Profile profile, String stereotypeName) {
        return profile.getStereotype(stereotypeName);
    }

    private Resource createProfileApplicationResource() throws IOException {
        String absolutePath = this.getAbsolutePath(profileApplicationPath);
        return this.createResource(absolutePath);
    }

    private Resource createResource(String path) throws IOException {
        this.deleteIfFileExists(path);
        Resource resource = this.resourceSet.createResource(URI.createFileURI((String)path));
        resource.save(Collections.emptyMap());
        return resource;
    }

    private EObject getModelEPackage() {
        return (EObject)this.model.getContents().get(0);
    }

    private EAttribute getModelPersonFirstNameEAttribute() {
        return (EAttribute)this.getModelPersonEClass().getEStructuralFeature("firstName");
    }

    private EClass getModelPersonEClass() {
        return (EClass)this.getModelEPackage().eContents().get(0);
    }

    @After
    public void deleteProfileApplicationResource() {
        String absolutePath = this.getAbsolutePath(profileApplicationPath);
        this.deleteIfFileExists(absolutePath);
    }

    private void deleteIfFileExists(String path) {
        File file = new File(path);
        if (file.exists()) {
            file.delete();
        }
    }
}

