/*
 * Decompiled with CFR 0.152.
 */
package org.modelversioning.emfprofileapplication.validation;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import junit.framework.Assert;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.modelversioning.emfprofile.Extension;
import org.modelversioning.emfprofile.IProfileFacade;
import org.modelversioning.emfprofile.Profile;
import org.modelversioning.emfprofile.Stereotype;
import org.modelversioning.emfprofile.impl.ProfileFacadeImpl;
import org.modelversioning.emfprofileapplication.ProfileApplication;
import org.modelversioning.emfprofileapplication.StereotypeApplication;
import org.modelversioning.emfprofileapplication.validation.InapplicableExtensionApplicationConstraintValidator;

public class InapplicableExtensionApplicationConstraintValidatorTest {
    private static final String CONCRETE_STEREOTYPE_FOR_EATTRIBUTE_NAME = "ConcreteForEAttribute";
    private static final String CONCRETE_STEREOTYPE_FOR_ECLASS_NAME = "AbstractForEClass";
    private static final String SUBSETTING_STEREOTYPE_FOR_EATTRIBUTE_NAME = "SubsettingStereotype";
    private static final String REDEFINING_STEREOTYPE_FOR_EATTRIBUTE_NAME = "RedefiningStereotype";
    private static final String modelPath = "model/validation/sample_ecore_model.ecore";
    private static final String profilePath = "model/validation/profile_for_ecore_models.emfprofile_diagram";
    private static final String profileWithSubsetPath = "model/validation/profile_with_subset_for_ecore_models.emfprofile_diagram";
    private static final String profileWithRedefinePath = "model/validation/profile_with_redefine_for_ecore_models.emfprofile_diagram";
    private static final String profileApplicationPath = "model/validation/annotation.emfprofile.xmi";
    private final ResourceSet resourceSet = new ResourceSetImpl();
    private Profile profile;
    private Profile profileWithSubset;
    private Profile profileWithRedefine;
    private Resource model;
    private Resource profileApplicationResource;

    @Before
    public void loadProfile() {
        String absolutePath = this.getAbsolutePath(profilePath);
        Resource resource = this.loadResource(absolutePath);
        this.profile = this.extractProfile(resource);
    }

    @Before
    public void loadProfileWithSubset() {
        String absolutePath = this.getAbsolutePath(profileWithSubsetPath);
        Resource resource = this.loadResource(absolutePath);
        this.profileWithSubset = this.extractProfile(resource);
    }

    @Before
    public void loadProfileWithRedefining() {
        String absolutePath = this.getAbsolutePath(profileWithRedefinePath);
        Resource resource = this.loadResource(absolutePath);
        this.profileWithRedefine = this.extractProfile(resource);
    }

    @Before
    public void loadModel() {
        String absolutePath = this.getAbsolutePath(modelPath);
        this.model = this.loadResource(absolutePath);
    }

    private Profile extractProfile(Resource resource) {
        return (Profile)resource.getContents().get(0);
    }

    private String getAbsolutePath(String relativePath) {
        return new File(relativePath).getAbsolutePath();
    }

    private Resource loadResource(String path) {
        return this.resourceSet.getResource(URI.createFileURI((String)path), true);
    }

    @Test
    public void testCorrectExtension() throws IOException {
        IProfileFacade profileFacade = this.createProfileFacade();
        Stereotype stereotype = this.getStereotype(this.profile, CONCRETE_STEREOTYPE_FOR_EATTRIBUTE_NAME);
        StereotypeApplication stereotypeApplication = profileFacade.apply(stereotype, (EObject)this.getModelPersonFirstNameEAttribute());
        InapplicableExtensionApplicationConstraintValidator validator = new InapplicableExtensionApplicationConstraintValidator(stereotypeApplication);
        Assert.assertFalse((boolean)validator.isViolated());
    }

    @Test
    public void testAppliedUncontainedExtensionCorrectTarget() throws IOException {
        IProfileFacade profileFacade = this.createProfileFacade();
        Stereotype stereotype = this.getStereotype(this.profile, CONCRETE_STEREOTYPE_FOR_EATTRIBUTE_NAME);
        profileFacade.apply(stereotype, (EObject)this.getModelPersonFirstNameEAttribute());
        Extension extensionForEclasses = (Extension)this.getStereotype(this.profile, CONCRETE_STEREOTYPE_FOR_ECLASS_NAME).getExtensions().get(0);
        StereotypeApplication stereotypeApplication = this.applyStereotypeBypassingFacade(stereotype, extensionForEclasses, (EObject)this.getModelPersonEClass());
        InapplicableExtensionApplicationConstraintValidator validator = new InapplicableExtensionApplicationConstraintValidator(stereotypeApplication);
        Assert.assertTrue((boolean)validator.isViolated());
    }

    @Test
    public void testAppliedUncontainedExtensionWrongTarget() throws IOException {
        IProfileFacade profileFacade = this.createProfileFacade();
        Stereotype stereotype = this.getStereotype(this.profile, CONCRETE_STEREOTYPE_FOR_EATTRIBUTE_NAME);
        profileFacade.apply(stereotype, (EObject)this.getModelPersonFirstNameEAttribute());
        Extension extensionForEclasses = (Extension)this.getStereotype(this.profile, CONCRETE_STEREOTYPE_FOR_ECLASS_NAME).getExtensions().get(0);
        StereotypeApplication stereotypeApplication = this.applyStereotypeBypassingFacade(stereotype, extensionForEclasses, (EObject)this.getModelPersonFirstNameEAttribute());
        InapplicableExtensionApplicationConstraintValidator validator = new InapplicableExtensionApplicationConstraintValidator(stereotypeApplication);
        Assert.assertTrue((boolean)validator.isViolated());
    }

    @Test
    public void testAppliedExtensionWrongTarget() throws IOException {
        IProfileFacade profileFacade = this.createProfileFacade();
        Stereotype stereotype = this.getStereotype(this.profile, CONCRETE_STEREOTYPE_FOR_EATTRIBUTE_NAME);
        profileFacade.apply(stereotype, (EObject)this.getModelPersonFirstNameEAttribute());
        StereotypeApplication stereotypeApplication = this.applyStereotypeBypassingFacade(stereotype, (Extension)stereotype.getExtensions().get(0), (EObject)this.getModelPersonEClass());
        InapplicableExtensionApplicationConstraintValidator validator = new InapplicableExtensionApplicationConstraintValidator(stereotypeApplication);
        Assert.assertTrue((boolean)validator.isViolated());
    }

    @Test
    public void testIllegalUseOfRedefinedExtensionWithTargetOfRedefiningExtension() throws IOException {
        IProfileFacade profileFacade = this.createProfileFacadeForProfileWithRedefining();
        Stereotype stereotype = this.getStereotype(this.profileWithRedefine, CONCRETE_STEREOTYPE_FOR_EATTRIBUTE_NAME);
        profileFacade.apply(stereotype, (EObject)this.getModelPersonOwnedCarsEReference());
        StereotypeApplication stereotypeApplication = this.applyStereotypeBypassingFacade(stereotype, (Extension)stereotype.getExtensions().get(0), (EObject)this.getModelPersonFirstNameEAttribute());
        InapplicableExtensionApplicationConstraintValidator validator = new InapplicableExtensionApplicationConstraintValidator(stereotypeApplication);
        Assert.assertTrue((boolean)validator.isViolated());
    }

    @Test
    public void testIllegalUseOfRedefinedExtensionWithStereotypeHavingRedefiningExtension() throws IOException {
        IProfileFacade profileFacade = this.createProfileFacade();
        Stereotype stereotype = this.getStereotype(this.profileWithRedefine, CONCRETE_STEREOTYPE_FOR_EATTRIBUTE_NAME);
        Stereotype redefiningStereotype = this.getStereotype(this.profileWithRedefine, REDEFINING_STEREOTYPE_FOR_EATTRIBUTE_NAME);
        profileFacade.apply(stereotype, (EObject)this.getModelPersonOwnedCarsEReference());
        StereotypeApplication stereotypeApplication = this.applyStereotypeBypassingFacade(redefiningStereotype, (Extension)stereotype.getExtensions().get(0), (EObject)this.getModelPersonFirstNameEAttribute());
        InapplicableExtensionApplicationConstraintValidator validator = new InapplicableExtensionApplicationConstraintValidator(stereotypeApplication);
        Assert.assertTrue((boolean)validator.isViolated());
    }

    @Test
    public void testIllegalUseOfSubsettedExtensionWithStereotypeHavingSubsettingExtension() throws IOException {
        IProfileFacade profileFacade = this.createProfileFacadeForProfileWithSubset();
        Stereotype stereotype = this.getStereotype(this.profileWithSubset, CONCRETE_STEREOTYPE_FOR_EATTRIBUTE_NAME);
        Stereotype subsettingStereotype = this.getStereotype(this.profileWithSubset, SUBSETTING_STEREOTYPE_FOR_EATTRIBUTE_NAME);
        profileFacade.apply(stereotype, (EObject)this.getModelPersonOwnedCarsEReference());
        StereotypeApplication stereotypeApplication = this.applyStereotypeBypassingFacade(subsettingStereotype, (Extension)stereotype.getExtensions().get(0), (EObject)this.getModelPersonFirstNameEAttribute());
        InapplicableExtensionApplicationConstraintValidator validator = new InapplicableExtensionApplicationConstraintValidator(stereotypeApplication);
        Assert.assertTrue((boolean)validator.isViolated());
    }

    protected StereotypeApplication applyStereotypeBypassingFacade(Stereotype stereotype, Extension extension, EObject eObject) {
        StereotypeApplication stereotypeApplication = (StereotypeApplication)stereotype.getEPackage().getEFactoryInstance().create((EClass)stereotype);
        stereotypeApplication.setExtension(extension);
        stereotypeApplication.setAppliedTo(eObject);
        this.getProfileApplication().getStereotypeApplications().add((Object)stereotypeApplication);
        return stereotypeApplication;
    }

    private ProfileApplication getProfileApplication() {
        return (ProfileApplication)this.profileApplicationResource.getContents().get(0);
    }

    private IProfileFacade createProfileFacadeForProfileWithSubset() throws IOException {
        return this.createProfileFacade(this.profileWithSubset);
    }

    private IProfileFacade createProfileFacadeForProfileWithRedefining() throws IOException {
        return this.createProfileFacade(this.profileWithSubset);
    }

    private IProfileFacade createProfileFacade() throws IOException {
        return this.createProfileFacade(this.profile);
    }

    private IProfileFacade createProfileFacade(Profile profile) throws IOException {
        ProfileFacadeImpl profileFacade = new ProfileFacadeImpl();
        profileFacade.loadProfile(profile);
        this.profileApplicationResource = this.createProfileApplicationResource();
        profileFacade.setProfileApplicationResource(this.profileApplicationResource);
        return profileFacade;
    }

    private Stereotype getStereotype(Profile profile, String stereotypeName) {
        return profile.getStereotype(stereotypeName);
    }

    private Resource createProfileApplicationResource() throws IOException {
        String absolutePath = this.getAbsolutePath(profileApplicationPath);
        return this.createResource(absolutePath);
    }

    private Resource createResource(String path) throws IOException {
        this.deleteIfFileExists(path);
        Resource resource = this.resourceSet.createResource(URI.createFileURI((String)path));
        resource.save(Collections.emptyMap());
        return resource;
    }

    private EObject getModelEPackage() {
        return (EObject)this.model.getContents().get(0);
    }

    private EAttribute getModelPersonFirstNameEAttribute() {
        return (EAttribute)this.getModelPersonEClass().getEStructuralFeature("firstName");
    }

    private EReference getModelPersonOwnedCarsEReference() {
        return (EReference)this.getModelPersonEClass().getEStructuralFeature("ownedCars");
    }

    private EClass getModelPersonEClass() {
        return (EClass)this.getModelEPackage().eContents().get(0);
    }

    @After
    public void deleteProfileApplicationResource() {
        String absolutePath = this.getAbsolutePath(profileApplicationPath);
        this.deleteIfFileExists(absolutePath);
    }

    private void deleteIfFileExists(String path) {
        File file = new File(path);
        if (file.exists()) {
            file.delete();
        }
    }
}

