/*
 * Decompiled with CFR 0.152.
 */
package org.modelversioning.emfprofileapplication.validation;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import junit.framework.Assert;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.modelversioning.emfprofile.Extension;
import org.modelversioning.emfprofile.IProfileFacade;
import org.modelversioning.emfprofile.Profile;
import org.modelversioning.emfprofile.Stereotype;
import org.modelversioning.emfprofile.impl.ProfileFacadeImpl;
import org.modelversioning.emfprofileapplication.ProfileApplication;
import org.modelversioning.emfprofileapplication.StereotypeApplication;
import org.modelversioning.emfprofileapplication.validation.UpperBoundConstraintValidator;

public class UpperBoundConstraintValidatorTest {
    private static final String CONCRETE_STEREOTYPE_FOR_EATTRIBUTE_NAME = "ConcreteForEAttribute";
    private static final String SUB_STEREOTYPE_FOR_EATTRIBUTE_NAME = "SubForEAttribute";
    private static final String SUBSETTING_STEREOTYPE_FOR_EATTRIBUTE_NAME = "SubsettingStereotype";
    private static final String modelPath = "model/validation/sample_ecore_model.ecore";
    private static final String profilePath = "model/validation/profile_with_subset_for_ecore_models.emfprofile_diagram";
    private static final String profileApplicationPath = "model/validation/annotation.emfprofile.xmi";
    private final ResourceSet resourceSet = new ResourceSetImpl();
    private Profile profile;
    private Resource model;
    private Resource profileApplicationResource;

    @Before
    public void loadProfile() {
        String absolutePath = this.getAbsolutePath(profilePath);
        Resource resource = this.loadResource(absolutePath);
        this.profile = this.extractProfile(resource);
    }

    @Before
    public void loadModel() {
        String absolutePath = this.getAbsolutePath(modelPath);
        this.model = this.loadResource(absolutePath);
    }

    private Profile extractProfile(Resource resource) {
        return (Profile)resource.getContents().get(0);
    }

    private String getAbsolutePath(String relativePath) {
        return new File(relativePath).getAbsolutePath();
    }

    private Resource loadResource(String path) {
        return this.resourceSet.getResource(URI.createFileURI((String)path), true);
    }

    @Test
    public void testUpperBoundViolationWithSameStereotype() throws IOException {
        IProfileFacade profileFacade = this.createProfileFacade();
        Stereotype stereotype = this.getStereotype(CONCRETE_STEREOTYPE_FOR_EATTRIBUTE_NAME);
        profileFacade.apply(stereotype, (EObject)this.getModelPersonFirstNameEAttribute());
        profileFacade.apply(stereotype, (EObject)this.getModelPersonFirstNameEAttribute());
        ProfileApplication profileApplication = this.getProfileApplication();
        UpperBoundConstraintValidator validator = new UpperBoundConstraintValidator(profileApplication);
        Assert.assertEquals((int)0, (int)validator.getViolations().size());
        this.applyStereotypeBypassingFacade(stereotype, (EObject)this.getModelPersonFirstNameEAttribute());
        validator = new UpperBoundConstraintValidator(profileApplication);
        Assert.assertEquals((int)1, (int)validator.getViolations().size());
    }

    @Test
    public void testUpperBoundViolationWithMixedStereotype() throws IOException {
        IProfileFacade profileFacade = this.createProfileFacade();
        Stereotype stereotype = this.getStereotype(CONCRETE_STEREOTYPE_FOR_EATTRIBUTE_NAME);
        Stereotype stereotype2 = this.getStereotype(SUB_STEREOTYPE_FOR_EATTRIBUTE_NAME);
        profileFacade.apply(stereotype, (EObject)this.getModelPersonFirstNameEAttribute());
        profileFacade.apply(stereotype2, (EObject)this.getModelPersonFirstNameEAttribute());
        ProfileApplication profileApplication = this.getProfileApplication();
        UpperBoundConstraintValidator validator = new UpperBoundConstraintValidator(profileApplication);
        Assert.assertEquals((int)0, (int)validator.getViolations().size());
        this.applyStereotypeBypassingFacade(stereotype, (EObject)this.getModelPersonFirstNameEAttribute());
        validator = new UpperBoundConstraintValidator(profileApplication);
        Assert.assertEquals((int)1, (int)validator.getViolations().size());
    }

    @Test
    public void testUpperBoundViolationWithSubsettingStereotype() throws IOException {
        IProfileFacade profileFacade = this.createProfileFacade();
        Stereotype stereotype = this.getStereotype(CONCRETE_STEREOTYPE_FOR_EATTRIBUTE_NAME);
        Stereotype subsettingStereotype = this.getStereotype(SUBSETTING_STEREOTYPE_FOR_EATTRIBUTE_NAME);
        profileFacade.apply(stereotype, (EObject)this.getModelPersonFirstNameEAttribute());
        profileFacade.apply(stereotype, (EObject)this.getModelPersonFirstNameEAttribute());
        ProfileApplication profileApplication = this.getProfileApplication();
        UpperBoundConstraintValidator validator = new UpperBoundConstraintValidator(profileApplication);
        Assert.assertEquals((int)0, (int)validator.getViolations().size());
        this.applyStereotypeBypassingFacade(subsettingStereotype, (EObject)this.getModelPersonFirstNameEAttribute());
        validator = new UpperBoundConstraintValidator(profileApplication);
        Assert.assertEquals((int)1, (int)validator.getViolations().size());
    }

    protected void applyStereotypeBypassingFacade(Stereotype stereotype, EObject eObject) {
        StereotypeApplication stereotypeApplication = (StereotypeApplication)stereotype.getEPackage().getEFactoryInstance().create((EClass)stereotype);
        stereotypeApplication.setExtension((Extension)stereotype.getAllExtensions().get(0));
        stereotypeApplication.setAppliedTo(eObject);
        this.getProfileApplication().getStereotypeApplications().add((Object)stereotypeApplication);
    }

    private ProfileApplication getProfileApplication() {
        return (ProfileApplication)this.profileApplicationResource.getContents().get(0);
    }

    private IProfileFacade createProfileFacade() throws IOException {
        ProfileFacadeImpl profileFacade = new ProfileFacadeImpl();
        profileFacade.loadProfile(this.profile);
        this.profileApplicationResource = this.createProfileApplicationResource();
        profileFacade.setProfileApplicationResource(this.profileApplicationResource);
        return profileFacade;
    }

    private Stereotype getStereotype(String stereotypeName) {
        return this.profile.getStereotype(stereotypeName);
    }

    private Resource createProfileApplicationResource() throws IOException {
        String absolutePath = this.getAbsolutePath(profileApplicationPath);
        return this.createResource(absolutePath);
    }

    private Resource createResource(String path) throws IOException {
        this.deleteIfFileExists(path);
        Resource resource = this.resourceSet.createResource(URI.createFileURI((String)path));
        resource.save(Collections.emptyMap());
        return resource;
    }

    private EObject getModelEPackage() {
        return (EObject)this.model.getContents().get(0);
    }

    private EAttribute getModelPersonFirstNameEAttribute() {
        return (EAttribute)this.getModelPersonEClass().getEStructuralFeature("firstName");
    }

    private EClass getModelPersonEClass() {
        return (EClass)this.getModelEPackage().eContents().get(0);
    }

    @After
    public void deleteProfileApplicationResource() {
        String absolutePath = this.getAbsolutePath(profileApplicationPath);
        this.deleteIfFileExists(absolutePath);
    }

    private void deleteIfFileExists(String path) {
        File file = new File(path);
        if (file.exists()) {
            file.delete();
        }
    }
}

