/*
 * Decompiled with CFR 0.152.
 */
package org.modelversioning.emfprofile.util;

import java.util.Map;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.emf.ecore.util.EcoreValidator;
import org.modelversioning.emfprofile.EMFProfilePackage;
import org.modelversioning.emfprofile.Extension;
import org.modelversioning.emfprofile.Profile;
import org.modelversioning.emfprofile.Stereotype;

public class EMFProfileValidator
extends EObjectValidator {
    public static final EMFProfileValidator INSTANCE = new EMFProfileValidator();
    public static final String DIAGNOSTIC_SOURCE = "org.modelversioning.emfprofile";
    private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 0;
    protected static final int DIAGNOSTIC_CODE_COUNT = 0;
    protected EcoreValidator ecoreValidator = EcoreValidator.INSTANCE;
    protected static final String STEREOTYPE__UNIQUE_EXTENSIONS__EEXPRESSION = "self.extensions->size() > 1 implies self.extensions->forAll(ex1 : Extension, ex2 : Extension | ex1 <> ex2 implies ex1.target <> ex2.target)";
    protected static final String EXTENSION__REDEFINED_IN_SUPER_STEREOTYPE__EEXPRESSION = "self.source.eAllSuperTypes->select(s | s.oclIsKindOf(Stereotype))->collect(s  | s.oclAsType(Stereotype).extensions)->includesAll(self.redefined)";
    protected static final String EXTENSION__SUBSETTED_IN_SUPER_STEREOTYPE__EEXPRESSION = "self.source.eAllSuperTypes->select(s | s.oclIsKindOf(Stereotype))->collect(s  | s.oclAsType(Stereotype).extensions)->includesAll(self.subsetted)";
    protected static final String EXTENSION__SUBSETTED_MUST_HAVE_HIGHER_OR_EQUAL_UPPER_BOUND__EEXPRESSION = "self.subsetted->size() > 0 implies self.subsetted->forAll(subsetted : Extension | subsetted.upperBound >= self.upperBound or subsetted.upperBound = -1)";
    protected static final String EXTENSION__REDEFINING_TARGET_MUST_BE_SUBCLASS_OF_REDEFINED_TARGET__EEXPRESSION = "self.redefined->notEmpty() implies self.redefined->forAll(redef : Extension | target.eAllSuperTypes->includes(redef.target))";
    protected static final String EXTENSION__SUBSETTING_TARGET_MUST_BE_SUBCLASS_OF_SUBSETTED_TARGET__EEXPRESSION = "self.subsetted->notEmpty() implies self.subsetted->forAll(subsetted : Extension | target.eAllSuperTypes->includes(subsetted.target))";

    protected EPackage getEPackage() {
        return EMFProfilePackage.eINSTANCE;
    }

    protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        switch (classifierID) {
            case 0: {
                return this.validateProfile((Profile)value, diagnostics, context);
            }
            case 1: {
                return this.validateStereotype((Stereotype)value, diagnostics, context);
            }
            case 2: {
                return this.validateExtension((Extension)value, diagnostics, context);
            }
        }
        return true;
    }

    public boolean validateProfile(Profile profile, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment((EObject)profile, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms((EObject)profile, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms((EObject)profile, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained((EObject)profile, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired((EObject)profile, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves((EObject)profile, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID((EObject)profile, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique((EObject)profile, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique((EObject)profile, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.ecoreValidator.validateENamedElement_WellFormedName((ENamedElement)profile, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.ecoreValidator.validateEPackage_WellFormedNsURI((EPackage)profile, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.ecoreValidator.validateEPackage_WellFormedNsPrefix((EPackage)profile, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.ecoreValidator.validateEPackage_UniqueSubpackageNames((EPackage)profile, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.ecoreValidator.validateEPackage_UniqueClassifierNames((EPackage)profile, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.ecoreValidator.validateEPackage_UniqueNsURIs((EPackage)profile, diagnostics, context);
        }
        return result;
    }

    public boolean validateStereotype(Stereotype stereotype, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment((EObject)stereotype, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms((EObject)stereotype, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms((EObject)stereotype, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained((EObject)stereotype, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired((EObject)stereotype, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves((EObject)stereotype, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID((EObject)stereotype, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique((EObject)stereotype, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique((EObject)stereotype, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.ecoreValidator.validateENamedElement_WellFormedName((ENamedElement)stereotype, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.ecoreValidator.validateEClassifier_WellFormedInstanceTypeName((EClassifier)stereotype, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.ecoreValidator.validateEClassifier_UniqueTypeParameterNames((EClassifier)stereotype, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.ecoreValidator.validateEClass_InterfaceIsAbstract((EClass)stereotype, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.ecoreValidator.validateEClass_AtMostOneID((EClass)stereotype, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.ecoreValidator.validateEClass_UniqueFeatureNames((EClass)stereotype, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.ecoreValidator.validateEClass_UniqueOperationSignatures((EClass)stereotype, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.ecoreValidator.validateEClass_NoCircularSuperTypes((EClass)stereotype, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.ecoreValidator.validateEClass_WellFormedMapEntryClass((EClass)stereotype, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.ecoreValidator.validateEClass_ConsistentSuperTypes((EClass)stereotype, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.ecoreValidator.validateEClass_DisjointFeatureAndOperationSignatures((EClass)stereotype, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateStereotype_uniqueExtensions(stereotype, diagnostics, context);
        }
        return result;
    }

    public boolean validateStereotype_uniqueExtensions(Stereotype stereotype, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(EMFProfilePackage.Literals.STEREOTYPE, (EObject)stereotype, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "uniqueExtensions", STEREOTYPE__UNIQUE_EXTENSIONS__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateExtension(Extension extension, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(extension, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(extension, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(extension, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(extension, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(extension, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(extension, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(extension, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(extension, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(extension, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateExtension_redefinedInSuperStereotype(extension, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateExtension_subsettedInSuperStereotype(extension, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateExtension_subsettedMustHaveHigherOrEqualUpperBound(extension, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateExtension_redefiningTargetMustBeSubclassOfRedefinedTarget(extension, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateExtension_subsettingTargetMustBeSubclassOfSubsettedTarget(extension, diagnostics, context);
        }
        return result;
    }

    public boolean validateExtension_redefinedInSuperStereotype(Extension extension, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(EMFProfilePackage.Literals.EXTENSION, extension, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "redefinedInSuperStereotype", EXTENSION__REDEFINED_IN_SUPER_STEREOTYPE__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateExtension_subsettedInSuperStereotype(Extension extension, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(EMFProfilePackage.Literals.EXTENSION, extension, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "subsettedInSuperStereotype", EXTENSION__SUBSETTED_IN_SUPER_STEREOTYPE__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateExtension_subsettedMustHaveHigherOrEqualUpperBound(Extension extension, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(EMFProfilePackage.Literals.EXTENSION, extension, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "subsettedMustHaveHigherOrEqualUpperBound", EXTENSION__SUBSETTED_MUST_HAVE_HIGHER_OR_EQUAL_UPPER_BOUND__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateExtension_redefiningTargetMustBeSubclassOfRedefinedTarget(Extension extension, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(EMFProfilePackage.Literals.EXTENSION, extension, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "redefiningTargetMustBeSubclassOfRedefinedTarget", EXTENSION__REDEFINING_TARGET_MUST_BE_SUBCLASS_OF_REDEFINED_TARGET__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateExtension_subsettingTargetMustBeSubclassOfSubsettedTarget(Extension extension, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(EMFProfilePackage.Literals.EXTENSION, extension, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "subsettingTargetMustBeSubclassOfSubsettedTarget", EXTENSION__SUBSETTING_TARGET_MUST_BE_SUBCLASS_OF_SUBSETTED_TARGET__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public ResourceLocator getResourceLocator() {
        return super.getResourceLocator();
    }
}

