/*
 * Decompiled with CFR 0.152.
 */
package org.modelversioning.emfprofile.application.registry.ui.dialogs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.modelversioning.emfprofile.application.registry.ProfileApplicationDecorator;
import org.modelversioning.emfprofile.application.registry.ui.observer.ActiveEditorObserver;
import org.modelversioning.emfprofile.application.registry.ui.providers.ProfileProviderLabelAdapter;
import org.modelversioning.emfprofile.application.registry.ui.views.EMFProfileApplicationsView;
import org.modelversioning.emfprofileapplication.StereotypeApplicability;

public class ApplyStereotypeOnEObjectDialog {
    private ProfileProviderLabelAdapter labelAdapter = new ProfileProviderLabelAdapter(EMFProfileApplicationsView.getAdapterFactory());
    private final Map<ProfileApplicationDecorator, Collection<StereotypeApplicability>> profileToStereotypeApplicabilityForEObjectMap;

    public ApplyStereotypeOnEObjectDialog(Map<ProfileApplicationDecorator, Collection<StereotypeApplicability>> profileToStereotypeApplicabilityForEObjectMap) {
        this.profileToStereotypeApplicabilityForEObjectMap = profileToStereotypeApplicabilityForEObjectMap;
    }

    public void openApplyStereotypeDialog(EObject eObject) {
        ArrayList<TreeParent> parents = new ArrayList<TreeParent>();
        for (ProfileApplicationDecorator profileApplication : this.profileToStereotypeApplicabilityForEObjectMap.keySet()) {
            TreeParent parent = new TreeParent(profileApplication);
            for (StereotypeApplicability stereotypeApplicability : this.profileToStereotypeApplicabilityForEObjectMap.get(profileApplication)) {
                parent.addChild(new TreeObject(stereotypeApplicability));
            }
            parents.add(parent);
        }
        StereotypeTreeSelectionDialog dialog = new StereotypeTreeSelectionDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (ILabelProvider)new ViewLabelProvider(), new ViewContentProvider());
        dialog.setTitle("Stereotype Selection");
        dialog.setMessage("Select one or more Stereotypes to apply");
        dialog.setInput(parents);
        dialog.setDoubleClickSelects(true);
        dialog.setValidator(new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                if (selection.length == 0) {
                    return new Status(4, "org.modelversioning.emfprofile.application.registry.ui", "No Stereotype selected yet.");
                }
                Object[] objectArray = selection;
                int n = selection.length;
                int n2 = 0;
                while (n2 < n) {
                    Object object = objectArray[n2];
                    if (!(object instanceof TreeParent)) {
                        return new Status(0, "org.modelversioning.emfprofile.application.registry.ui", "");
                    }
                    ++n2;
                }
                return new Status(4, "org.modelversioning.emfprofile.application.registry.ui", "No Stereotype selected yet.");
            }
        });
        int result = dialog.open();
        if (result == 0) {
            Object[] treeObjects = dialog.getResult();
            StringBuilder strBuilder = new StringBuilder();
            boolean hasNotApplicableStereotypes = false;
            ArrayList<ProfileApplicationDecorator> profileApplicationDecoratorToBeRefreshedInView = new ArrayList<ProfileApplicationDecorator>();
            Object[] objectArray = treeObjects;
            int n = treeObjects.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                if (!(object instanceof TreeParent)) {
                    TreeObject child = (TreeObject)object;
                    StereotypeApplicability stereotypeApplicability = (StereotypeApplicability)child.getElement();
                    ProfileApplicationDecorator profileApplicationDecorator = (ProfileApplicationDecorator)child.getParent().getElement();
                    try {
                        profileApplicationDecorator.applyStereotype(stereotypeApplicability, eObject);
                        profileApplicationDecoratorToBeRefreshedInView.add(profileApplicationDecorator);
                    }
                    catch (IllegalArgumentException e) {
                        hasNotApplicableStereotypes = true;
                        strBuilder.append(String.valueOf(stereotypeApplicability.getStereotype().getName()) + ", from profile: " + profileApplicationDecorator.getProfileName() + "\n");
                    }
                }
                ++n2;
            }
            if (!profileApplicationDecoratorToBeRefreshedInView.isEmpty()) {
                ActiveEditorObserver.INSTANCE.refreshViewer(profileApplicationDecoratorToBeRefreshedInView);
                ActiveEditorObserver.INSTANCE.refreshDecoration(eObject);
            }
            if (hasNotApplicableStereotypes) {
                strBuilder.insert(0, "Not applicable stereotype(s) to object: " + (eObject == null ? "" : String.valueOf(eObject.toString()) + "\n"));
                MessageBox messageBox = new MessageBox(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 33);
                messageBox.setText("Could not be applied!");
                messageBox.setMessage(strBuilder.toString());
                messageBox.open();
            }
        }
    }

    final class StereotypeTreeSelectionDialog
    extends ElementTreeSelectionDialog {
        public StereotypeTreeSelectionDialog(Shell parent, ILabelProvider labelProvider, ITreeContentProvider contentProvider) {
            super(parent, labelProvider, contentProvider);
        }

        protected Control createDialogArea(Composite parent) {
            Control control = super.createDialogArea(parent);
            this.getTreeViewer().setAutoExpandLevel(2);
            this.getTreeViewer().setInput(this.getTreeViewer().getInput());
            return control;
        }
    }

    class TreeObject
    implements IAdaptable {
        private TreeParent parent;
        private Object element;

        public final Object getElement() {
            return this.element;
        }

        public TreeObject(Object element) {
            this.element = element;
        }

        public void setParent(TreeParent parent) {
            this.parent = parent;
        }

        public TreeParent getParent() {
            return this.parent;
        }

        public Object getAdapter(Class key) {
            return null;
        }
    }

    class TreeParent
    extends TreeObject {
        private ArrayList children;

        public TreeParent(String name) {
            super(name);
            this.children = new ArrayList();
        }

        public TreeParent(Object element) {
            super(element);
            this.children = new ArrayList();
        }

        public void addChild(TreeObject child) {
            this.children.add(child);
            child.setParent(this);
        }

        public void removeChild(TreeObject child) {
            this.children.remove(child);
            child.setParent(null);
        }

        public TreeObject[] getChildren() {
            return this.children.toArray(new TreeObject[this.children.size()]);
        }

        public boolean hasChildren() {
            return this.children.size() > 0;
        }
    }

    class ViewContentProvider
    implements IStructuredContentProvider,
    ITreeContentProvider {
        private TreeParent invisibleRoot;

        ViewContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object parent) {
            if (parent instanceof Collection) {
                return ((Collection)parent).toArray();
            }
            return this.getChildren(parent);
        }

        public Object getParent(Object child) {
            if (child instanceof TreeObject) {
                return ((TreeObject)child).getParent();
            }
            return null;
        }

        public Object[] getChildren(Object parent) {
            if (parent instanceof TreeParent) {
                return ((TreeParent)parent).getChildren();
            }
            return new Object[0];
        }

        public boolean hasChildren(Object parent) {
            if (parent instanceof TreeParent) {
                return ((TreeParent)parent).hasChildren();
            }
            return false;
        }
    }

    final class ViewLabelProvider
    extends LabelProvider {
        ViewLabelProvider() {
        }

        public String getText(Object obj) {
            if (((TreeObject)obj).getElement() instanceof ProfileApplicationDecorator) {
                return ((ProfileApplicationDecorator)((TreeObject)obj).getElement()).getName();
            }
            return ApplyStereotypeOnEObjectDialog.this.labelAdapter.getText(((TreeObject)obj).getElement());
        }

        public Image getImage(Object obj) {
            return ApplyStereotypeOnEObjectDialog.this.labelAdapter.getImage(((TreeObject)obj).getElement());
        }
    }
}

