/*
 * Decompiled with CFR 0.152.
 */
package org.modelversioning.emfprofile.application.registry.ui.wizards;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.preference.FileFieldEditor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class SelectProfileApplicationFilePage
extends WizardPage {
    private static final String PROFILE_FILE = "PROFILE_FILE";
    private FileFieldEditor fileFieldEditor;
    private ISelection selection = null;

    protected SelectProfileApplicationFilePage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
        this.setMessage("Select the EMF Profile Application file.");
        this.updatePageCompleteState();
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        this.fileFieldEditor = new FileFieldEditor(PROFILE_FILE, "EMF Profile Application File", container);
        if (this.selection != null && !this.selection.isEmpty() && this.selection instanceof IStructuredSelection && ((IStructuredSelection)this.selection).getFirstElement() instanceof IFile) {
            Object object = ((IStructuredSelection)this.selection).getFirstElement();
            File file = new File(((IFile)object).getParent().getLocationURI());
            this.fileFieldEditor.setFilterPath(file);
        } else {
            this.fileFieldEditor.setFilterPath(new File(ResourcesPlugin.getWorkspace().getRoot().getLocationURI()));
        }
        this.fileFieldEditor.setFileExtensions(new String[]{"*.pa.xmi"});
        this.fileFieldEditor.getTextControl(container).addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SelectProfileApplicationFilePage.this.updatePageCompleteState();
            }
        });
        this.fileFieldEditor.setEmptyStringAllowed(false);
    }

    public IFile getSelectedFile() {
        IFile file = null;
        if (this.fileFieldEditor != null) {
            file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(this.fileFieldEditor.getStringValue()));
        }
        return file;
    }

    private void updatePageCompleteState() {
        IFile file = this.getSelectedFile();
        if (file == null) {
            this.setErrorMessage("Select profile application file.");
            this.setPageComplete(false);
        } else if (!file.exists()) {
            this.setErrorMessage("Selected file does not exist");
            this.setPageComplete(false);
        } else {
            this.setErrorMessage(null);
            this.setPageComplete(true);
        }
    }

    public void setSelection(ISelection selection) {
        this.selection = selection;
    }
}

