/*
 * Decompiled with CFR 0.152.
 */
package org.modelversioning.emfprofile.application.decorator.gmf;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecorator;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.modelversioning.emfprofile.application.decorator.gmf.decoration.EMFProfileDecorator;
import org.modelversioning.emfprofile.application.registry.ui.extensionpoint.decorator.EMFProfileApplicationDecorator;
import org.modelversioning.emfprofile.application.registry.ui.extensionpoint.decorator.PluginExtensionOperationsListener;

public class EMFProfileApplicationDecoratorImpl
implements EMFProfileApplicationDecorator,
ISelectionListener {
    private final List<String> decorateableEditors = new ArrayList<String>();
    private static PluginExtensionOperationsListener pluginExtensionOperationListener;
    private IEditorPart activeEditor = null;
    private static Map<EObject, IDecorator> eObjectToDecoratorMap;

    static {
        eObjectToDecoratorMap = new HashMap<EObject, IDecorator>();
    }

    public static PluginExtensionOperationsListener getPluginExtensionOperationsListener() {
        return pluginExtensionOperationListener;
    }

    public IWorkbenchPage getActivePage() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            throw new RuntimeException("could not locate workbench active window!");
        }
        IWorkbenchPage activePage = window.getActivePage();
        if (activePage == null) {
            throw new RuntimeException("could not locate active page for active window ");
        }
        return activePage;
    }

    public EMFProfileApplicationDecoratorImpl() {
        this.obtainRegisteredGMFEditors();
        this.getActiveEditorAndCheckWhetherToDecorate();
    }

    private void obtainRegisteredGMFEditors() {
        IConfigurationElement[] config;
        IConfigurationElement[] iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.ui.editors");
        int n = config.length;
        int n2 = 0;
        while (n2 < n) {
            String editorID;
            IConfigurationElement e = iConfigurationElementArray[n2];
            if (this.declaresGMFBasedEditor(e) && (editorID = e.getAttribute("id")) != null) {
                this.decorateableEditors.add(editorID);
            }
            ++n2;
        }
    }

    private boolean declaresGMFBasedEditor(IConfigurationElement e) {
        String simpleIdentifier = e.getDeclaringExtension().getSimpleIdentifier();
        return "gmf-editor".equals(simpleIdentifier);
    }

    private void getActiveEditorAndCheckWhetherToDecorate() {
        String editorId;
        IWorkbenchPage activePage = this.getActivePage();
        IEditorPart editorPart = activePage.getActiveEditor();
        if (editorPart != null && this.isDecorateable(editorId = this.getEditorId(editorPart))) {
            this.activeEditor = editorPart;
            this.activeEditor.getSite().getPage().addSelectionListener(editorId, (ISelectionListener)this);
        }
        activePage.addPartListener(new IPartListener(){

            public void partOpened(IWorkbenchPart part) {
            }

            public void partDeactivated(IWorkbenchPart part) {
            }

            public void partClosed(IWorkbenchPart part) {
                if (part instanceof IEditorPart && part.equals(EMFProfileApplicationDecoratorImpl.this.activeEditor)) {
                    EMFProfileApplicationDecoratorImpl.this.activeEditor.getSite().getPage().removeSelectionListener((ISelectionListener)EMFProfileApplicationDecoratorImpl.this);
                }
            }

            public void partBroughtToTop(IWorkbenchPart part) {
            }

            public void partActivated(IWorkbenchPart part) {
                IEditorPart editorPart;
                if (part instanceof IEditorPart && EMFProfileApplicationDecoratorImpl.this.isDecorateable(EMFProfileApplicationDecoratorImpl.this.getEditorId(editorPart = (IEditorPart)part))) {
                    if (EMFProfileApplicationDecoratorImpl.this.activeEditor != null) {
                        EMFProfileApplicationDecoratorImpl.this.activeEditor.getSite().getPage().removeSelectionListener((ISelectionListener)EMFProfileApplicationDecoratorImpl.this);
                    }
                    EMFProfileApplicationDecoratorImpl.this.activeEditor = (IEditorPart)part;
                    EMFProfileApplicationDecoratorImpl.this.activeEditor.getSite().getPage().addSelectionListener((ISelectionListener)EMFProfileApplicationDecoratorImpl.this);
                }
            }
        });
    }

    private String getEditorId(IEditorPart editorPart) {
        return editorPart.getSite().getId();
    }

    private boolean isDecorateable(String editorId) {
        return this.decorateableEditors.contains(editorId);
    }

    public String[] canDecorateEditorParts() {
        return this.decorateableEditors.toArray(new String[this.decorateableEditors.size()]);
    }

    public void setPluginExtensionOperationsListener(PluginExtensionOperationsListener listener) {
        pluginExtensionOperationListener = listener;
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (pluginExtensionOperationListener != null && part instanceof IEditorPart && part.equals(this.activeEditor) && selection != null && selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            EditPart editPart = (EditPart)structuredSelection.getFirstElement();
            Object model = editPart.getModel();
            if (model instanceof Node) {
                Node node = (Node)model;
                EObject selectedEObject = node.getElement();
                EMFProfileApplicationDecoratorImpl.getPluginExtensionOperationsListener().eObjectSelected(selectedEObject);
            } else {
                EMFProfileApplicationDecoratorImpl.getPluginExtensionOperationsListener().eObjectSelected(null);
            }
        }
    }

    public static void registerDecoratorForEObject(EObject eObject, IDecorator decorator) {
        eObjectToDecoratorMap.put(eObject, decorator);
    }

    public static void unregisterDecoratorForEObject(EObject eObject) {
        eObjectToDecoratorMap.remove(eObject);
    }

    public void decorate(EObject eObject, List<Image> images, List<String> toolTipTexts) {
        if (eObject == null || images == null || toolTipTexts == null) {
            throw new IllegalArgumentException("Parametrs can not have null value.");
        }
        if (eObjectToDecoratorMap.containsKey(eObject)) {
            EMFProfileDecorator decorator = (EMFProfileDecorator)eObjectToDecoratorMap.get(eObject);
            decorator.refresh(images, toolTipTexts);
        }
    }
}

