/*
 * Decompiled with CFR 0.152.
 */
package org.modelversioning.emfprofile.application.registry.ui.wizards;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.wizards.newresource.BasicNewFileResourceWizard;
import org.modelversioning.emfprofile.application.registry.ProfileApplicationRegistry;
import org.modelversioning.emfprofile.application.registry.ui.ProfileApplicationConstantsAndUtil;
import org.modelversioning.emfprofile.application.registry.ui.observer.ActiveEditorObserver;
import org.modelversioning.emfprofile.application.registry.ui.wizards.SelectProfileFilePage;

public class ApplyProfileWizard
extends BasicNewFileResourceWizard {
    private static final String PROFILE_APPLICATION_PAGE_NAME = "newFilePage1";
    private static final String SELECT_PROFILE_PAGE_NAME = "selectProfilePage";
    private static final String WINDOW_TITLE = "Apply Profile";
    private SelectProfileFilePage profileFilePage = null;
    private IWorkbenchPart targetPart = null;
    private WizardNewFileCreationPage profileAppFilePage = null;

    public ApplyProfileWizard() {
        this.setHelpAvailable(false);
        this.setWindowTitle(WINDOW_TITLE);
    }

    public boolean performFinish() {
        IPath appContainerFullPath = this.profileAppFilePage.getContainerFullPath();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IFile profileApplicationFile = root.getFile(appContainerFullPath.append(this.profileAppFilePage.getFileName()));
        try {
            String modelId = ActiveEditorObserver.INSTANCE.getModelIdForWorkbenchPart(this.targetPart);
            if (modelId == null) {
                throw new RuntimeException("Could not find modelId for a part: " + this.targetPart);
            }
            ProfileApplicationRegistry.INSTANCE.applyProfileToModel(modelId, profileApplicationFile, this.profileFilePage.getSelectedProfiles(), ProfileApplicationConstantsAndUtil.getResourceSet(this.targetPart));
            ActiveEditorObserver.INSTANCE.refreshViewer();
        }
        catch (Exception e) {
            Status status = new Status(4, "org.modelversioning.emfprofile.application.registry.ui", e.getMessage(), (Throwable)e);
            ErrorDialog.openError((Shell)this.targetPart.getSite().getShell(), (String)"Error While Applying Profile", (String)e.getMessage(), (IStatus)status);
        }
        return true;
    }

    public void addPages() {
        super.addPages();
        this.profileAppFilePage = (WizardNewFileCreationPage)super.getPage(PROFILE_APPLICATION_PAGE_NAME);
        this.profileAppFilePage.setDescription("Profile Application File");
        this.profileAppFilePage.setTitle("Select location and file name for the profile application file.");
        this.profileAppFilePage.setFileExtension("pa.xmi");
        this.profileAppFilePage.setFileName("application");
        this.profileFilePage = new SelectProfileFilePage(SELECT_PROFILE_PAGE_NAME, "Select Profile File", null);
        super.addPage((IWizardPage)this.profileFilePage);
    }

    public void setWorkbenchPart(IWorkbenchPart targetPart) {
        this.targetPart = targetPart;
    }
}

