/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.functionfit;

import cern.colt.matrix.DoubleFactory2D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.linalg.Algebra;
import umontreal.ssj.functions.MathFunction;
import umontreal.ssj.functions.MathFunctionUtil;
import umontreal.ssj.functions.MathFunctionWithDerivative;
import umontreal.ssj.functions.MathFunctionWithFirstDerivative;
import umontreal.ssj.functions.MathFunctionWithIntegral;
import umontreal.ssj.util.Misc;
import umontreal.ssj.util.RootFinder;

public class BSpline
implements MathFunction,
MathFunctionWithIntegral,
MathFunctionWithDerivative,
MathFunctionWithFirstDerivative {
    private double[] x;
    private double[] y;
    private int degree;
    private double[] myX;
    private double[] myY;
    private double[] knots;

    public BSpline(double[] x, double[] y, int degree) {
        if (x.length != y.length) {
            throw new IllegalArgumentException("The arrays x and y must share the same length");
        }
        this.degree = degree;
        this.x = (double[])x.clone();
        this.y = (double[])y.clone();
        this.init(x, y, null);
    }

    public BSpline(double[] x, double[] y, double[] knots) {
        if (x.length != y.length) {
            throw new IllegalArgumentException("The arrays x and y must share the same length");
        }
        if (knots.length <= x.length + 1) {
            throw new IllegalArgumentException("The number of knots must be at least n+2");
        }
        this.x = (double[])x.clone();
        this.y = (double[])y.clone();
        this.knots = (double[])knots.clone();
        this.init(x, y, knots);
    }

    public double[] getX() {
        return (double[])this.myX.clone();
    }

    public double[] getY() {
        return (double[])this.myY.clone();
    }

    public double getMaxKnot() {
        return this.knots[this.knots.length - 1];
    }

    public double getMinKnot() {
        return this.knots[0];
    }

    public double[] getKnots() {
        return (double[])this.knots.clone();
    }

    public static BSpline createInterpBSpline(double[] x, double[] y, int degree) {
        int i;
        if (x.length != y.length) {
            throw new IllegalArgumentException("The arrays x and y must share the same length");
        }
        if (x.length <= degree) {
            throw new IllegalArgumentException("The arrays length must be greater than degree");
        }
        int n = x.length - 1;
        double[] t = new double[x.length];
        for (int i2 = 0; i2 < t.length; ++i2) {
            t[i2] = (double)i2 / (double)(t.length - 1);
        }
        double[] U = new double[x.length + degree + 1];
        int m = U.length - 1;
        for (i = 0; i <= degree; ++i) {
            U[i] = 0.0;
        }
        for (i = 1; i < x.length - degree; ++i) {
            U[i + degree] = (double)i / (double)(x.length - degree);
        }
        for (i = U.length - 1 - degree; i < U.length; ++i) {
            U[i] = 1.0;
        }
        double[][] N = new double[x.length][x.length];
        for (int i3 = 0; i3 < x.length; ++i3) {
            N[i3] = BSpline.computeN(U, degree, t[i3], x.length);
        }
        double[][] D = new double[x.length][2];
        for (int i4 = 0; i4 < x.length; ++i4) {
            D[i4][0] = x[i4];
            D[i4][1] = y[i4];
        }
        DoubleMatrix2D coltN = DoubleFactory2D.dense.make(N);
        DoubleMatrix2D coltD = DoubleFactory2D.dense.make(D);
        DoubleMatrix2D coltP = Algebra.ZERO.solve(coltN, coltD);
        return new BSpline(coltP.viewColumn(0).toArray(), coltP.viewColumn(1).toArray(), U);
    }

    public static BSpline createApproxBSpline(double[] x, double[] y, int degree, int hp1) {
        int i;
        if (x.length != y.length) {
            throw new IllegalArgumentException("The arrays x and y must share the same length");
        }
        if (x.length <= degree) {
            throw new IllegalArgumentException("The arrays length must be greater than degree");
        }
        int h = hp1 - 1;
        int n = x.length - 1;
        double[] t = new double[x.length];
        for (int i2 = 0; i2 < t.length; ++i2) {
            t[i2] = (double)i2 / (double)n;
        }
        int m = h + degree + 1;
        double[] U = new double[m + 1];
        for (i = 0; i <= degree; ++i) {
            U[i] = 0.0;
        }
        for (i = 1; i < hp1 - degree; ++i) {
            U[i + degree] = (double)i / (double)(hp1 - degree);
        }
        for (i = m - degree; i <= m; ++i) {
            U[i] = 1.0;
        }
        double[][] N = new double[n + 1][h + 1];
        for (int i3 = 0; i3 < N.length; ++i3) {
            N[i3] = BSpline.computeN(U, degree, t[i3], h + 1);
        }
        double[][] D = new double[x.length][2];
        for (int i4 = 0; i4 < x.length; ++i4) {
            D[i4][0] = x[i4];
            D[i4][1] = y[i4];
        }
        double[][] tempQ = new double[x.length][2];
        for (int k = 1; k < n; ++k) {
            tempQ[k][0] = D[k][0] - N[k][0] * D[0][0] - N[k][h] * D[D.length - 1][0];
            tempQ[k][1] = D[k][1] - N[k][0] * D[0][1] - N[k][h] * D[D.length - 1][1];
        }
        double[][] Q = new double[h - 1][2];
        for (int i5 = 1; i5 < h; ++i5) {
            for (int k = 1; k < n; ++k) {
                double[] dArray = Q[i5 - 1];
                dArray[0] = dArray[0] + N[k][i5] * tempQ[k][0];
                double[] dArray2 = Q[i5 - 1];
                dArray2[1] = dArray2[1] + N[k][i5] * tempQ[k][1];
            }
        }
        double[][] N2 = new double[n - 1][h - 1];
        for (int i6 = 0; i6 < N2.length; ++i6) {
            for (int j = 0; j < h - 1; ++j) {
                N2[i6][j] = N[i6 + 1][j + 1];
            }
        }
        DoubleMatrix2D coltQ = DoubleFactory2D.dense.make(Q);
        DoubleMatrix2D coltN = DoubleFactory2D.dense.make(N2);
        DoubleMatrix2D coltM = Algebra.ZERO.mult(Algebra.ZERO.transpose(coltN), coltN);
        DoubleMatrix2D coltP = Algebra.ZERO.solve(coltM, coltQ);
        double[] pxTemp = coltP.viewColumn(0).toArray();
        double[] pyTemp = coltP.viewColumn(1).toArray();
        double[] px = new double[hp1];
        double[] py = new double[hp1];
        px[0] = D[0][0];
        py[0] = D[0][1];
        px[h] = D[D.length - 1][0];
        py[h] = D[D.length - 1][1];
        for (int i7 = 0; i7 < pxTemp.length; ++i7) {
            px[i7 + 1] = pxTemp[i7];
            py[i7 + 1] = pyTemp[i7];
        }
        return new BSpline(px, py, U);
    }

    public BSpline derivativeBSpline() {
        double[] xTemp = new double[this.myX.length - 1];
        double[] yTemp = new double[this.myY.length - 1];
        for (int i = 0; i < xTemp.length; ++i) {
            xTemp[i] = (this.myX[i + 1] - this.myX[i]) * (double)this.degree / (this.knots[i + this.degree + 1] - this.knots[i + 1]);
            yTemp[i] = (this.myY[i + 1] - this.myY[i]) * (double)this.degree / (this.knots[i + this.degree + 1] - this.knots[i + 1]);
        }
        double[] newKnots = new double[this.knots.length - 2];
        for (int i = 0; i < newKnots.length; ++i) {
            newKnots[i] = this.knots[i + 1];
        }
        double[] xTemp2 = new double[this.myX.length - 1];
        double[] yTemp2 = new double[this.myY.length - 1];
        for (int i = 0; i < xTemp.length; ++i) {
            int k = 0;
            for (int j = 0; j < xTemp.length; ++j) {
                if (!(xTemp[i] > xTemp[j])) continue;
                ++k;
            }
            while (xTemp2[k] != 0.0) {
                ++k;
            }
            xTemp2[k] = xTemp[i];
            yTemp2[k] = yTemp[i];
        }
        return new BSpline(xTemp2, yTemp2, newKnots);
    }

    public BSpline derivativeBSpline(int i) {
        BSpline bs = this;
        while (i > 0) {
            --i;
            bs = bs.derivativeBSpline();
        }
        return bs;
    }

    @Override
    public double evaluate(final double u) {
        MathFunction xFunction = new MathFunction(){

            @Override
            public double evaluate(double t) {
                return BSpline.this.evalX(t) - u;
            }
        };
        double t = RootFinder.bisection(0.0, 1.0, xFunction, 1.0E-6);
        return this.evalY(t);
    }

    @Override
    public double integral(double a, double b) {
        return MathFunctionUtil.simpsonIntegral(this, a, b, 500);
    }

    @Override
    public double derivative(double u) {
        return this.derivativeBSpline().evaluate(u);
    }

    @Override
    public double derivative(double u, int n) {
        return this.derivativeBSpline(n).evaluate(u);
    }

    private void init(double[] x, double[] y, double[] initialKnots) {
        if (initialKnots == null) {
            int i;
            this.knots = new double[x.length + this.degree + 1];
            for (i = this.degree; i < this.knots.length - this.degree; ++i) {
                this.knots[i] = (double)(i - this.degree) / ((double)this.knots.length - 2.0 * (double)this.degree - 1.0);
            }
            for (i = this.knots.length - this.degree; i < this.knots.length; ++i) {
                this.knots[i] = this.knots[i - 1];
            }
            for (i = this.degree; i > 0; --i) {
                this.knots[i - 1] = this.knots[i];
            }
            this.myX = x;
            this.myY = y;
        } else {
            int i;
            this.degree = initialKnots.length - x.length - 1;
            int iBorneInf = 1;
            int iBorneSup = initialKnots.length - 2;
            while (BSpline.areEqual(initialKnots[iBorneInf], initialKnots[0], 1.0E-10)) {
                ++iBorneInf;
            }
            iBorneInf = iBorneInf <= this.degree ? this.degree - iBorneInf + 1 : 0;
            while (BSpline.areEqual(initialKnots[iBorneSup], initialKnots[initialKnots.length - 1], 1.0E-10)) {
                --iBorneSup;
            }
            iBorneSup = iBorneSup >= initialKnots.length - 1 - this.degree ? this.degree + 1 - (initialKnots.length - 1 - iBorneSup) : 0;
            this.knots = new double[initialKnots.length + iBorneInf + iBorneSup];
            this.myX = new double[x.length + iBorneInf + iBorneSup];
            this.myY = new double[y.length + iBorneInf + iBorneSup];
            for (i = 0; i < iBorneInf; ++i) {
                this.knots[i] = initialKnots[0];
                this.myX[i] = x[0];
                this.myY[i] = y[0];
            }
            for (i = 0; i < initialKnots.length; ++i) {
                this.knots[iBorneInf + i] = initialKnots[i];
            }
            for (i = 0; i < x.length; ++i) {
                this.myX[iBorneInf + i] = x[i];
                this.myY[iBorneInf + i] = y[i];
            }
            for (i = 0; i < iBorneSup; ++i) {
                this.knots[this.knots.length - 1 - i] = initialKnots[initialKnots.length - 1];
                this.myX[this.myX.length - 1 - i] = x[x.length - 1];
                this.myY[this.myY.length - 1 - i] = y[y.length - 1];
            }
        }
    }

    public double evalX(double u) {
        int k = Misc.getTimeInterval(this.knots, 0, this.knots.length - 1, u);
        if (k >= this.myX.length) {
            k = this.myX.length - 1;
        }
        double[][] X = new double[this.degree + 1][this.myX.length];
        for (int i = k - this.degree; i <= k; ++i) {
            X[0][i] = this.myX[i];
        }
        for (int j = 1; j <= this.degree; ++j) {
            for (int i = k - this.degree + j; i <= k; ++i) {
                double aij = (u - this.knots[i]) / (this.knots[i + 1 + this.degree - j] - this.knots[i]);
                X[j][i] = (1.0 - aij) * X[j - 1][i - 1] + aij * X[j - 1][i];
            }
        }
        return X[this.degree][k];
    }

    public double evalY(double u) {
        int k = Misc.getTimeInterval(this.knots, 0, this.knots.length - 1, u);
        if (k >= this.myY.length) {
            k = this.myY.length - 1;
        }
        double[][] Y = new double[this.degree + 1][this.myX.length];
        for (int i = k - this.degree; i <= k; ++i) {
            Y[0][i] = this.myY[i];
        }
        for (int j = 1; j <= this.degree; ++j) {
            for (int i = k - this.degree + j; i <= k; ++i) {
                double aij = (u - this.knots[i]) / (this.knots[i + 1 + this.degree - j] - this.knots[i]);
                Y[j][i] = (1.0 - aij) * Y[j - 1][i - 1] + aij * Y[j - 1][i];
            }
        }
        return Y[this.degree][k];
    }

    private static boolean areEqual(double a, double b, double tol) {
        return Math.abs(a - b) < tol;
    }

    private static double[] computeN(double[] U, int degree, double u, int np1) {
        double[] N = new double[np1];
        if (BSpline.areEqual(u, U[0], 1.0E-10)) {
            N[0] = 1.0;
            return N;
        }
        if (BSpline.areEqual(u, U[U.length - 1], 1.0E-10)) {
            N[N.length - 1] = 1.0;
            return N;
        }
        int k = Misc.getTimeInterval(U, 0, U.length - 1, u);
        N[k] = 1.0;
        for (int d = 1; d <= degree; ++d) {
            N[k - d] = N[k - d + 1] * (U[k + 1] - u) / (U[k + 1] - U[k - d + 1]);
            for (int i = k - d + 1; i <= k - 1; ++i) {
                N[i] = (u - U[i]) / (U[i + d] - U[i]) * N[i] + (U[i + d + 1] - u) / (U[i + d + 1] - U[i + 1]) * N[i + 1];
            }
            N[k] = (u - U[k]) / (U[k + d] - U[k]) * N[k];
        }
        return N;
    }
}

