/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.hups;

import umontreal.ssj.hups.PointSet;
import umontreal.ssj.hups.PointSetIterator;
import umontreal.ssj.util.PrintfFormat;

public class SubsetOfPointSet
extends PointSet {
    protected PointSet P;
    protected int i_from;
    protected int i_to;
    protected int[] i_index;
    protected int j_from;
    protected int j_to;
    protected int[] j_index;

    public SubsetOfPointSet(PointSet p) {
        this.P = p;
        this.numPoints = p.getNumPoints();
        this.dim = p.getDimension();
        this.i_from = 0;
        this.i_to = p.getNumPoints();
        this.j_from = 0;
        this.j_to = p.getDimension();
    }

    public void selectPointsRange(int from, int to) {
        if (0 > from || from >= to || to > this.P.getNumPoints()) {
            throw new IllegalArgumentException("Invalid range for points");
        }
        this.i_index = null;
        this.i_from = from;
        this.i_to = to;
        this.numPoints = to - from;
    }

    public void selectPoints(int[] pointIndices, int numPoints) {
        if (numPoints > this.P.getNumPoints() || numPoints > pointIndices.length) {
            throw new IllegalArgumentException("Number of indices too large");
        }
        this.i_index = pointIndices;
        this.numPoints = numPoints;
    }

    public void selectCoordinatesRange(int from, int to) {
        if (0 > from || from >= to || to > this.P.getDimension()) {
            throw new IllegalArgumentException("Invalid column range");
        }
        this.j_index = null;
        this.j_from = from;
        this.j_to = to;
        this.dim = to - from;
    }

    public void selectCoordinates(int[] coordIndices, int numCoord) {
        if (numCoord > this.P.getDimension() || numCoord > coordIndices.length) {
            throw new IllegalArgumentException("Number of indices too large");
        }
        this.j_index = coordIndices;
        this.dim = numCoord;
    }

    @Override
    public double getCoordinate(int i, int j) {
        int access_j;
        int access_i;
        if (this.i_index == null) {
            if (i < 0 || i >= this.numPoints) {
                throw new IllegalArgumentException("Row out of range");
            }
            access_i = i + this.i_from;
        } else {
            access_i = this.i_index[i];
        }
        if (this.j_index == null) {
            if (j < 0 || j > this.dim) {
                throw new IllegalArgumentException("Column out of range");
            }
            access_j = j + this.j_from;
        } else {
            access_j = this.j_index[j];
        }
        return this.P.getCoordinate(access_i, access_j);
    }

    @Override
    public PointSetIterator iterator() {
        return new SubsetIterator();
    }

    @Override
    public String toString() {
        int i;
        boolean first;
        StringBuffer sb = new StringBuffer("Subset of point set" + PrintfFormat.NEWLINE);
        sb.append("Inner point set information {" + PrintfFormat.NEWLINE);
        sb.append(this.P.toString());
        sb.append(PrintfFormat.NEWLINE + "}" + PrintfFormat.NEWLINE);
        if (this.i_index == null) {
            sb.append("Points range from " + this.i_from + " to " + this.i_to + "." + PrintfFormat.NEWLINE);
        } else {
            sb.append("Point indices: [");
            first = true;
            for (i = 0; i < this.numPoints; ++i) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(this.i_index[i]);
            }
            sb.append("]" + PrintfFormat.NEWLINE);
        }
        if (this.j_index == null) {
            sb.append("Coordinates range from " + this.j_from + " to " + this.j_to + ".");
        } else {
            sb.append("Coordinate indices: [");
            first = true;
            for (i = 0; i < this.dim; ++i) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(this.j_index[i]);
            }
            sb.append("]");
        }
        return sb.toString();
    }

    private class SubsetIterator
    extends PointSet.DefaultPointSetIterator {
        private PointSetIterator innerIterator;

        SubsetIterator() {
            this.innerIterator = SubsetOfPointSet.this.P.iterator();
            if (SubsetOfPointSet.this.i_index == null) {
                if (SubsetOfPointSet.this.i_from != 0) {
                    this.innerIterator.setCurPointIndex(SubsetOfPointSet.this.i_from);
                }
            } else if (SubsetOfPointSet.this.i_index[0] != 0) {
                this.innerIterator.setCurPointIndex(SubsetOfPointSet.this.i_index[0]);
            }
            if (SubsetOfPointSet.this.j_index == null) {
                if (SubsetOfPointSet.this.j_from != 0) {
                    this.innerIterator.setCurCoordIndex(SubsetOfPointSet.this.j_from);
                }
            } else if (SubsetOfPointSet.this.j_index[0] != 0) {
                this.innerIterator.setCurCoordIndex(SubsetOfPointSet.this.j_index[0]);
            }
        }

        @Override
        public void setCurCoordIndex(int j) {
            if (SubsetOfPointSet.this.j_index == null) {
                this.innerIterator.setCurCoordIndex(j + SubsetOfPointSet.this.j_from);
            } else {
                this.innerIterator.setCurCoordIndex(SubsetOfPointSet.this.j_index[j]);
            }
            this.curCoordIndex = j;
        }

        @Override
        public void resetCurCoordIndex() {
            if (SubsetOfPointSet.this.j_index == null) {
                if (SubsetOfPointSet.this.j_from == 0) {
                    this.innerIterator.resetCurCoordIndex();
                } else {
                    this.innerIterator.setCurCoordIndex(SubsetOfPointSet.this.j_from);
                }
            } else if (SubsetOfPointSet.this.j_index[0] == 0) {
                this.innerIterator.resetCurCoordIndex();
            } else {
                this.innerIterator.setCurCoordIndex(SubsetOfPointSet.this.j_index[0]);
            }
            this.curCoordIndex = 0;
        }

        @Override
        public double nextCoordinate() {
            if (this.curPointIndex >= SubsetOfPointSet.this.numPoints || this.curCoordIndex >= SubsetOfPointSet.this.dim) {
                this.outOfBounds();
            }
            double coord = 0.0;
            if (SubsetOfPointSet.this.j_index == null) {
                coord = this.innerIterator.nextCoordinate();
            } else {
                int currentIndex = SubsetOfPointSet.this.j_index[this.curCoordIndex];
                int futureIndex = this.curCoordIndex + 1 == SubsetOfPointSet.this.dim ? currentIndex + 1 : SubsetOfPointSet.this.j_index[this.curCoordIndex + 1];
                coord = this.innerIterator.nextCoordinate();
                if (futureIndex != currentIndex + 1) {
                    this.innerIterator.setCurCoordIndex(futureIndex);
                }
            }
            ++this.curCoordIndex;
            return coord;
        }

        @Override
        public void nextCoordinates(double[] p, int d) {
            if (this.curPointIndex >= SubsetOfPointSet.this.numPoints || this.curCoordIndex + d > SubsetOfPointSet.this.dim) {
                this.outOfBounds();
            }
            if (SubsetOfPointSet.this.j_index != null) {
                super.nextCoordinates(p, d);
                return;
            }
            this.innerIterator.nextCoordinates(p, d);
            this.curCoordIndex += d;
        }

        @Override
        public void setCurPointIndex(int i) {
            if (SubsetOfPointSet.this.i_index == null) {
                this.innerIterator.setCurPointIndex(i + SubsetOfPointSet.this.i_from);
            } else {
                this.innerIterator.setCurPointIndex(SubsetOfPointSet.this.i_index[i]);
            }
            this.curPointIndex = i;
            this.resetCurCoordIndex();
        }

        @Override
        public void resetCurPointIndex() {
            if (SubsetOfPointSet.this.i_index == null) {
                if (SubsetOfPointSet.this.i_from == 0) {
                    this.innerIterator.resetCurPointIndex();
                } else {
                    this.innerIterator.setCurPointIndex(SubsetOfPointSet.this.i_from);
                }
            } else if (SubsetOfPointSet.this.i_index[0] == 0) {
                this.innerIterator.resetCurPointIndex();
            } else {
                this.innerIterator.setCurPointIndex(SubsetOfPointSet.this.i_index[0]);
            }
            this.curPointIndex = 0;
            this.resetCurCoordIndex();
        }

        @Override
        public int resetToNextPoint() {
            if (SubsetOfPointSet.this.i_index == null) {
                this.innerIterator.resetToNextPoint();
            } else if (this.curPointIndex < SubsetOfPointSet.this.numPoints - 1) {
                this.innerIterator.setCurPointIndex(SubsetOfPointSet.this.i_index[this.curPointIndex + 1]);
            }
            ++this.curPointIndex;
            this.resetCurCoordIndex();
            return this.curPointIndex;
        }
    }
}

