/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.mcqmctools.anova;

import umontreal.ssj.mcqmctools.anova.CoordinateSet;
import umontreal.ssj.rng.RandomStream;
import umontreal.ssj.rng.RandomStreamBase;

public class SplitStream
extends RandomStreamBase {
    protected int curCoordIndex;
    protected CoordinateSet coords;
    protected double[] vals;

    public SplitStream(RandomStream stream, int nCache) {
        this.vals = new double[2 * nCache];
        this.curCoordIndex = 0;
        this.coords = null;
        stream.nextArrayOfDouble(this.vals, 0, 2 * nCache);
    }

    public SplitStream(double[] vals) {
        this.curCoordIndex = 0;
        this.coords = null;
        this.vals = vals;
    }

    @Override
    public SplitStream clone() {
        SplitStream s = new SplitStream((double[])this.vals.clone());
        s.curCoordIndex = this.curCoordIndex;
        s.coords = this.coords;
        return s;
    }

    public void setCoordinates(CoordinateSet coords) {
        this.coords = coords;
    }

    public CoordinateSet getCoordinates() {
        return this.coords;
    }

    @Override
    protected double nextValue() {
        int a = this.coords != null && this.coords.contains(this.curCoordIndex) ? 0 : 1;
        return this.vals[2 * this.curCoordIndex++ + a];
    }

    @Override
    public void resetNextSubstream() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void resetStartStream() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void resetStartSubstream() {
        this.curCoordIndex = 0;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " [nCache=" + this.vals.length / 2 + "]";
    }
}

