/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.probdist;

import umontreal.ssj.functions.MathFunction;
import umontreal.ssj.probdist.ContinuousDistribution;
import umontreal.ssj.probdist.ExponentialDist;
import umontreal.ssj.probdist.NormalDist;
import umontreal.ssj.util.Num;
import umontreal.ssj.util.RootFinder;

public class GammaDist
extends ContinuousDistribution {
    private double alpha;
    private double lambda;
    private double logFactor;
    private static final double ALIM = 100000.0;

    public GammaDist(double alpha) {
        this.setParams(alpha, 1.0, this.decPrec);
    }

    public GammaDist(double alpha, double lambda) {
        this.setParams(alpha, lambda, this.decPrec);
    }

    public GammaDist(double alpha, double lambda, int d) {
        this.setParams(alpha, lambda, d);
    }

    static double mybelog(double x) {
        double term;
        if (x < 1.0E-30) {
            return 0.0;
        }
        if (x > 1.0E30) {
            return 2.0 * (Math.log(x) - 1.0) / x;
        }
        if (x == 1.0) {
            return 1.0;
        }
        double t = 1.0 - x;
        if (x < 0.9 || x > 1.1) {
            double w = (t + x * Math.log(x)) / (t * t);
            return 2.0 * w;
        }
        double EPS = 1.0E-12;
        double tpow = 1.0;
        double sum = 0.5;
        int j = 3;
        do {
            term = (tpow *= t) / (double)(j * (j - 1));
            ++j;
        } while (Math.abs(term / (sum += term)) > 1.0E-12);
        return 2.0 * sum;
    }

    @Override
    public double density(double x) {
        if (x <= 0.0) {
            return 0.0;
        }
        double z = this.logFactor + (this.alpha - 1.0) * Math.log(x) - this.lambda * x;
        if (z > -1000.0) {
            return Math.exp(z);
        }
        return 0.0;
    }

    @Override
    public double cdf(double x) {
        return GammaDist.cdf(this.alpha, this.lambda, this.decPrec, x);
    }

    @Override
    public double barF(double x) {
        return GammaDist.barF(this.alpha, this.lambda, this.decPrec, x);
    }

    @Override
    public double inverseF(double u) {
        return GammaDist.inverseF(this.alpha, this.decPrec, u) / this.lambda;
    }

    @Override
    public double getMean() {
        return GammaDist.getMean(this.alpha, this.lambda);
    }

    @Override
    public double getVariance() {
        return GammaDist.getVariance(this.alpha, this.lambda);
    }

    @Override
    public double getStandardDeviation() {
        return GammaDist.getStandardDeviation(this.alpha, this.lambda);
    }

    public static double density(double alpha, double lambda, double x) {
        if (alpha <= 0.0) {
            throw new IllegalArgumentException("alpha <= 0");
        }
        if (lambda <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        if (x <= 0.0) {
            return 0.0;
        }
        double z = alpha * Math.log(lambda * x) - lambda * x - Num.lnGamma(alpha);
        if (z > -1000.0) {
            return Math.exp(z) / x;
        }
        return 0.0;
    }

    public static double cdf(double alpha, double lambda, int d, double x) {
        return GammaDist.cdf(alpha, d, lambda * x);
    }

    public static double cdf(double alpha, int d, double x) {
        if (alpha <= 0.0) {
            throw new IllegalArgumentException("alpha <= 0");
        }
        if (d <= 0) {
            throw new IllegalArgumentException("d <= 0");
        }
        if (x <= 0.0) {
            return 0.0;
        }
        if (1.0 == alpha) {
            return ExponentialDist.cdf(1.0, x);
        }
        if (alpha > 10.0 ? x > alpha * 10.0 : x > 100.0) {
            return 1.0;
        }
        if (alpha >= 100000.0) {
            double d2 = x + 0.3333333333333333 - alpha - 0.02 / alpha;
            double S = alpha - 0.5;
            double w = GammaDist.mybelog(S / x);
            double y = d2 * Math.sqrt(w / x);
            return NormalDist.cdf01(y);
        }
        if (x <= 1.0 || x < alpha) {
            double factor = Math.exp(alpha * Math.log(x) - x - Num.lnGamma(alpha));
            double EPS = EPSARRAY[d];
            double z = 1.0;
            double term = 1.0;
            double rn = alpha;
            while ((term *= x / (rn += 1.0)) >= EPS * (z += term)) {
            }
            return z * factor / alpha;
        }
        return 1.0 - GammaDist.barF(alpha, d, x);
    }

    public static double barF(double alpha, double lambda, int d, double x) {
        return GammaDist.barF(alpha, d, lambda * x);
    }

    /*
     * Unable to fully structure code
     */
    public static double barF(double alpha, int d, double x) {
        if (alpha <= 0.0) {
            throw new IllegalArgumentException("alpha <= 0");
        }
        if (d <= 0) {
            throw new IllegalArgumentException("d <= 0");
        }
        if (x <= 0.0) {
            return 1.0;
        }
        if (1.0 == alpha) {
            return ExponentialDist.barF(1.0, x);
        }
        if (alpha >= 70.0 ? x >= alpha * 100.0 : x >= 1000.0) {
            return 0.0;
        }
        if (alpha >= 100000.0) {
            d2 = x + 0.3333333333333333 - alpha - 0.02 / alpha;
            S = alpha - 0.5;
            w = GammaDist.mybelog(S / x);
            y = d2 * Math.sqrt(w / x);
            return NormalDist.barF01(y);
        }
        if (x <= 1.0 || x < alpha) {
            return 1.0 - GammaDist.cdf(alpha, d, x);
        }
        V = new double[6];
        EPS = GammaDist.EPSARRAY[d];
        RENORM = 1.0E100;
        factor = Math.exp(alpha * Math.log(x) - x - Num.lnGamma(alpha));
        A = 1.0 - alpha;
        B = A + x + 1.0;
        term = 0.0;
        V[0] = 1.0;
        V[1] = x;
        V[2] = x + 1.0;
        V[3] = x * B;
        res = V[2] / V[3];
        block0: while (true) {
            V[4] = (B += 2.0) * V[2] - (A += 1.0) * (term += 1.0) * V[0];
            V[5] = B * V[3] - A * term * V[1];
            if (V[5] != 0.0) {
                R = V[4] / V[5];
                dif = Math.abs(res - R);
                if (dif <= EPS * R) {
                    return factor * res;
                }
                res = R;
            }
            for (i = 0; i < 4; ++i) {
                V[i] = V[i + 2];
            }
            if (!(Math.abs(V[4]) >= 1.0E100)) continue;
            i = 0;
            while (true) {
                if (i < 4) ** break;
                continue block0;
                v0 = i++;
                V[v0] = V[v0] / 1.0E100;
            }
            break;
        }
    }

    public static double inverseF(double alpha, double lambda, int d, double u) {
        return GammaDist.inverseF(alpha, d, u) / lambda;
    }

    public static double inverseF(double alpha, int d, double u) {
        if (alpha <= 0.0) {
            throw new IllegalArgumentException("alpha <= 0");
        }
        if (u > 1.0 || u < 0.0) {
            throw new IllegalArgumentException("u not in [0,1]");
        }
        if (u <= 0.0) {
            return 0.0;
        }
        if (u >= 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        if (d <= 0) {
            throw new IllegalArgumentException("d <= 0");
        }
        if (d > 15) {
            d = 15;
        }
        double EPS = Math.pow(10.0, -d);
        double sigma = GammaDist.getStandardDeviation(alpha, 1.0);
        double x = NormalDist.inverseF(alpha, sigma, u);
        if (x < 0.0) {
            x = 0.0;
        }
        double v = GammaDist.cdf(alpha, d, x);
        double xmax = alpha < 1.0 ? 100.0 : alpha + 40.0 * sigma;
        myFunc f = new myFunc(alpha, d, u);
        if (u <= 1.0E-8 || alpha <= 1.5) {
            if (v < u) {
                return RootFinder.bisection(x, xmax, f, EPS);
            }
            return RootFinder.bisection(0.0, x, f, EPS);
        }
        if (v < u) {
            return RootFinder.brentDekker(x, xmax, f, EPS);
        }
        return RootFinder.brentDekker(0.0, x, f, EPS);
    }

    public static double[] getMLE(double[] x, int n) {
        double d;
        int i;
        double sum = 0.0;
        double sumLn = 0.0;
        double LN_EPS = -709.089565712824;
        double[] parameters = new double[2];
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        for (i = 0; i < n; ++i) {
            sum += x[i];
            if (x[i] <= 0.0) {
                sumLn += -709.089565712824;
                continue;
            }
            sumLn += Math.log(x[i]);
        }
        double empiricalMean = sum / (double)n;
        sum = 0.0;
        for (i = 0; i < n; ++i) {
            sum += (x[i] - empiricalMean) * (x[i] - empiricalMean);
        }
        double alphaMME = empiricalMean * empiricalMean * (double)n / sum;
        double a = alphaMME - 10.0;
        if (d <= 0.0) {
            a = 1.0E-5;
        }
        Function f = new Function(n, empiricalMean, sumLn);
        parameters[0] = RootFinder.brentDekker(a, alphaMME + 10.0, f, 1.0E-7);
        parameters[1] = parameters[0] / empiricalMean;
        return parameters;
    }

    public static GammaDist getInstanceFromMLE(double[] x, int n) {
        double[] parameters = GammaDist.getMLE(x, n);
        return new GammaDist(parameters[0], parameters[1]);
    }

    public static double getMean(double alpha, double lambda) {
        if (alpha <= 0.0) {
            throw new IllegalArgumentException("alpha <= 0");
        }
        if (lambda <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        return alpha / lambda;
    }

    public static double getVariance(double alpha, double lambda) {
        if (alpha <= 0.0) {
            throw new IllegalArgumentException("alpha <= 0");
        }
        if (lambda <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        return alpha / (lambda * lambda);
    }

    public static double getStandardDeviation(double alpha, double lambda) {
        if (alpha <= 0.0) {
            throw new IllegalArgumentException("alpha <= 0");
        }
        if (lambda <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        return Math.sqrt(alpha) / lambda;
    }

    public double getAlpha() {
        return this.alpha;
    }

    public double getLambda() {
        return this.lambda;
    }

    public void setParams(double alpha, double lambda, int d) {
        if (alpha <= 0.0) {
            throw new IllegalArgumentException("alpha <= 0");
        }
        if (lambda <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        this.alpha = alpha;
        this.lambda = lambda;
        this.decPrec = d;
        this.logFactor = alpha * Math.log(lambda) - Num.lnGamma(alpha);
        this.supportA = 0.0;
    }

    @Override
    public double[] getParams() {
        double[] retour = new double[]{this.alpha, this.lambda};
        return retour;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " : alpha = " + this.alpha + ", lambda = " + this.lambda;
    }

    private static class myFunc
    implements MathFunction {
        protected int d;
        protected double alp;
        protected double u;

        public myFunc(double alp, int d, double u) {
            this.alp = alp;
            this.d = d;
            this.u = u;
        }

        @Override
        public double evaluate(double x) {
            return this.u - GammaDist.cdf(this.alp, this.d, x);
        }
    }

    private static class Function
    implements MathFunction {
        private int n;
        private double empiricalMean;
        private double sumLn;

        public Function(int n, double empiricalMean, double sumLn) {
            this.n = n;
            this.empiricalMean = empiricalMean;
            this.sumLn = sumLn;
        }

        @Override
        public double evaluate(double x) {
            if (x <= 0.0) {
                return 1.0E200;
            }
            return (double)this.n * Math.log(this.empiricalMean / x) + (double)this.n * Num.digamma(x) - this.sumLn;
        }
    }
}

