/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.probdist;

import optimization.Uncmin_f77;
import optimization.Uncmin_methods;
import umontreal.ssj.probdist.ContinuousDistribution;

public class HyperbolicSecantDist
extends ContinuousDistribution {
    protected double mu;
    protected double sigma;
    private static final double ZLIMB = 500.0;
    private static final double ZLIMS = 50.0;

    public HyperbolicSecantDist(double mu, double sigma) {
        this.setParams(mu, sigma);
    }

    @Override
    public double density(double x) {
        return HyperbolicSecantDist.density(this.mu, this.sigma, x);
    }

    @Override
    public double cdf(double x) {
        return HyperbolicSecantDist.cdf(this.mu, this.sigma, x);
    }

    @Override
    public double barF(double x) {
        return HyperbolicSecantDist.barF(this.mu, this.sigma, x);
    }

    @Override
    public double inverseF(double u) {
        return HyperbolicSecantDist.inverseF(this.mu, this.sigma, u);
    }

    @Override
    public double getMean() {
        return HyperbolicSecantDist.getMean(this.mu, this.sigma);
    }

    @Override
    public double getVariance() {
        return HyperbolicSecantDist.getVariance(this.mu, this.sigma);
    }

    @Override
    public double getStandardDeviation() {
        return HyperbolicSecantDist.getStandardDeviation(this.mu, this.sigma);
    }

    public static double density(double mu, double sigma, double x) {
        if (sigma <= 0.0) {
            throw new IllegalArgumentException("sigma <= 0");
        }
        double y = (x - mu) / sigma;
        if (Math.abs(y) >= 500.0) {
            return 0.0;
        }
        return 1.0 / (Math.cosh(Math.PI * y / 2.0) * 2.0 * sigma);
    }

    public static double cdf(double mu, double sigma, double x) {
        if (sigma <= 0.0) {
            throw new IllegalArgumentException("sigma <= 0");
        }
        double y = (x - mu) / sigma;
        if (y >= 50.0) {
            return 1.0;
        }
        if (y <= -500.0) {
            return 0.0;
        }
        return 2.0 * Math.atan(Math.exp(Math.PI * y / 2.0)) / Math.PI;
    }

    public static double barF(double mu, double sigma, double x) {
        if (sigma <= 0.0) {
            throw new IllegalArgumentException("sigma <= 0");
        }
        double y = (x - mu) / sigma;
        if (y >= 500.0) {
            return 0.0;
        }
        if (y <= -50.0) {
            return 1.0;
        }
        return 0.6366197723675814 * Math.atan(Math.exp(-Math.PI * y / 2.0));
    }

    public static double inverseF(double mu, double sigma, double u) {
        if (sigma <= 0.0) {
            throw new IllegalArgumentException("sigma <= 0");
        }
        if (u < 0.0 || u > 1.0) {
            throw new IllegalArgumentException("u not in [0,1]");
        }
        if (u >= 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        if (u <= 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        return mu + 2.0 * sigma / Math.PI * Math.log(Math.tan(1.5707963267948966 * u));
    }

    public static double[] getMLE(double[] x, int n) {
        int i;
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        Optim system = new Optim(x, n);
        double[] parameters = new double[2];
        double[] xpls = new double[3];
        double[] param = new double[3];
        double[] fpls = new double[3];
        double[] gpls = new double[3];
        int[] itrcmd = new int[2];
        double[][] a = new double[3][3];
        double[] udiag = new double[3];
        double sum = 0.0;
        for (i = 0; i < n; ++i) {
            sum += x[i];
        }
        param[1] = sum / (double)n;
        sum = 0.0;
        for (i = 0; i < n; ++i) {
            sum += (x[i] - param[1]) * (x[i] - param[1]);
        }
        param[2] = Math.sqrt(sum / (double)n);
        Uncmin_f77.optif0_f77((int)2, (double[])param, (Uncmin_methods)system, (double[])xpls, (double[])fpls, (double[])gpls, (int[])itrcmd, (double[][])a, (double[])udiag);
        for (i = 0; i < 2; ++i) {
            parameters[i] = xpls[i + 1];
        }
        return parameters;
    }

    public static HyperbolicSecantDist getInstanceFromMLE(double[] x, int n) {
        double[] parameters = HyperbolicSecantDist.getMLE(x, n);
        return new HyperbolicSecantDist(parameters[0], parameters[1]);
    }

    public static double getMean(double mu, double sigma) {
        if (sigma <= 0.0) {
            throw new IllegalArgumentException("sigma <= 0");
        }
        return mu;
    }

    public static double getVariance(double mu, double sigma) {
        if (sigma <= 0.0) {
            throw new IllegalArgumentException("sigma <= 0");
        }
        return sigma * sigma;
    }

    public static double getStandardDeviation(double mu, double sigma) {
        return Math.sqrt(HyperbolicSecantDist.getVariance(mu, sigma));
    }

    public double getMu() {
        return this.mu;
    }

    public double getSigma() {
        return this.sigma;
    }

    public void setParams(double mu, double sigma) {
        if (sigma <= 0.0) {
            throw new IllegalArgumentException("sigma <= 0");
        }
        this.mu = mu;
        this.sigma = sigma;
    }

    @Override
    public double[] getParams() {
        double[] retour = new double[]{this.mu, this.sigma};
        return retour;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " : mu = " + this.mu + ", sigma = " + this.sigma;
    }

    private static class Optim
    implements Uncmin_methods {
        private int n;
        private double[] xi;

        public Optim(double[] x, int n) {
            this.n = n;
            this.xi = new double[n];
            System.arraycopy(x, 0, this.xi, 0, n);
        }

        public double f_to_minimize(double[] p) {
            double sum = 0.0;
            if (p[2] <= 0.0) {
                return 1.0E200;
            }
            for (int i = 0; i < this.n; ++i) {
                sum -= Math.log(HyperbolicSecantDist.density(p[1], p[2], this.xi[i]));
            }
            return sum;
        }

        public void gradient(double[] x, double[] g) {
        }

        public void hessian(double[] x, double[][] h) {
        }
    }
}

