/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.probdist;

import umontreal.ssj.probdist.ContinuousDistribution;

abstract class JohnsonSystem
extends ContinuousDistribution {
    protected double gamma;
    protected double delta;
    protected double xi;
    protected double lambda;

    protected JohnsonSystem(double gamma, double delta, double xi, double lambda) {
        this.setParams0(gamma, delta, xi, lambda);
    }

    public double getGamma() {
        return this.gamma;
    }

    public double getDelta() {
        return this.delta;
    }

    public double getXi() {
        return this.xi;
    }

    public double getLambda() {
        return this.lambda;
    }

    protected void setParams0(double gamma, double delta, double xi, double lambda) {
        if (lambda <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        if (delta <= 0.0) {
            throw new IllegalArgumentException("delta <= 0");
        }
        this.gamma = gamma;
        this.delta = delta;
        this.xi = xi;
        this.lambda = lambda;
    }

    @Override
    public double[] getParams() {
        double[] retour = new double[]{this.gamma, this.delta, this.xi, this.lambda};
        return retour;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " : gamma = " + this.gamma + ", delta = " + this.delta + ", xi = " + this.xi + ", lambda = " + this.lambda;
    }
}

