/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.probdist;

import umontreal.ssj.probdist.ContinuousDistribution;
import umontreal.ssj.probdist.EmpiricalDist;

public class LaplaceDist
extends ContinuousDistribution {
    private double mu;
    private double beta;

    public LaplaceDist() {
        this.mu = 0.0;
        this.beta = 1.0;
    }

    public LaplaceDist(double mu, double beta) {
        if (beta <= 0.0) {
            throw new IllegalArgumentException("beta <= 0");
        }
        this.mu = mu;
        this.beta = beta;
    }

    @Override
    public double density(double x) {
        return LaplaceDist.density(this.mu, this.beta, x);
    }

    @Override
    public double cdf(double x) {
        return LaplaceDist.cdf(this.mu, this.beta, x);
    }

    @Override
    public double barF(double x) {
        return LaplaceDist.barF(this.mu, this.beta, x);
    }

    @Override
    public double inverseF(double u) {
        return LaplaceDist.inverseF(this.mu, this.beta, u);
    }

    @Override
    public double getMean() {
        return LaplaceDist.getMean(this.mu, this.beta);
    }

    @Override
    public double getVariance() {
        return LaplaceDist.getVariance(this.mu, this.beta);
    }

    @Override
    public double getStandardDeviation() {
        return LaplaceDist.getStandardDeviation(this.mu, this.beta);
    }

    public static double density(double mu, double beta, double x) {
        if (beta <= 0.0) {
            throw new IllegalArgumentException("beta <= 0");
        }
        return Math.exp(-Math.abs(x - mu) / beta) / (2.0 * beta);
    }

    public static double cdf(double mu, double beta, double x) {
        if (x <= mu) {
            return Math.exp((x - mu) / beta) / 2.0;
        }
        return 1.0 - Math.exp((mu - x) / beta) / 2.0;
    }

    public static double barF(double mu, double beta, double x) {
        if (x <= mu) {
            return 1.0 - Math.exp((x - mu) / beta) / 2.0;
        }
        return Math.exp((mu - x) / beta) / 2.0;
    }

    public static double inverseF(double mu, double beta, double u) {
        if (u < 0.0 || u > 1.0) {
            throw new IllegalArgumentException("u should be in [0,1]");
        }
        if (u <= 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        if (u >= 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        double x = u > 0.5 ? -Math.log(2.0 - 2.0 * u) : Math.log(2.0 * u);
        return mu + beta * x;
    }

    public static double[] getMLE(double[] x, int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        double[] parameters = new double[2];
        parameters[0] = EmpiricalDist.getMedian(x, n);
        double sum = 0.0;
        for (int i = 0; i < n; ++i) {
            sum += Math.abs(x[i] - parameters[0]);
        }
        parameters[1] = sum / (double)n;
        return parameters;
    }

    public static LaplaceDist getInstanceFromMLE(double[] x, int n) {
        double[] parameters = LaplaceDist.getMLE(x, n);
        return new LaplaceDist(parameters[0], parameters[1]);
    }

    public static double getMean(double mu, double beta) {
        if (beta <= 0.0) {
            throw new IllegalArgumentException("beta <= 0");
        }
        return mu;
    }

    public static double getVariance(double mu, double beta) {
        if (beta <= 0.0) {
            throw new IllegalArgumentException("beta <= 0");
        }
        return 2.0 * beta * beta;
    }

    public static double getStandardDeviation(double mu, double beta) {
        if (beta <= 0.0) {
            throw new IllegalArgumentException("beta <= 0");
        }
        return 1.4142135623730951 * beta;
    }

    public double getMu() {
        return this.mu;
    }

    public double getBeta() {
        return this.beta;
    }

    @Override
    public double[] getParams() {
        double[] retour = new double[]{this.mu, this.beta};
        return retour;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " : mu = " + this.mu + ", beta = " + this.beta;
    }
}

