/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.randvar;

import umontreal.ssj.probdist.ContinuousDistribution;
import umontreal.ssj.probdist.ExponentialDist;
import umontreal.ssj.probdist.InverseDistFromDensity;
import umontreal.ssj.randvar.ExponentialGen;
import umontreal.ssj.rng.RandomStream;

public class ExponentialInverseFromDensityGen
extends ExponentialGen {
    public ExponentialInverseFromDensityGen(RandomStream stream, double lambda, double ueps, int order) {
        super(stream, lambda);
        double xc = Math.min(1.0, 0.5 / lambda);
        this.dist = new InverseDistFromDensity((ContinuousDistribution)this.dist, xc, ueps, order);
    }

    public ExponentialInverseFromDensityGen(RandomStream stream, ExponentialDist dist, double ueps, int order) {
        super(stream, dist);
        double xc = Math.min(1.0, 0.5 / this.lambda);
        this.dist = new InverseDistFromDensity(dist, xc, ueps, order);
    }

    public ExponentialInverseFromDensityGen(RandomStream stream, InverseDistFromDensity dist) {
        super(stream, null);
        this.lambda = -1.0;
        this.dist = dist;
    }

    public double getUepsilon() {
        return ((InverseDistFromDensity)this.dist).getEpsilon();
    }

    public int getOrder() {
        return ((InverseDistFromDensity)this.dist).getOrder();
    }
}

