/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.randvar;

import umontreal.ssj.probdist.HyperbolicSecantDist;
import umontreal.ssj.randvar.RandomVariateGen;
import umontreal.ssj.rng.RandomStream;

public class HyperbolicSecantGen
extends RandomVariateGen {
    protected double mu;
    protected double sigma;

    public HyperbolicSecantGen(RandomStream s, double mu, double sigma) {
        super(s, new HyperbolicSecantDist(mu, sigma));
        this.setParams(mu, sigma);
    }

    public HyperbolicSecantGen(RandomStream s) {
        this(s, 0.0, 1.0);
    }

    public HyperbolicSecantGen(RandomStream s, HyperbolicSecantDist dist) {
        super(s, dist);
        if (dist != null) {
            this.setParams(dist.getMu(), dist.getSigma());
        }
    }

    public static double nextDouble(RandomStream s, double mu, double sigma) {
        return HyperbolicSecantDist.inverseF(mu, sigma, s.nextDouble());
    }

    public double getMu() {
        return this.mu;
    }

    public double getSigma() {
        return this.sigma;
    }

    protected void setParams(double mu, double sigma) {
        if (sigma <= 0.0) {
            throw new IllegalArgumentException("sigma <= 0");
        }
        this.mu = mu;
        this.sigma = sigma;
    }
}

