/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.rng;

import umontreal.ssj.rng.RandomStreamBase;
import umontreal.ssj.util.ArithmeticMod;
import umontreal.ssj.util.PrintfFormat;

public class MRG32k3aL
extends RandomStreamBase {
    private static final long serialVersionUID = 70510L;
    private static final long m1 = 0xFFFFFF2FL;
    private static final long m2 = 4294944443L;
    private static final long a12 = 1403580L;
    private static final long a13n = 810728L;
    private static final long a21 = 527612L;
    private static final long a23n = 1370589L;
    private static final long two17 = 131072L;
    private static final long two53 = 0x20000000000000L;
    private static final double invtwo24 = 5.960464477539063E-8;
    private static final double norm = 2.328306549295728E-10;
    private static final long[][] A1p0 = new long[][]{{0L, 1L, 0L}, {0L, 0L, 1L}, {-810728L, 1403580L, 0L}};
    private static final long[][] A2p0 = new long[][]{{0L, 1L, 0L}, {0L, 0L, 1L}, {-1370589L, 0L, 527612L}};
    private static final long[][] A1p76 = new long[][]{{82758667L, 1871391091L, 4127413238L}, {3672831523L, 69195019L, 1871391091L}, {3672091415L, 3528743235L, 69195019L}};
    private static final long[][] A2p76 = new long[][]{{1511326704L, 3759209742L, 1610795712L}, {4292754251L, 1511326704L, 3889917532L}, {3859662829L, 4292754251L, 3708466080L}};
    private static final long[][] A1p127 = new long[][]{{2427906178L, 3580155704L, 949770784L}, {226153695L, 1230515664L, 3580155704L}, {1988835001L, 986791581L, 1230515664L}};
    private static final long[][] A2p127 = new long[][]{{1464411153L, 277697599L, 1610723613L}, {32183930L, 1464411153L, 1022607788L}, {2824425944L, 32183930L, 2093834863L}};
    private static long[] nextSeed = new long[]{12345L, 12345L, 12345L, 12345L, 12345L, 12345L};
    private long Cg0;
    private long Cg1;
    private long Cg2;
    private long Cg3;
    private long Cg4;
    private long Cg5;
    private long[] Bg = new long[6];
    private long[] Ig = new long[6];

    private static void multMatVect(long[] v, long[][] A, long m1, long[][] B, long m2) {
        int i;
        long[] vv = new long[3];
        for (i = 0; i < 3; ++i) {
            vv[i] = v[i];
        }
        ArithmeticMod.matVecModM(A, vv, vv, m1);
        for (i = 0; i < 3; ++i) {
            v[i] = vv[i];
        }
        for (i = 0; i < 3; ++i) {
            vv[i] = v[i + 3];
        }
        ArithmeticMod.matVecModM(B, vv, vv, m2);
        for (i = 0; i < 3; ++i) {
            v[i + 3] = vv[i];
        }
    }

    public MRG32k3aL() {
        this.name = null;
        this.anti = false;
        this.prec53 = false;
        for (int i = 0; i < 6; ++i) {
            this.Ig[i] = nextSeed[i];
        }
        this.resetStartStream();
        MRG32k3aL.multMatVect(nextSeed, A1p127, 0xFFFFFF2FL, A2p127, 4294944443L);
    }

    public MRG32k3aL(String name) {
        this();
        this.name = name;
    }

    public static void setPackageSeed(long[] seed) {
        MRG32k3aL.validateSeed(seed);
        for (int i = 0; i < 6; ++i) {
            MRG32k3aL.nextSeed[i] = seed[i];
        }
    }

    public void setSeed(long[] seed) {
        MRG32k3aL.validateSeed(seed);
        for (int i = 0; i < 6; ++i) {
            this.Ig[i] = seed[i];
        }
        this.resetStartStream();
    }

    @Override
    public void resetStartStream() {
        for (int i = 0; i < 6; ++i) {
            this.Bg[i] = this.Ig[i];
        }
        this.resetStartSubstream();
    }

    @Override
    public void resetStartSubstream() {
        this.Cg0 = this.Bg[0];
        this.Cg1 = this.Bg[1];
        this.Cg2 = this.Bg[2];
        this.Cg3 = this.Bg[3];
        this.Cg4 = this.Bg[4];
        this.Cg5 = this.Bg[5];
    }

    @Override
    public void resetNextSubstream() {
        MRG32k3aL.multMatVect(this.Bg, A1p76, 0xFFFFFF2FL, A2p76, 4294944443L);
        this.resetStartSubstream();
    }

    public long[] getState() {
        return new long[]{this.Cg0, this.Cg1, this.Cg2, this.Cg3, this.Cg4, this.Cg5};
    }

    @Override
    public String toString() {
        PrintfFormat str = new PrintfFormat();
        str.append("The current state of the MRG32k3aL");
        if (this.name != null && this.name.length() > 0) {
            str.append(" " + this.name);
        }
        str.append(":" + PrintfFormat.NEWLINE + "   Cg = { ");
        str.append(this.Cg0 + ", ");
        str.append(this.Cg1 + ", ");
        str.append(this.Cg2 + ", ");
        str.append(this.Cg3 + ", ");
        str.append(this.Cg4 + ", ");
        str.append(this.Cg5 + " }" + PrintfFormat.NEWLINE + PrintfFormat.NEWLINE);
        return str.toString();
    }

    public String toStringFull() {
        int i;
        PrintfFormat str = new PrintfFormat();
        str.append("The MRG32k3aL stream");
        if (this.name != null && this.name.length() > 0) {
            str.append(" " + this.name);
        }
        str.append(":" + PrintfFormat.NEWLINE + "   anti = " + (this.anti ? "true" : "false")).append(PrintfFormat.NEWLINE);
        str.append("   prec53 = " + (this.prec53 ? "true" : "false")).append(PrintfFormat.NEWLINE);
        str.append("   Ig = { ");
        for (i = 0; i < 5; ++i) {
            str.append(this.Ig[i] + ", ");
        }
        str.append(this.Ig[5] + " }" + PrintfFormat.NEWLINE);
        str.append("   Bg = { ");
        for (i = 0; i < 5; ++i) {
            str.append(this.Bg[i] + ", ");
        }
        str.append(this.Bg[5] + " }" + PrintfFormat.NEWLINE);
        str.append("   Cg = { ");
        str.append(this.Cg0 + ", ");
        str.append(this.Cg1 + ", ");
        str.append(this.Cg2 + ", ");
        str.append(this.Cg3 + ", ");
        str.append(this.Cg4 + ", ");
        str.append(this.Cg5 + " }" + PrintfFormat.NEWLINE + PrintfFormat.NEWLINE);
        return str.toString();
    }

    @Override
    public MRG32k3aL clone() {
        MRG32k3aL retour = null;
        retour = (MRG32k3aL)super.clone();
        retour.Bg = new long[6];
        retour.Ig = new long[6];
        for (int i = 0; i < 6; ++i) {
            retour.Bg[i] = this.Bg[i];
            retour.Ig[i] = this.Ig[i];
        }
        return retour;
    }

    @Override
    protected double nextValue() {
        long p1 = (1403580L * this.Cg1 - 810728L * this.Cg0) % 0xFFFFFF2FL;
        if (p1 < 0L) {
            p1 += 0xFFFFFF2FL;
        }
        this.Cg0 = this.Cg1;
        this.Cg1 = this.Cg2;
        this.Cg2 = p1;
        long p2 = (527612L * this.Cg5 - 1370589L * this.Cg3) % 4294944443L;
        if (p2 < 0L) {
            p2 += 4294944443L;
        }
        this.Cg3 = this.Cg4;
        this.Cg4 = this.Cg5;
        this.Cg5 = p2;
        return p1 > p2 ? (double)(p1 - p2) * 2.328306549295728E-10 : (double)(p1 - p2 + 0xFFFFFF2FL) * 2.328306549295728E-10;
    }

    private static void validateSeed(long[] seed) {
        if (seed.length < 6) {
            throw new IllegalArgumentException("Seed must contain 6 values");
        }
        if (seed[0] == 0L && seed[1] == 0L && seed[2] == 0L) {
            throw new IllegalArgumentException("The first 3 values must not be 0");
        }
        if (seed[3] == 0L && seed[4] == 0L && seed[5] == 0L) {
            throw new IllegalArgumentException("The last 3 values must not be 0");
        }
        long m1 = 0xFFFFFF2FL;
        if (seed[0] >= 0xFFFFFF2FL || seed[1] >= 0xFFFFFF2FL || seed[2] >= 0xFFFFFF2FL) {
            throw new IllegalArgumentException("The first 3 values must be less than 4294967087");
        }
        long m2 = 4294944443L;
        if (seed[3] >= 4294944443L || seed[4] >= 4294944443L || seed[5] >= 4294944443L) {
            throw new IllegalArgumentException("The last 3 values must be less than 4294944443");
        }
    }
}

