/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.rng;

import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.RandomAccess;
import umontreal.ssj.rng.RandomStream;

public class RandomPermutation {
    private static final int SHUFFLE_THRESHOLD = 5;

    @Deprecated
    public static void init(byte[] array, int n) {
        for (int k = 1; k <= n; k = (int)((byte)(k + 1))) {
            array[k - 1] = k;
        }
    }

    @Deprecated
    public static void init(short[] array, int n) {
        for (int k = 1; k <= n; k = (int)((short)(k + 1))) {
            array[k - 1] = k;
        }
    }

    @Deprecated
    public static void init(int[] array, int n) {
        for (int k = 1; k <= n; ++k) {
            array[k - 1] = k;
        }
    }

    @Deprecated
    public static void init(long[] array, int n) {
        for (int k = 1; k <= n; ++k) {
            array[k - 1] = k;
        }
    }

    @Deprecated
    public static void init(float[] array, int n) {
        for (int k = 1; k <= n; ++k) {
            array[k - 1] = k;
        }
    }

    @Deprecated
    public static void init(double[] array, int n) {
        for (int k = 1; k <= n; ++k) {
            array[k - 1] = k;
        }
    }

    public static void shuffle(List<?> list, RandomStream stream) {
        int size = list.size();
        if (size < 5 || list instanceof RandomAccess) {
            for (int i = size; i > 1; --i) {
                Collections.swap(list, i - 1, stream.nextInt(0, i - 1));
            }
        } else {
            Object[] arr = list.toArray();
            RandomPermutation.shuffle(arr, stream);
            ListIterator<?> it = list.listIterator();
            for (Object element : arr) {
                it.next();
                it.set(element);
            }
        }
    }

    public static void shuffle(Object[] array, RandomStream stream) {
        int size = array.length;
        for (int i = size - 1; i > 0; --i) {
            int j = stream.nextInt(0, i);
            Object tmp = array[i];
            array[i] = array[j];
            array[j] = tmp;
        }
    }

    public static void shuffle(byte[] array, RandomStream stream) {
        int size = array.length;
        for (int i = size - 1; i > 0; --i) {
            int j = stream.nextInt(0, i);
            byte tmp = array[i];
            array[i] = array[j];
            array[j] = tmp;
        }
    }

    public static void shuffle(short[] array, RandomStream stream) {
        int size = array.length;
        for (int i = size - 1; i > 0; --i) {
            int j = stream.nextInt(0, i);
            short tmp = array[i];
            array[i] = array[j];
            array[j] = tmp;
        }
    }

    public static void shuffle(int[] array, RandomStream stream) {
        int size = array.length;
        for (int i = size - 1; i > 0; --i) {
            int j = stream.nextInt(0, i);
            int tmp = array[i];
            array[i] = array[j];
            array[j] = tmp;
        }
    }

    public static void shuffle(long[] array, RandomStream stream) {
        int size = array.length;
        for (int i = size - 1; i > 0; --i) {
            int j = stream.nextInt(0, i);
            long tmp = array[i];
            array[i] = array[j];
            array[j] = tmp;
        }
    }

    public static void shuffle(char[] array, RandomStream stream) {
        int size = array.length;
        for (int i = size - 1; i > 0; --i) {
            int j = stream.nextInt(0, i);
            char tmp = array[i];
            array[i] = array[j];
            array[j] = tmp;
        }
    }

    public static void shuffle(boolean[] array, RandomStream stream) {
        int size = array.length;
        for (int i = size - 1; i > 0; --i) {
            int j = stream.nextInt(0, i);
            boolean tmp = array[i];
            array[i] = array[j];
            array[j] = tmp;
        }
    }

    public static void shuffle(float[] array, RandomStream stream) {
        int size = array.length;
        for (int i = size - 1; i > 0; --i) {
            int j = stream.nextInt(0, i);
            float tmp = array[i];
            array[i] = array[j];
            array[j] = tmp;
        }
    }

    public static void shuffle(double[] array, RandomStream stream) {
        int size = array.length;
        for (int i = size - 1; i > 0; --i) {
            int j = stream.nextInt(0, i);
            double tmp = array[i];
            array[i] = array[j];
            array[j] = tmp;
        }
    }

    public static void shuffle(List<?> list, int k, RandomStream stream) {
        int size = list.size();
        if (k < 0 || k > size) {
            throw new IllegalArgumentException("k must be   0 <= k <= list.size()");
        }
        if (0 == k) {
            return;
        }
        if (size < 5 || list instanceof RandomAccess) {
            for (int i = 0; i < k; ++i) {
                int j = stream.nextInt(i, size - 1);
                Collections.swap(list, i, j);
            }
        } else {
            Object[] arr = list.toArray();
            RandomPermutation.shuffle(arr, size, k, stream);
            ListIterator<?> it = list.listIterator();
            for (Object element : arr) {
                it.next();
                it.set(element);
            }
        }
    }

    public static void shuffle(Object[] array, int n, int k, RandomStream stream) {
        if (k < 0 || k > n) {
            throw new IllegalArgumentException("k must be   0 <= k <= n");
        }
        for (int i = 0; i < k; ++i) {
            int j = stream.nextInt(i, n - 1);
            Object temp = array[j];
            array[j] = array[i];
            array[i] = temp;
        }
    }

    public static void shuffle(byte[] array, int n, int k, RandomStream stream) {
        if (k < 0 || k > n) {
            throw new IllegalArgumentException("k must be   0 <= k <= n");
        }
        for (int i = 0; i < k; ++i) {
            int j = stream.nextInt(i, n - 1);
            byte temp = array[j];
            array[j] = array[i];
            array[i] = temp;
        }
    }

    public static void shuffle(short[] array, int n, int k, RandomStream stream) {
        if (k < 0 || k > n) {
            throw new IllegalArgumentException("k must be   0 <= k <= n");
        }
        for (int i = 0; i < k; ++i) {
            int j = stream.nextInt(i, n - 1);
            short temp = array[j];
            array[j] = array[i];
            array[i] = temp;
        }
    }

    public static void shuffle(int[] array, int n, int k, RandomStream stream) {
        if (k < 0 || k > n) {
            throw new IllegalArgumentException("k must be   0 <= k <= n");
        }
        for (int i = 0; i < k; ++i) {
            int j = stream.nextInt(i, n - 1);
            int temp = array[j];
            array[j] = array[i];
            array[i] = temp;
        }
    }

    public static void shuffle(long[] array, int n, int k, RandomStream stream) {
        if (k < 0 || k > n) {
            throw new IllegalArgumentException("k must be   0 <= k <= n");
        }
        for (int i = 0; i < k; ++i) {
            int j = stream.nextInt(i, n - 1);
            long temp = array[j];
            array[j] = array[i];
            array[i] = temp;
        }
    }

    public static void shuffle(char[] array, int n, int k, RandomStream stream) {
        if (k < 0 || k > n) {
            throw new IllegalArgumentException("k must be   0 <= k <= n");
        }
        for (int i = 0; i < k; ++i) {
            int j = stream.nextInt(i, n - 1);
            char temp = array[j];
            array[j] = array[i];
            array[i] = temp;
        }
    }

    public static void shuffle(boolean[] array, int n, int k, RandomStream stream) {
        if (k < 0 || k > n) {
            throw new IllegalArgumentException("k must be   0 <= k <= n");
        }
        for (int i = 0; i < k; ++i) {
            int j = stream.nextInt(i, n - 1);
            boolean temp = array[j];
            array[j] = array[i];
            array[i] = temp;
        }
    }

    public static void shuffle(float[] array, int n, int k, RandomStream stream) {
        if (k < 0 || k > n) {
            throw new IllegalArgumentException("k must be   0 <= k <= n");
        }
        for (int i = 0; i < k; ++i) {
            int j = stream.nextInt(i, n - 1);
            float temp = array[j];
            array[j] = array[i];
            array[i] = temp;
        }
    }

    public static void shuffle(double[] array, int n, int k, RandomStream stream) {
        if (k < 0 || k > n) {
            throw new IllegalArgumentException("k must be   0 <= k <= n");
        }
        for (int i = 0; i < k; ++i) {
            int j = stream.nextInt(i, n - 1);
            double temp = array[j];
            array[j] = array[i];
            array[i] = temp;
        }
    }
}

