/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.simevents.eventlist;

import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import umontreal.ssj.simevents.Event;
import umontreal.ssj.simevents.eventlist.EventList;
import umontreal.ssj.util.PrintfFormat;

public class BinaryTree
implements EventList {
    private Entry root = null;
    private int modCount = 0;

    @Override
    public boolean isEmpty() {
        return this.root == null;
    }

    @Override
    public void clear() {
        while (this.root != null) {
            this.remove(this.root);
        }
    }

    @Override
    public void add(Event ev) {
        Entry cursor = this.root;
        boolean found = false;
        if (cursor == null) {
            this.root = this.add(ev, null);
        } else {
            while (!found) {
                if (ev.compareTo(cursor.event) < 0) {
                    if (cursor.left == null) {
                        cursor.left = this.add(ev, cursor);
                        found = true;
                    }
                    cursor = cursor.left;
                    continue;
                }
                if (cursor.right == null) {
                    cursor.right = this.add(ev, cursor);
                    found = true;
                }
                cursor = cursor.right;
            }
        }
        ++this.modCount;
    }

    @Override
    public void addFirst(Event ev) {
        Entry cursor = this.root;
        if (cursor != null) {
            while (cursor.left != null) {
                cursor = cursor.left;
            }
            Entry e = this.add(ev, cursor.father);
            e.right = cursor;
            if (cursor == this.root) {
                this.root = e;
            } else {
                cursor.father.left = e;
            }
            cursor.father = e;
        } else {
            this.root = this.add(ev, null);
        }
        ++this.modCount;
    }

    @Override
    public void addBefore(Event ev, Event other) {
        Entry otherEntry = this.findEntry(other);
        Entry evEntry = this.add(ev, null);
        if (otherEntry == null) {
            throw new IllegalArgumentException("other not in the tree");
        }
        if (otherEntry != this.root) {
            if (otherEntry == otherEntry.father.right) {
                otherEntry.father.right = evEntry;
            } else {
                otherEntry.father.left = evEntry;
            }
        } else {
            this.root = evEntry;
        }
        evEntry.father = otherEntry.father;
        otherEntry.father = evEntry;
        evEntry.right = otherEntry;
        evEntry.left = otherEntry.left;
        if (evEntry.left != null) {
            evEntry.left.father = evEntry;
        }
        otherEntry.left = null;
        ++this.modCount;
    }

    @Override
    public void addAfter(Event ev, Event other) {
        Entry otherEntry = this.findEntry(other);
        if (otherEntry == null) {
            throw new IllegalArgumentException("other not in the tree");
        }
        Entry evEntry = this.add(ev, otherEntry);
        evEntry.right = otherEntry.right;
        otherEntry.right = evEntry;
        if (evEntry.right != null) {
            evEntry.right.father = evEntry;
        }
        ++this.modCount;
    }

    @Override
    public Event getFirst() {
        if (this.root == null) {
            return null;
        }
        Entry cursor = this.root;
        while (cursor.left != null) {
            cursor = cursor.left;
        }
        return cursor.event;
    }

    @Override
    public Event getFirstOfClass(String cl) {
        Entry cursor = this.root;
        if (this.root != null) {
            while (cursor.left != null) {
                cursor = cursor.left;
            }
        }
        while (cursor != null) {
            if (cursor.event.getClass().getName().equals(cl)) {
                return cursor.event;
            }
            cursor = this.successor(cursor);
        }
        return null;
    }

    @Override
    public <E extends Event> E getFirstOfClass(Class<E> cl) {
        Entry cursor = this.root;
        if (this.root != null) {
            while (cursor.left != null) {
                cursor = cursor.left;
            }
        }
        while (cursor != null) {
            if (cursor.event.getClass() == cl) {
                return (E)cursor.event;
            }
            cursor = this.successor(cursor);
        }
        return null;
    }

    @Override
    public Iterator<Event> iterator() {
        return this.listIterator();
    }

    @Override
    public ListIterator<Event> listIterator() {
        return new BTItr();
    }

    @Override
    public boolean remove(Event ev) {
        Entry evEntry = this.findEntry(ev);
        if (evEntry == null) {
            return false;
        }
        return this.remove(evEntry);
    }

    @Override
    public Event removeFirst() {
        if (this.root == null) {
            return null;
        }
        Entry cursor = this.root;
        while (cursor.left != null) {
            cursor = cursor.left;
        }
        Event first = cursor.event;
        this.remove(cursor);
        return first;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Contents of the event list BinaryTree:");
        Entry cursor = this.root;
        if (this.root != null) {
            while (cursor.left != null) {
                cursor = cursor.left;
            }
        }
        while (cursor != null) {
            sb.append(PrintfFormat.NEWLINE + PrintfFormat.g(12, 7, cursor.event.time()) + ", " + PrintfFormat.g(8, 4, cursor.event.priority()) + " : " + cursor.event.toString());
            cursor = this.successor(cursor);
        }
        return sb.toString();
    }

    private Entry add(Event ev, Entry father) {
        return new Entry(ev, null, null, father);
    }

    private boolean remove(Entry e) {
        boolean filsGauche = false;
        boolean isRoot = false;
        if (e == this.root) {
            isRoot = true;
        } else {
            filsGauche = e == e.father.left;
        }
        if (e.left == null) {
            if (isRoot) {
                this.root = e.right;
            } else if (filsGauche) {
                e.father.left = e.right;
            } else {
                e.father.right = e.right;
            }
            if (e.right != null) {
                e.right.father = e.father;
            }
        } else if (e.right == null) {
            if (isRoot) {
                this.root = e.left;
            } else if (filsGauche) {
                e.father.left = e.left;
            } else {
                e.father.right = e.left;
            }
            e.left.father = e.father;
        } else {
            Entry cursor = e.right;
            if (cursor.left == null) {
                if (isRoot) {
                    this.root = cursor;
                } else if (filsGauche) {
                    e.father.left = cursor;
                } else {
                    e.father.right = cursor;
                }
                cursor.left = e.left;
            } else {
                while (cursor.left != null) {
                    cursor = cursor.left;
                }
                if (isRoot) {
                    this.root = cursor;
                } else if (filsGauche) {
                    e.father.left = cursor;
                } else {
                    e.father.right = cursor;
                }
                cursor.father.left = cursor.right;
                if (cursor.right != null) {
                    cursor.right.father = cursor.father;
                }
                cursor.right = e.right;
                cursor.left = e.left;
                e.right.father = cursor;
            }
            cursor.father = e.father;
            e.left.father = cursor;
        }
        e.right = null;
        e.left = null;
        e.event = null;
        ++this.modCount;
        return true;
    }

    private Entry successor(Entry cursor) {
        if (cursor == null) {
            return null;
        }
        if (cursor.right != null) {
            cursor = cursor.right;
            while (cursor.left != null) {
                cursor = cursor.left;
            }
        } else {
            while (cursor.father != null && cursor.father.right == cursor) {
                cursor = cursor.father;
            }
            cursor = cursor.father;
        }
        return cursor;
    }

    private Entry findEntry(Event ev) {
        Entry cursor = this.root;
        while (cursor != null) {
            if (cursor.event == ev) {
                return cursor;
            }
            if (ev.compareTo(cursor.event) < 0) {
                cursor = cursor.left;
                continue;
            }
            cursor = cursor.right;
        }
        return null;
    }

    private Entry predecessor(Entry cursor) {
        if (cursor == null) {
            return null;
        }
        if (cursor.left != null) {
            cursor = cursor.left;
            while (cursor.right != null) {
                cursor = cursor.right;
            }
        } else {
            while (cursor.father != null && cursor.father.left == cursor) {
                cursor = cursor.father;
            }
            cursor = cursor.father;
        }
        return cursor;
    }

    private class BTItr
    implements ListIterator<Event> {
        private Entry prev = null;
        private Entry next;
        private Entry lastRet;
        private int expectedModCount;
        private int nextIndex;

        BTItr() {
            this.next = BinaryTree.this.root;
            if (this.next != null) {
                while (this.next.left != null) {
                    this.next = this.next.left;
                }
            }
            this.expectedModCount = BinaryTree.this.modCount;
            this.lastRet = null;
            this.nextIndex = 0;
        }

        @Override
        public void add(Event ev) {
            if (BinaryTree.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (this.next != null && ev.compareTo(this.next.event) > 0) {
                ev.setTime(this.next.event.time());
                ev.setPriority(this.next.event.priority());
            }
            if (this.prev != null && ev.compareTo(this.prev.event) < 0) {
                ev.setTime(this.prev.event.time());
                ev.setPriority(this.prev.event.priority());
            }
            Entry e = BinaryTree.this.add(ev, this.next);
            if (this.prev != null) {
                e.father = this.prev;
                e.right = this.prev.right;
                this.prev.right = e;
                if (e.right != null) {
                    e.right.father = e;
                }
            } else {
                if (this.next != BinaryTree.this.root) {
                    if (this.next == this.next.father.left) {
                        this.next.father.left = e;
                    } else {
                        this.next.father.right = e;
                    }
                } else {
                    BinaryTree.this.root = e;
                }
                e.father = this.prev.father;
                this.prev.father = e;
                e.left = this.prev;
                e.right = this.prev.right;
                if (e.right != null) {
                    e.right.father = e;
                }
                this.prev.right = null;
            }
            this.prev = e;
            ++this.nextIndex;
            this.lastRet = null;
            ++BinaryTree.this.modCount;
            ++this.expectedModCount;
        }

        @Override
        public boolean hasNext() {
            if (BinaryTree.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            return this.next != null;
        }

        @Override
        public boolean hasPrevious() {
            if (BinaryTree.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            return this.prev != null;
        }

        @Override
        public Event next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ++this.nextIndex;
            Event ev = this.next.event;
            this.lastRet = this.next;
            this.prev = this.next;
            this.next = BinaryTree.this.successor(this.next);
            return ev;
        }

        @Override
        public int nextIndex() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.nextIndex;
        }

        @Override
        public Event previous() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            --this.nextIndex;
            Event ev = this.prev.event;
            this.lastRet = this.prev;
            this.next = this.prev;
            this.prev = BinaryTree.this.predecessor(this.prev);
            return ev;
        }

        @Override
        public int previousIndex() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            return this.nextIndex - 1;
        }

        @Override
        public void remove() {
            if (BinaryTree.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (this.lastRet == null) {
                throw new IllegalStateException();
            }
            if (this.lastRet == this.next) {
                this.next = BinaryTree.this.successor(this.next);
            } else {
                this.prev = BinaryTree.this.predecessor(this.prev);
                --this.nextIndex;
            }
            BinaryTree.this.remove(this.lastRet);
            this.lastRet = null;
            ++this.expectedModCount;
        }

        @Override
        public void set(Event ev) {
            if (BinaryTree.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (this.lastRet == null) {
                throw new IllegalStateException();
            }
            Entry pred = BinaryTree.this.predecessor(this.lastRet);
            Entry succ = BinaryTree.this.successor(this.lastRet);
            if (pred != null && ev.compareTo(pred.event) < 0) {
                ev.setTime(pred.event.time());
                ev.setPriority(pred.event.priority());
            }
            if (succ != null && ev.compareTo(succ.event) > 0) {
                ev.setTime(succ.event.time());
                ev.setPriority(succ.event.priority());
            }
            this.lastRet.event = ev;
        }
    }

    private static class Entry {
        Event event;
        Entry right;
        Entry left;
        Entry father;

        Entry(Event event, Entry left, Entry right, Entry father) {
            this.event = event;
            this.left = left;
            this.right = right;
            this.father = father;
        }
    }
}

